/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplustools.item.breaker;

import com.daqem.jobsplustools.item.Tiers;
import com.daqem.jobsplustools.item.breaker.BlockBreaker;
import com.daqem.jobsplustools.item.mode.IMode;
import com.daqem.jobsplustools.item.mode.ModeItem;
import com.daqem.jobsplustools.item.mode.breaker.multi.MultiBlockBreakerMode;
import com.daqem.jobsplustools.item.mode.breaker.multi.MultiBlockBreakerModes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public interface MultiBlockBreaker
extends ModeItem,
BlockBreaker {
    @Override
    default public void breakBlocks(class_3222 player, class_1937 level, class_2338 pos, class_2680 state) {
        if (player.method_5715()) {
            return;
        }
        this.getBlocksToMine((class_1657)player, level).forEach(blockPos -> this.breakBlock(player, (class_2338)blockPos, level));
    }

    default public List<class_2338> getBlocksToMine(class_1657 player, class_1937 level) {
        if (player.method_5715()) {
            return new ArrayList<class_2338>();
        }
        MultiBlockBreakerMode mode = (MultiBlockBreakerMode)this.getActiveMode(player.method_6047());
        int rangeX = mode.getRangeX() / 2;
        int rangeY = mode.getRangeY() / 2;
        int rangeZ = mode.getRangeZ() / 2;
        class_3965 blockHitResult = this.getBlockHitResult(player, level);
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_2350.class_2351 axis = blockHitResult.method_17780().method_10166();
        int[] adjustedRanges = this.adjustRanges(axis, rangeX, rangeY, rangeZ);
        return this.getBlocksInRange(player, level, blockHitResult.method_17777(), adjustedRanges[0], adjustedRanges[1], adjustedRanges[2]);
    }

    default public List<class_2338> getBlocksInRange(class_1657 player, class_1937 level, class_2338 pos, int rangeX, int rangeY, int rangeZ) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        for (int x = -rangeX; x <= rangeX; ++x) {
            for (int y = -rangeY; y <= rangeY; ++y) {
                for (int z = -rangeZ; z <= rangeZ; ++z) {
                    class_2338 offset = pos.method_10069(x, y, z);
                    class_2680 blockState = level.method_8320(offset);
                    if (!player.method_6047().method_7951(blockState)) continue;
                    blocks.add(offset);
                }
            }
        }
        return blocks;
    }

    private int[] adjustRanges(class_2350.class_2351 axis, int rangeX, int rangeY, int rangeZ) {
        if (axis == class_2350.class_2351.field_11052) {
            return new int[]{rangeX, rangeZ, rangeY};
        }
        if (axis == class_2350.class_2351.field_11048) {
            return new int[]{rangeZ, rangeY, rangeX};
        }
        return new int[]{rangeX, rangeY, rangeZ};
    }

    public static List<IMode> generateAvailableModes(class_1832 tier) {
        return switch ((Tiers)tier) {
            case Tiers.IRON -> Arrays.asList(MultiBlockBreakerModes.ONE_BY_ONE, MultiBlockBreakerModes.THREE_BY_THREE, MultiBlockBreakerModes.THREE_BY_THREE_BY_THREE);
            case Tiers.GOLD, Tiers.DIAMOND -> Arrays.asList(MultiBlockBreakerModes.ONE_BY_ONE, MultiBlockBreakerModes.THREE_BY_THREE, MultiBlockBreakerModes.THREE_BY_THREE_BY_THREE, MultiBlockBreakerModes.FIVE_BY_FIVE);
            case Tiers.NETHERITE -> Arrays.asList(MultiBlockBreakerModes.ONE_BY_ONE, MultiBlockBreakerModes.THREE_BY_THREE, MultiBlockBreakerModes.THREE_BY_THREE_BY_THREE, MultiBlockBreakerModes.FIVE_BY_FIVE, MultiBlockBreakerModes.FIVE_BY_FIVE_BY_FIVE);
            default -> List.of(MultiBlockBreakerModes.ONE_BY_ONE, MultiBlockBreakerModes.THREE_BY_THREE);
        };
    }
}

