/*
 * Decompiled with CFR 0.152.
 */
package net.jobsaddon.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jobsaddon.access.JobsManagerAccess;
import net.jobsaddon.init.ConfigInit;
import net.jobsaddon.jobs.JobsManager;
import net.jobsaddon.network.JobsClientPacket;
import net.levelz.init.KeyInit;
import net.libz.api.Tab;
import net.libz.util.DrawTabHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class JobScreen
extends class_437
implements Tab {
    private static final class_2960 BACKGROUND_TEXTURE = new class_2960("jobsaddon:textures/gui/job_background.png");
    private static final class_2960 ICON_TEXTURES = new class_2960("jobsaddon:textures/gui/icons.png");
    private static final class_2960 JOB_BUTTON_TEXTURES = new class_2960("jobsaddon:textures/gui/job_buttons.png");
    private static final List<String> jobNames = new ArrayList<String>(List.of("lumberjack", "farmer", "builder", "fisher", "miner", "warrior", "smither", "brewer"));
    private final WidgetButtonPage[] jobButtons = new WidgetButtonPage[8];
    @Nullable
    private JobsManager jobsManager = null;
    private int backgroundWidth = 200;
    private int backgroundHeight = 215;
    private int x;
    private int y;
    private boolean hadEmployedTimer = false;

    public JobScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.jobsaddon.jobs_screen"));
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        this.jobsManager = this.field_22787 != null && this.field_22787.field_1724 != null ? ((JobsManagerAccess)this.field_22787.field_1724).getJobsManager() : null;
        int l = 7;
        int o = 0;
        for (int i = 0; i < this.jobButtons.length; ++i) {
            int jobInt = i;
            this.jobButtons[i] = (WidgetButtonPage)this.method_37063((class_364)new WidgetButtonPage(this.x + l, this.y + 47 + 41 * i - o, button -> {
                if (button.field_22763) {
                    boolean isEmployed = ((WidgetButtonPage)button).isEmployedButton();
                    if (isEmployed) {
                        this.jobsManager.quitJob(jobNames.get(jobInt));
                    } else {
                        this.jobsManager.employJob(jobNames.get(jobInt));
                        this.jobsManager.setEmployedJobTime(ConfigInit.CONFIG.jobChangeTime);
                    }
                    JobsClientPacket.writeC2SSelectJobPacket(this.jobsManager, jobNames.get(jobInt), !isEmployed);
                    ((WidgetButtonPage)button).setEmployedButton(!isEmployed);
                    for (int k = 0; k < this.jobButtons.length; ++k) {
                        this.jobButtons[k].field_22763 = !this.jobsManager.hasMaxEmployedJobs() && this.jobsManager.getEmployedJobTime() == 0 || this.jobsManager.isEmployedJob(jobNames.get(k));
                    }
                }
            }));
            if (this.jobsManager != null) {
                this.jobButtons[i].setEmployedButton(this.jobsManager.isEmployedJob(jobNames.get(i)));
                boolean bl = this.jobButtons[i].field_22763 = this.jobsManager.canEmployJob(jobNames.get(i)) || this.jobsManager.isEmployedJob(jobNames.get(i));
            }
            if (i != 3) continue;
            l = 102;
            o = 164;
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        int i = (this.field_22789 - this.backgroundWidth) / 2;
        int j = (this.field_22790 - this.backgroundHeight) / 2;
        context.method_25290(BACKGROUND_TEXTURE, i, j, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, 256, 256);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.field_22787.field_1724 != null) {
            class_5250 title = class_2561.method_43469((String)"text.jobsaddon.gui.title", (Object[])new Object[]{this.field_22787.field_1724.method_5477().getString()});
            context.method_51439(this.field_22793, (class_2561)title, this.x + this.backgroundWidth / 2 - this.field_22787.field_1772.method_27525((class_5348)title) / 2, this.y + 7, 0x3F3F3F, false);
        }
        class_2561 timeText = null;
        class_5250 employedText = null;
        if (this.jobsManager != null) {
            if (this.jobsManager.getEmployedJobTime() > 0) {
                int seconds = this.jobsManager.getEmployedJobTime() / 20;
                String string = seconds >= 3600 ? String.format("%02d:%02d:%02d", seconds / 3600, seconds % 3600 / 60, seconds % 60) : String.format("%02d:%02d", seconds % 3600 / 60, seconds % 60);
                if (!this.hadEmployedTimer) {
                    this.hadEmployedTimer = true;
                }
                timeText = class_2561.method_30163((String)(class_2561.method_43471((String)"text.jobsaddon.employedTime").getString() + string));
            } else {
                if (this.hadEmployedTimer) {
                    this.hadEmployedTimer = false;
                    for (int k = 0; k < this.jobButtons.length; ++k) {
                        this.jobButtons[k].field_22763 = !this.jobsManager.hasMaxEmployedJobs() || this.jobsManager.isEmployedJob(jobNames.get(k));
                    }
                }
                timeText = class_2561.method_30163((String)(class_2561.method_43471((String)"text.jobsaddon.employedTime").getString() + "00:00"));
            }
            employedText = this.jobsManager.getEmployedJobs() != null && this.jobsManager.getEmployedJobs().size() > 0 ? (this.jobsManager.getEmployedJobs().size() > 2 ? class_2561.method_43469((String)"text.jobsaddon.tooManyEmployedJobs", (Object[])new Object[]{this.getJobTitle(this.jobsManager.getEmployedJobs().get(0)), this.getJobTitle(this.jobsManager.getEmployedJobs().get(1))}) : (this.jobsManager.getEmployedJobs().size() == 1 ? class_2561.method_43469((String)"text.jobsaddon.employedJob", (Object[])new Object[]{this.getJobTitle(this.jobsManager.getEmployedJobs().get(0))}) : class_2561.method_43469((String)"text.jobsaddon.employedJobs", (Object[])new Object[]{this.getJobTitle(this.jobsManager.getEmployedJobs().get(0)), this.getJobTitle(this.jobsManager.getEmployedJobs().get(1))}))) : class_2561.method_43471((String)"text.jobsaddon.notEmployed");
        }
        if (timeText != null) {
            context.method_51439(this.field_22793, timeText, this.x + 12, this.y + 20, 0x3F3F3F, false);
        }
        if (employedText != null) {
            context.method_51439(this.field_22793, employedText, this.x + 12, this.y + 33, 0x3F3F3F, false);
        }
        for (int o = 0; o < 2; ++o) {
            for (int u = 0; u < 4; ++u) {
                int jobInt = (o != 0 ? 4 : 0) + u;
                int xPos = this.x + (jobInt > 3 ? 95 : 0);
                int yPos = this.y + jobInt * 41 - (jobInt > 3 ? 164 : 0);
                context.method_25302(ICON_TEXTURES, xPos + 12, yPos + 76, 0, 0, 81, 5);
                if (this.jobsManager == null) continue;
                String jobName = jobNames.get(jobInt);
                int jobXP = this.jobsManager.getJobXP(jobName);
                context.method_51439(this.field_22793, this.getJobTitle(jobName), xPos + 30, yPos + 51, 0xFFFFFF, false);
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"text.jobsaddon.jobLevel", (Object[])new Object[]{this.jobsManager.getJobLevel(jobName), ConfigInit.CONFIG.jobMaxLevel}), xPos + 42, yPos + 66, 0xFFFFFF, false);
                context.method_25302(ICON_TEXTURES, xPos + 12, yPos + 52, jobInt * 14, 10, 14, 14);
                if (this.isPointWithinBounds(xPos + 12 - this.x, yPos + 52 - this.y, 14, 14, mouseX, mouseY)) {
                    ArrayList tooltip = new ArrayList();
                    this.getJobTooltip(jobName).forEach(text -> tooltip.add(class_2561.method_30163((String)text)));
                    context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
                }
                if (this.jobsManager.getNextJobLevelExperience(jobName) <= 0 || jobXP <= 0) continue;
                context.method_25302(ICON_TEXTURES, xPos + 12, yPos + 76, 0, 5, 80 * jobXP / this.jobsManager.getNextJobLevelExperience(jobName), 5);
                if (!this.isPointWithinBounds(xPos + 12 - this.x, yPos + 76 - this.y, 81, 5, mouseX, mouseY)) continue;
                context.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)"text.jobsaddon.jobLevelExperience", (Object[])new Object[]{jobXP, this.jobsManager.getNextJobLevelExperience(jobName)}), mouseX, mouseY);
            }
        }
        DrawTabHelper.drawTab((class_310)this.field_22787, (class_332)context, (class_437)this, (int)this.x, (int)this.y, (int)mouseX, (int)mouseY);
    }

    public boolean method_25404(int ch, int keyCode, int modifiers) {
        if (KeyInit.screenKey.method_1417(ch, keyCode) || Objects.requireNonNull(this.field_22787).field_1690.field_1822.method_1417(ch, keyCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(ch, keyCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DrawTabHelper.onTabButtonClick((class_310)this.field_22787, (class_437)this, (int)this.x, (int)this.y, (double)mouseX, (double)mouseY, (boolean)false);
        return super.method_25402(mouseX, mouseY, button);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPointWithinBounds(int x, int y, int width, int height, double pointX, double pointY) {
        double d;
        double d2;
        int i = this.x;
        int j = this.y;
        pointX -= (double)i;
        if (!(d2 >= (double)(x - 1))) return false;
        if (!(pointX < (double)(x + width + 1))) return false;
        pointY -= (double)j;
        if (!(d >= (double)(y - 1))) return false;
        if (!(pointY < (double)(y + height + 1))) return false;
        return true;
    }

    private class_2561 getJobTitle(String string) {
        switch (string) {
            case "brewer": {
                return class_2561.method_43471((String)"text.jobsaddon.brewer");
            }
            case "builder": {
                return class_2561.method_43471((String)"text.jobsaddon.builder");
            }
            case "farmer": {
                return class_2561.method_43471((String)"text.jobsaddon.farmer");
            }
            case "fisher": {
                return class_2561.method_43471((String)"text.jobsaddon.fisher");
            }
            case "lumberjack": {
                return class_2561.method_43471((String)"text.jobsaddon.lumberjack");
            }
            case "miner": {
                return class_2561.method_43471((String)"text.jobsaddon.miner");
            }
            case "smither": {
                return class_2561.method_43471((String)"text.jobsaddon.smither");
            }
            case "warrior": {
                return class_2561.method_43471((String)"text.jobsaddon.warrior");
            }
        }
        return class_2561.method_43471((String)"text.jobsaddon.nonJobTitle");
    }

    private List<String> getJobTooltip(String string) {
        String tooltip = switch (string) {
            case "brewer" -> class_2561.method_43471((String)"text.jobsaddon.brewer.tooltip").getString();
            case "builder" -> class_2561.method_43471((String)"text.jobsaddon.builder.tooltip").getString();
            case "farmer" -> class_2561.method_43471((String)"text.jobsaddon.farmer.tooltip").getString();
            case "fisher" -> class_2561.method_43471((String)"text.jobsaddon.fisher.tooltip").getString();
            case "lumberjack" -> class_2561.method_43471((String)"text.jobsaddon.lumberjack.tooltip").getString();
            case "miner" -> class_2561.method_43471((String)"text.jobsaddon.miner.tooltip").getString();
            case "smither" -> class_2561.method_43471((String)"text.jobsaddon.smither.tooltip").getString();
            case "warrior" -> class_2561.method_43471((String)"text.jobsaddon.warrior.tooltip").getString();
            default -> class_2561.method_43471((String)"text.jobsaddon.nonJobTitle.tooltip").getString();
        };
        return List.of(tooltip.split("\n"));
    }

    private class WidgetButtonPage
    extends class_4185 {
        private List<class_2561> tooltip;
        private boolean employed;

        public WidgetButtonPage(int x, int y, class_4185.class_4241 onPress) {
            super(x, y, 91, 38, class_5244.field_39003, onPress, field_40754);
            this.tooltip = new ArrayList<class_2561>();
            this.employed = false;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_310 minecraftClient = class_310.method_1551();
            context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int i = this.getTextureY();
            if (this.isEmployedButton()) {
                i = 3;
                if (this.method_49606()) {
                    i = 4;
                }
            }
            context.method_25302(JOB_BUTTON_TEXTURES, this.method_46426(), this.method_46427(), 0, i * 38, this.field_22758, this.field_22759);
            if (this.method_49606()) {
                context.method_51434(minecraftClient.field_1772, this.tooltip, mouseX, mouseY);
            }
        }

        public void setEmployedButton(boolean employed) {
            this.employed = employed;
        }

        public boolean isEmployedButton() {
            return this.employed;
        }

        private int getTextureY() {
            int i = 1;
            if (!this.field_22763) {
                i = 0;
            } else if (this.method_25367()) {
                i = 2;
            }
            return i;
        }
    }
}

