/*
 * Decompiled with CFR 0.152.
 */
package net.jobsaddon.jobs;

import com.glisco.numismaticoverhaul.ModComponents;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.jobsaddon.init.ConfigInit;
import net.jobsaddon.init.CriteriaInit;
import net.jobsaddon.network.JobsServerPacket;
import net.levelz.access.PlayerSyncAccess;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_267;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class JobsManager {
    private int brewerLevel;
    private int builderLevel;
    private int farmerLevel;
    private int fisherLevel;
    private int lumberjackLevel;
    private int minerLevel;
    private int smitherLevel;
    private int warriorLevel;
    private int brewerXP;
    private int builderXP;
    private int farmerXP;
    private int fisherXP;
    private int lumberjackXP;
    private int minerXP;
    private int smitherXP;
    private int warriorXP;
    private ArrayList<String> employedJobsList = new ArrayList();
    private int employedJobTime;

    public void readNbt(class_2487 tag) {
        if (tag.method_10573("BrewerLevel", 99)) {
            this.brewerLevel = tag.method_10550("BrewerLevel");
            this.builderLevel = tag.method_10550("BuilderLevel");
            this.farmerLevel = tag.method_10550("FarmerLevel");
            this.fisherLevel = tag.method_10550("FisherLevel");
            this.lumberjackLevel = tag.method_10550("LumberjackLevel");
            this.minerLevel = tag.method_10550("MinerLevel");
            this.smitherLevel = tag.method_10550("SmitherLevel");
            this.warriorLevel = tag.method_10550("WarriorLevel");
            this.brewerXP = tag.method_10550("BrewerXP");
            this.builderXP = tag.method_10550("BuilderXP");
            this.farmerXP = tag.method_10550("FarmerXP");
            this.fisherXP = tag.method_10550("FisherXP");
            this.lumberjackXP = tag.method_10550("LumberjackXP");
            this.minerXP = tag.method_10550("MinerXP");
            this.smitherXP = tag.method_10550("SmitherXP");
            this.warriorXP = tag.method_10550("WarriorXP");
            int employedJobCount = tag.method_10550("EmployedJobCount");
            if (employedJobCount > 0) {
                this.employedJobsList.clear();
                for (int i = 0; i < employedJobCount; ++i) {
                    this.employedJobsList.add(tag.method_10558("EmployedJob" + i));
                }
            }
            this.employedJobTime = tag.method_10550("EmployedJobTime");
        }
    }

    public void writeNbt(class_2487 tag) {
        tag.method_10569("BrewerLevel", this.brewerLevel);
        tag.method_10569("BuilderLevel", this.builderLevel);
        tag.method_10569("FarmerLevel", this.farmerLevel);
        tag.method_10569("FisherLevel", this.fisherLevel);
        tag.method_10569("LumberjackLevel", this.lumberjackLevel);
        tag.method_10569("MinerLevel", this.minerLevel);
        tag.method_10569("SmitherLevel", this.smitherLevel);
        tag.method_10569("WarriorLevel", this.warriorLevel);
        tag.method_10569("BrewerXP", this.brewerXP);
        tag.method_10569("BuilderXP", this.builderXP);
        tag.method_10569("FarmerXP", this.farmerXP);
        tag.method_10569("FisherXP", this.fisherXP);
        tag.method_10569("LumberjackXP", this.lumberjackXP);
        tag.method_10569("MinerXP", this.minerXP);
        tag.method_10569("SmitherXP", this.smitherXP);
        tag.method_10569("WarriorXP", this.warriorXP);
        if (!this.employedJobsList.isEmpty()) {
            for (int i = 0; i < this.employedJobsList.size(); ++i) {
                tag.method_10582("EmployedJob" + i, this.employedJobsList.get(i));
            }
        }
        tag.method_10569("EmployedJobCount", this.employedJobsList.size());
        tag.method_10569("EmployedJobTime", this.employedJobTime);
    }

    public void setJobLevel(String string, int level) {
        switch (string) {
            case "brewer": {
                this.brewerLevel = level;
                break;
            }
            case "builder": {
                this.builderLevel = level;
                break;
            }
            case "farmer": {
                this.farmerLevel = level;
                break;
            }
            case "fisher": {
                this.fisherLevel = level;
                break;
            }
            case "lumberjack": {
                this.lumberjackLevel = level;
                break;
            }
            case "miner": {
                this.minerLevel = level;
                break;
            }
            case "smither": {
                this.smitherLevel = level;
                break;
            }
            case "warrior": {
                this.warriorLevel = level;
                break;
            }
        }
    }

    public int getJobLevel(String string) {
        switch (string) {
            case "brewer": {
                return this.brewerLevel;
            }
            case "builder": {
                return this.builderLevel;
            }
            case "farmer": {
                return this.farmerLevel;
            }
            case "fisher": {
                return this.fisherLevel;
            }
            case "lumberjack": {
                return this.lumberjackLevel;
            }
            case "miner": {
                return this.minerLevel;
            }
            case "smither": {
                return this.smitherLevel;
            }
            case "warrior": {
                return this.warriorLevel;
            }
        }
        return 0;
    }

    public void setJobXP(String string, int amount) {
        switch (string) {
            case "brewer": {
                this.brewerXP = amount;
                break;
            }
            case "builder": {
                this.builderXP = amount;
                break;
            }
            case "farmer": {
                this.farmerXP = amount;
                break;
            }
            case "fisher": {
                this.fisherXP = amount;
                break;
            }
            case "lumberjack": {
                this.lumberjackXP = amount;
                break;
            }
            case "miner": {
                this.minerXP = amount;
                break;
            }
            case "smither": {
                this.smitherXP = amount;
                break;
            }
            case "warrior": {
                this.warriorXP = amount;
                break;
            }
        }
    }

    public int getJobXP(String string) {
        switch (string) {
            case "brewer": {
                return this.brewerXP;
            }
            case "builder": {
                return this.builderXP;
            }
            case "farmer": {
                return this.farmerXP;
            }
            case "fisher": {
                return this.fisherXP;
            }
            case "lumberjack": {
                return this.lumberjackXP;
            }
            case "miner": {
                return this.minerXP;
            }
            case "smither": {
                return this.smitherXP;
            }
            case "warrior": {
                return this.warriorXP;
            }
        }
        return 0;
    }

    public void addJobXP(class_1657 playerEntity, String string, int XP) {
        if (!this.isJobMaxLevel(string)) {
            int currentJobXp;
            for (currentJobXp = this.getJobXP(string) + XP; this.getNextJobLevelExperience(string) < currentJobXp && !this.isJobMaxLevel(string); currentJobXp -= this.getNextJobLevelExperience(string)) {
                this.addJobExperienceLevels(playerEntity, string, 1);
                playerEntity.method_37908().method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_14709, playerEntity.method_5634(), 1.0f, 1.0f);
                if (playerEntity.method_37908().method_8608()) continue;
                playerEntity.method_7327().method_1162(CriteriaInit.JOBS, playerEntity.method_5820(), class_267::method_1130);
                CriteriaInit.JOB_UP.trigger((class_3222)playerEntity, string, this.getJobLevel(string));
                JobsServerPacket.writeS2CJobPacket(this, (class_3222)playerEntity);
            }
            this.setJobXP(string, currentJobXp);
        }
    }

    public void addJobExperienceLevels(class_1657 playerEntity, String string, int levels) {
        int jobLevel = this.getJobLevel(string);
        if (jobLevel < ConfigInit.CONFIG.jobMaxLevel) {
            this.setJobLevel(string, jobLevel += levels);
        }
        if (jobLevel < 0) {
            jobLevel = 0;
            this.setJobLevel(string, jobLevel);
        }
        if (!playerEntity.method_37908().method_8608()) {
            if (FabricLoader.getInstance().isModLoaded("numismatic-overhaul") && ConfigInit.CONFIG.moneyMultiplicator > 0) {
                CurrencyComponent playerBalance = (CurrencyComponent)ModComponents.CURRENCY.get((Object)playerEntity);
                playerBalance.silentModify((long)(jobLevel * ConfigInit.CONFIG.moneyMultiplicator));
            }
            if (ConfigInit.CONFIG.levelZXPMultiplicator > 0) {
                ((PlayerSyncAccess)playerEntity).addLevelExperience(ConfigInit.CONFIG.levelZXPMultiplicator * jobLevel);
            }
            if (ConfigInit.CONFIG.xpMultiplicator > 0) {
                playerEntity.method_7255(ConfigInit.CONFIG.xpMultiplicator * jobLevel);
            }
        }
    }

    public void employJob(String jobName) {
        if (!this.isEmployedJob(jobName)) {
            this.employedJobsList.add(jobName);
        }
    }

    public void quitJob(String jobName) {
        if (this.isEmployedJob(jobName)) {
            this.employedJobsList.remove(jobName);
        }
    }

    public boolean isEmployedJob(String jobName) {
        return this.employedJobsList.contains(jobName);
    }

    public boolean canEmployJob(String string) {
        return !this.isEmployedJob(string) && this.employedJobsList.size() < ConfigInit.CONFIG.employedJobs && this.getEmployedJobTime() == 0;
    }

    public boolean hasMaxEmployedJobs() {
        return this.employedJobsList != null && this.employedJobsList.size() == ConfigInit.CONFIG.employedJobs;
    }

    @Nullable
    public ArrayList<String> getEmployedJobs() {
        return this.employedJobsList.isEmpty() ? null : this.employedJobsList;
    }

    public boolean isJobMaxLevel(String string) {
        if (ConfigInit.CONFIG.allowMaxLvlProgress) {
            return false;
        }
        return this.getJobLevel(string) >= ConfigInit.CONFIG.jobMaxLevel;
    }

    public int getEmployedJobTime() {
        return this.employedJobTime;
    }

    public void setEmployedJobTime(int time) {
        this.employedJobTime = time;
    }

    public int getNextJobLevelExperience(String string) {
        if (this.isJobMaxLevel(string)) {
            return 0;
        }
        int experienceCost = (int)((double)ConfigInit.CONFIG.jobXPBaseCost + (double)ConfigInit.CONFIG.jobXPCostMultiplicator * Math.pow(this.getJobLevel(string), ConfigInit.CONFIG.jobXPExponent));
        if (ConfigInit.CONFIG.jobXPMaxCost != 0) {
            return experienceCost >= ConfigInit.CONFIG.jobXPMaxCost ? ConfigInit.CONFIG.jobXPMaxCost : experienceCost;
        }
        return experienceCost;
    }
}

