/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.jmoverlay.waystones;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IOverlayListener;
import journeymap.client.api.display.IThemeButton;
import journeymap.client.api.display.MarkerOverlay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.TextProperties;
import me.frankv.jmi.JMI;
import me.frankv.jmi.jmoverlay.JMOverlayManager;
import me.frankv.jmi.jmoverlay.ToggleableOverlay;
import me.frankv.jmi.jmoverlay.waystones.WaystoneMarkerListener;
import me.frankv.jmi.util.OverlayHelper;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public enum WaystoneMarker implements ToggleableOverlay
{
    INSTANCE;

    private IClientAPI jmAPI;
    private class_310 mc = class_310.method_1551();
    private boolean activated = true;
    private final String buttonLabel = "Waystones Overlay";
    private final int order = 2;
    private HashMap<ComparableWaystone, MarkerOverlay> markers = new HashMap();
    private Set<ComparableWaystone> waystones = new HashSet<ComparableWaystone>();

    private WaystoneMarker() {
        JMOverlayManager.INSTANCE.registerOverlay(this);
    }

    @Override
    public void init(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
    }

    private void createMarker(ComparableWaystone waystone) {
        class_2960 marker = new class_2960("jmi:images/waystone.png");
        MapImage icon = new MapImage(marker, 32, 32).setAnchorX(12.0).setAnchorY(24.0).setDisplayWidth(24.0).setDisplayHeight(24.0).setColor(JMI.clientConfig.getWaystoneColor().intValue());
        TextProperties textProperties = new TextProperties().setBackgroundOpacity(0.4f).setOpacity(1.0f);
        MarkerOverlay markerOverlay = new MarkerOverlay("jmi", "waystone_" + waystone.pos, waystone.pos, icon);
        markerOverlay.setDimension(waystone.dim).setLabel(waystone.name).setTextProperties(textProperties);
        markerOverlay.setOverlayListener((IOverlayListener)new WaystoneMarkerListener(markerOverlay, this.jmAPI));
        this.markers.put(waystone, markerOverlay);
        if (this.activated) {
            OverlayHelper.showOverlay((Displayable)markerOverlay);
        }
    }

    private void removeMarker(ComparableWaystone waystone) {
        if (!this.markers.containsKey(waystone)) {
            return;
        }
        try {
            this.jmAPI.remove((Displayable)this.markers.remove(waystone));
            this.markers.remove(waystone);
        }
        catch (Exception e) {
            JMI.LOGGER.error(String.valueOf(e));
        }
    }

    private void createMarkersOnMappingStarted() {
        class_638 level = this.mc.field_1687;
        if (level == null) {
            return;
        }
        for (ComparableWaystone data : this.waystones) {
            if (!data.dim.equals((Object)level.method_27983())) continue;
            this.createMarker(data);
        }
    }

    @Override
    public void onToggle(IThemeButton button) {
        if (this.activated) {
            OverlayHelper.removeOverlays(this.markers.values());
        } else {
            OverlayHelper.showOverlays(this.markers.values());
        }
        this.activated = !this.activated;
        button.setToggled(Boolean.valueOf(this.activated));
    }

    @Override
    public void onJMEvent(ClientEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        switch (event.type) {
            case MAPPING_STARTED: {
                this.createMarkersOnMappingStarted();
                JMI.LOGGER.debug("re-added waystones overlays");
                break;
            }
            case MAPPING_STOPPED: {
                this.markers.clear();
            }
        }
    }

    public void onKnownWaystones(KnownWaystonesEvent event) {
        if (!JMI.clientConfig.getWaystone().booleanValue()) {
            return;
        }
        HashSet<ComparableWaystone> newWaystones = new HashSet<ComparableWaystone>(ComparableWaystone.fromEvent(event));
        HashSet<ComparableWaystone> oldWaystones = new HashSet<ComparableWaystone>(this.markers.keySet());
        if (newWaystones.size() == 1 && oldWaystones.size() > 2) {
            return;
        }
        HashSet<ComparableWaystone> addWaystones = new HashSet<ComparableWaystone>(newWaystones);
        HashSet<ComparableWaystone> rmvWaystones = new HashSet<ComparableWaystone>(oldWaystones);
        rmvWaystones.removeAll(newWaystones);
        addWaystones.removeAll(oldWaystones);
        rmvWaystones.forEach(this::removeMarker);
        addWaystones.forEach(this::createMarker);
        this.waystones = newWaystones;
    }

    @Override
    public boolean isEnabled() {
        return JMI.waystones;
    }

    @Override
    public String getButtonIconName() {
        return "waypoints";
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public String getButtonLabel() {
        return this.buttonLabel;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public Set<ComparableWaystone> getWaystones() {
        return this.waystones;
    }

    record ComparableWaystone(UUID uuid, String name, class_2338 pos, class_5321<class_1937> dim) {
        public static Set<ComparableWaystone> fromEvent(KnownWaystonesEvent event) {
            HashSet<ComparableWaystone> waystones = new HashSet<ComparableWaystone>();
            event.getWaystones().forEach(w -> {
                if (!w.hasName()) {
                    return;
                }
                waystones.add(new ComparableWaystone(w.getWaystoneUid(), w.getName(), w.getPos(), (class_5321<class_1937>)w.getDimension()));
            });
            return waystones;
        }
    }
}

