/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.items;

import com.mojang.util.UUIDTypeAdapter;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.items.KeyItem;
import tech.thatgravyboat.ironchests.common.utils.ModUtils;

public class KeyRingItem
extends KeyItem {
    public KeyRingItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public boolean hasChest(class_1799 stack) {
        return stack.method_7985() && this.getKeys(stack).method_10546() > 0;
    }

    @Override
    public boolean canAddNewChest(class_1799 stack) {
        return !stack.method_7985() || this.getKeys(stack).method_10546() < 8;
    }

    @Override
    public boolean canUseOn(class_1657 player, class_1799 stack, GenericChestBlockEntity chest) {
        if (this.hasChest(stack)) {
            for (String uuid : this.getKeys(stack).method_10541()) {
                try {
                    if (!chest.isRightKey(UUIDTypeAdapter.fromString((String)uuid))) continue;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return false;
    }

    @Override
    public void addKey(class_1799 stack, GenericChestBlockEntity chest) {
        if (chest.getKeyId() != null) {
            class_2487 keys = this.getKeys(stack);
            class_2487 key = new class_2487();
            key.method_10566("chest", (class_2520)class_2512.method_10692((class_2338)chest.method_11016()));
            key.method_10582("chestType", class_2561.class_2562.method_10867((class_2561)chest.method_5476()));
            keys.method_10566(UUIDTypeAdapter.fromUUID((UUID)chest.getKeyId()), (class_2520)key);
            class_2487 orCreateTag = stack.method_7948();
            orCreateTag.method_10566("keys", (class_2520)keys);
            stack.method_7980(orCreateTag);
        }
    }

    private class_2487 getKeys(class_1799 stack) {
        return stack.method_7948().method_10562("keys");
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> list, @NotNull class_1836 tooltipFlag) {
        list.add((class_2561)class_2561.method_43471((String)"item.key.keyring.desc"));
        ModUtils.getTag(stack).ifPresent(ctag -> ctag.method_10562("keys").method_10541().forEach(uuid -> {
            class_2487 tag = ctag.method_10562("keys").method_10562(uuid);
            if (tag.method_10545("chest") && tag.method_10545("chestType")) {
                class_2338 pos = class_2512.method_10691((class_2487)tag.method_10562("chest"));
                class_5250 chestType = class_2561.class_2562.method_10877((String)tag.method_10558("chestType"));
                if (chestType != null) {
                    list.add((class_2561)class_2561.method_43469((String)"item.key.keychest", (Object[])new Object[]{chestType, pos.method_10263(), pos.method_10264(), pos.method_10260()}));
                }
            }
        }));
        super.method_7851(stack, level, list, tooltipFlag);
    }
}

