/*
 * Decompiled with CFR 0.152.
 */
package interactic;

import interactic.ItemFilterItem;
import interactic.ItemFilterScreenHandler;
import interactic.util.Helpers;
import interactic.util.InteracticConfig;
import interactic.util.InteracticPlayerExtension;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import net.minecraft.class_7923;

public class InteracticInit
implements ModInitializer {
    public static final String MOD_ID = "interactic";
    private static class_1792 ITEM_FILTER = null;
    private static final InteracticConfig CONFIG = InteracticConfig.createAndLoad();
    private static float itemRotationSpeedMultiplier = 1.0f;
    public static final class_3917<ItemFilterScreenHandler> ITEM_FILTER_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960("interactic", "item_filter"), (Object)new class_3917(ItemFilterScreenHandler::new, class_7701.field_40183));

    public void onInitialize() {
        CONFIG.subscribeToClientOnlyMode(clientOnlyMode -> {
            if (!clientOnlyMode.booleanValue()) {
                return;
            }
            CONFIG.itemsActAsProjectiles(false);
            CONFIG.itemThrowing(false);
            CONFIG.itemFilterEnabled(false);
            CONFIG.autoPickup(true);
            CONFIG.rightClickPickup(false);
        });
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToItemsActAsProjectiles, CONFIG::itemsActAsProjectiles, false);
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToItemThrowing, CONFIG::itemThrowing, false);
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToItemFilterEnabled, CONFIG::itemFilterEnabled, false);
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToAutoPickup, CONFIG::autoPickup, true);
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToRightClickPickup, CONFIG::rightClickPickup, false);
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            itemRotationSpeedMultiplier = 0.5f;
        }
        if (CONFIG.itemFilterEnabled()) {
            ITEM_FILTER = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "item_filter"), (Object)((Object)new ItemFilterItem()));
            ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960(MOD_ID, "filter_mode_request"), (server, player, handler, buf, responseSender) -> {
                boolean newMode = buf.readBoolean();
                server.execute(() -> {
                    class_1703 patt2685$temp = player.field_7512;
                    if (!(patt2685$temp instanceof ItemFilterScreenHandler)) {
                        return;
                    }
                    ItemFilterScreenHandler filterHandler = (ItemFilterScreenHandler)patt2685$temp;
                    filterHandler.setFilterMode(newMode);
                });
            });
        }
        if (CONFIG.rightClickPickup()) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960(MOD_ID, "pickup"), (server, player, handler, buf, responseSender) -> server.execute(() -> {
                class_1542 item = Helpers.raycastItem(player.method_14242(), 6.0f);
                if (item == null) {
                    return;
                }
                if (player.method_31548().method_7394(item.method_6983().method_7972())) {
                    player.method_6103((class_1297)item, item.method_6983().method_7947());
                    item.method_31472();
                }
            }));
        }
        if (CONFIG.itemThrowing()) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960(MOD_ID, "drop_with_power"), (server, player, handler, buf, responseSender) -> {
                float power = buf.readFloat();
                boolean dropAll = buf.readBoolean();
                server.execute(() -> {
                    ((InteracticPlayerExtension)player).setDropPower(power);
                    this.dropSelected((class_1657)player, dropAll);
                });
            });
        }
    }

    public static class_1792 getItemFilter() {
        return ITEM_FILTER;
    }

    private static void enforceInClientOnlyMode(Consumer<Consumer<Boolean>> eventSource, Consumer<Boolean> setter, boolean defaultValue) {
        eventSource.accept(value -> {
            if (!CONFIG.clientOnlyMode()) {
                return;
            }
            if (value != defaultValue) {
                setter.accept(defaultValue);
            }
        });
    }

    private void dropSelected(class_1657 player, boolean dropAll) {
        player.method_7329(player.method_31548().method_5434(player.method_31548().field_7545, dropAll && !player.method_31548().method_7391().method_7960() ? player.method_31548().method_7391().method_7947() : 1), false, true);
    }

    public static float getItemRotationSpeedMultiplier() {
        return itemRotationSpeedMultiplier;
    }

    public static InteracticConfig getConfig() {
        return CONFIG;
    }
}

