/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.cobalt.network.Message;
import immersive_paintings.resources.ByteImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public abstract class SegmentedPaintingMessage
extends Message {
    private final byte[] data;
    private final int segment;
    private final int totalSegments;
    private static final Map<String, List<byte[]>> buffer = new HashMap<String, List<byte[]>>();

    public SegmentedPaintingMessage(byte[] data, int segment, int totalSegments) {
        this.data = data;
        this.segment = segment;
        this.totalSegments = totalSegments;
    }

    public SegmentedPaintingMessage(class_2540 b) {
        this.data = b.method_10795();
        this.segment = b.readInt();
        this.totalSegments = b.readInt();
    }

    protected abstract String getIdentifier(class_1657 var1);

    protected abstract void process(class_1657 var1, ByteImage var2);

    @Override
    public void encode(class_2540 b) {
        b.method_10813(this.data);
        b.writeInt(this.segment);
        b.writeInt(this.totalSegments);
    }

    @Override
    public void receive(class_1657 e) {
        String i = this.getIdentifier(e);
        List byteBuffer = buffer.computeIfAbsent(i, k -> new LinkedList());
        byteBuffer.add(this.data);
        if (this.segment + 1 == this.totalSegments) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (byte[] b : byteBuffer) {
                try {
                    outputStream.write(b);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                ByteImage image = ByteImage.read(outputStream.toByteArray());
                this.process(e, image);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            buffer.remove(i);
        }
    }
}

