/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.item;

import immersive_aircraft.item.VehicleItem;
import immersive_machinery.entity.BambooBee;
import immersive_machinery.item.MachineryItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooBeeItem
extends MachineryItem {
    public static final String TAG = "ContainerPositions";

    public BambooBeeItem(class_1792.class_1793 settings, VehicleItem.VehicleConstructor constructor) {
        super(settings, constructor);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        class_2499 positions = this.getPositions(stack);
        if (positions.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_machinery.bamboo_bee.tooltip.help1"));
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.immersive_machinery.bamboo_bee.tooltip.help2"));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"gui.immersive_machinery.bamboo_bee.tooltip.header", (Object[])new Object[]{positions.size()}));
            for (int i = 0; i < positions.size(); ++i) {
                class_2487 tag = positions.method_10602(i);
                String name = tag.method_10558("name");
                boolean input = tag.method_10577("input");
                String key = "gui.immersive_machinery.bamboo_bee.tooltip." + (input ? "input" : "output");
                tooltip.add((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{class_2561.method_43471((String)name)}).method_27692(input ? class_124.field_1060 : class_124.field_1075));
            }
        }
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_2586 blockEntity = context.method_8045().method_8321(context.method_8037());
        if (context.method_8046()) {
            if (!context.method_8045().method_8608()) {
                if (blockEntity instanceof class_1263) {
                    String name = class_7923.field_41175.method_10221((Object)blockEntity.method_11010().method_26204()).method_42093("block");
                    this.recordPosition(context.method_8041(), context.method_8037(), context.method_8036(), name);
                } else {
                    this.getPositions(context.method_8041()).clear();
                    this.send("positions_cleared", context.method_8036(), class_124.field_1065);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    private void recordPosition(class_1799 stack, class_2338 pos, class_1657 player, String name) {
        this.get(stack, pos).ifPresentOrElse(containerTag -> {
            if (containerTag.method_10577("input")) {
                containerTag.method_10556("input", false);
                this.send("position_output", player, class_124.field_1060);
            } else {
                this.remove(stack, pos);
                this.send("position_removed", player, class_124.field_1080);
            }
        }, () -> {
            this.add(stack, pos, name);
            this.send("position_input", player, class_124.field_1075);
        });
    }

    private void send(String message, class_1657 player, class_124 formatting) {
        if (player != null) {
            player.method_43496((class_2561)class_2561.method_43471((String)("gui.immersive_machinery.bamboo_bee." + message)).method_27692(formatting));
        }
    }

    private class_2499 getPositions(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (!tag.method_10545(TAG)) {
            tag.method_10566(TAG, (class_2520)new class_2499());
        }
        return tag.method_10554(TAG, 10);
    }

    private void add(class_1799 stack, class_2338 pos, String name) {
        class_2487 tag = new BambooBee.ContainerPosition(pos, name, true).toTag();
        this.getPositions(stack).add((Object)tag);
    }

    private Optional<class_2487> get(class_1799 stack, class_2338 pos) {
        class_2499 list = this.getPositions(stack);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 tag = list.method_10602(i);
            if (tag.method_10537("pos") != pos.method_10063()) continue;
            return Optional.of(tag);
        }
        return Optional.empty();
    }

    private void remove(class_1799 stack, class_2338 pos) {
        class_2499 list = this.getPositions(stack);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 tag = list.method_10602(i);
            if (tag.method_10537("pos") != pos.method_10063()) continue;
            list.method_10536(i);
            return;
        }
    }
}

