/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity.misc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_machinery.client.render.entity.renderer.PathDebugRenderer;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_11;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1324;
import net.minecraft.class_14;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_4466;
import net.minecraft.class_5134;
import net.minecraft.class_6;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.joml.Vector3d;

public class PilotNavigator {
    private final int followRange = 128;
    private final VehicleEntity vehicle;
    private final class_1308 pilot;
    private final class_13 pathFinder;
    private final double speed;
    private final boolean isFlying;
    private final int accuracy;
    private class_2338 target;
    private class_11 currentPath;
    private int stuckTime;
    Cache<Object, Object> pathCache = CacheBuilder.newBuilder().maximumSize(256L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public PilotNavigator(InventoryVehicleEntity vehicle, boolean isFlying, int accuracy) {
        this.vehicle = vehicle;
        this.pilot = new class_4466(class_1299.field_20346, vehicle.method_37908());
        class_1324 instance = this.pilot.method_6127().method_26842(class_5134.field_23717);
        if (instance != null) {
            instance.method_6192(128.0);
        }
        class_6 nodeEvaluator = isFlying ? new class_6() : new class_14();
        this.pathFinder = new class_13((class_8)nodeEvaluator, 2048);
        this.speed = vehicle.getProperties().get(VehicleStat.ENGINE_SPEED);
        this.isFlying = isFlying;
        this.accuracy = accuracy;
    }

    public Vector3d getDirection() {
        class_2338 node = this.currentPath.method_46() ? this.currentPath.method_48() : this.currentPath.method_31032();
        double dx = (double)node.method_10263() - this.vehicle.method_23317() + 0.5;
        double dy = this.isFlying ? (double)node.method_10264() - (this.vehicle.method_23318() + (double)(this.vehicle.method_17682() / 2.0f)) + 0.5 : 0.0;
        double dz = (double)node.method_10260() - this.vehicle.method_23321() + 0.5;
        return new Vector3d(dx, dy, dz);
    }

    public void moveTo(class_2338 pos) {
        if (!pos.equals((Object)this.target) && !pos.equals((Object)this.vehicle.method_24515())) {
            this.target = pos;
            this.stuckTime = 0;
            this.currentPath = this.findPath(pos);
            if (this.currentPath != null && (double)this.currentPath.method_21656() > (double)this.accuracy + 0.5) {
                this.currentPath = null;
            }
            PathDebugRenderer.INSTANCE.setPath(this.currentPath, this.vehicle);
        }
    }

    private class_11 findPath(class_2338 pos) {
        int i;
        Index index = new Index(this.vehicle.method_24515(), pos);
        class_11 path = (class_11)this.pathCache.getIfPresent((Object)index);
        if (path == null) {
            this.pilot.method_5814(this.vehicle.method_23317(), this.vehicle.method_23318(), this.vehicle.method_23321());
            class_2338 blockPos = this.vehicle.method_24515();
            i = 136;
            class_1950 pathNavigationRegion = new class_1950(this.vehicle.method_37908(), blockPos.method_10069(-i, -i, -i), blockPos.method_10069(i, i, i));
            path = this.pathFinder.method_52(pathNavigationRegion, this.pilot, Set.of(pos), 128.0f, this.accuracy, 1.0f);
            if (path == null) {
                return null;
            }
            this.pathCache.put((Object)index, (Object)path);
        }
        LinkedList<class_9> nodes = new LinkedList<class_9>();
        for (i = 0; i < path.method_38(); ++i) {
            nodes.add(path.method_40(i));
        }
        return new class_11(nodes, path.method_48(), false);
    }

    public void tick() {
        if (this.currentPath != null) {
            this.followThePath();
            this.unstuck();
        } else {
            this.move(0.0, 0.0, 0.0);
        }
    }

    protected void followThePath() {
        double margin;
        Vector3d d = this.getDirection();
        double distance = d.length();
        if (distance < (margin = 0.1)) {
            if (this.currentPath.method_46()) {
                this.currentPath = null;
                this.target = null;
            } else {
                this.currentPath.method_44();
                this.stuckTime = 0;
            }
        }
        double s = this.speed / (distance + 1.0E-5);
        s = Math.min(s, distance);
        this.move(d.x * s, d.y * s, d.z * s);
    }

    private void move(double x, double y, double z) {
        this.vehicle.method_18800(x, y, z);
    }

    private void unstuck() {
        ++this.stuckTime;
        if (this.stuckTime >= 100 && this.currentPath != null) {
            this.currentPath = null;
            this.target = null;
        }
    }

    public boolean hasPath() {
        return this.currentPath != null;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    record Index(class_2338 pos1, class_2338 pos2) {
    }
}

