/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_machinery.Common;
import immersive_machinery.Items;
import immersive_machinery.Sounds;
import immersive_machinery.Utils;
import immersive_machinery.client.KeyBindings;
import immersive_machinery.entity.MachineEntity;
import immersive_machinery.network.c2s.TunnelDiggerControlsUpdate;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class TunnelDigger
extends MachineEntity {
    public int drillY = 0;
    public boolean drilling = false;
    public boolean drillOn = true;
    public float drillingAnimation = 0.0f;
    public float lastDrillingAnimation = 0.0f;
    public float drillPower = 0.0f;

    public TunnelDigger(class_1299<? extends TunnelDigger> entityType, class_1937 world) {
        super(entityType, world, true);
    }

    public class_1792 asItem() {
        return Items.TUNNEL_DIGGER.get();
    }

    public boolean method_5675() {
        return false;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_5782()) {
            this.drillY = 0;
            this.drilling = false;
        } else if (this.drilling) {
            class_1937 class_19372;
            this.drillPower = Math.min(this.drillPower + this.getDrillSpeed() / 20.0f, 1.0f);
            if (this.drillPower > 0.0f && (class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 level = (class_3218)class_19372;
                LinkedList<class_2338> positions = new LinkedList<class_2338>();
                float front = -0.25f;
                float height = 1.5f;
                Vector3f forwardDirection = this.getForwardDirection();
                Vector3f rightDirection = this.getRightDirection();
                Vector3f upDirection = this.getTopDirection();
                Vector3f center = new Vector3f((Vector3fc)forwardDirection).mul(front).add(0.0f, height, 0.0f);
                center = center.add((float)this.method_23317(), (float)this.method_23318(), (float)this.method_23321());
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -Math.max(0, this.drillY) * 2; z <= 3; ++z) {
                        for (int y = this.drillY - 1; y <= 1 + Math.max(0, this.drillY); ++y) {
                            if (this.drillY < 0 && y == 2 && z == 0 || this.drillY < 0 && y == -2 && z == 3) continue;
                            double px = center.x + rightDirection.x * (float)x + upDirection.x * (float)y + forwardDirection.x * (float)z;
                            double py = center.y + rightDirection.y * (float)x + upDirection.y * (float)y + forwardDirection.y * (float)z;
                            double pz = center.z + rightDirection.z * (float)x + upDirection.z * (float)y + forwardDirection.z * (float)z;
                            positions.add(Utils.doubleToPos(px, py, pz));
                        }
                    }
                }
                while (!positions.isEmpty() && this.drillPower > 0.0f) {
                    class_2338 blockPos = (class_2338)positions.remove(this.field_5974.method_43048(positions.size()));
                    float destroySpeed = Utils.mineBlock(level, blockPos, this);
                    this.burnShards(destroySpeed);
                    this.drillPower -= destroySpeed;
                }
            }
        }
        this.lastDrillingAnimation = this.drillingAnimation;
        this.drillingAnimation += (float)(this.drilling ? 1 : 0) * 0.1f;
        this.method_49477(this.drillY > 0 || !this.drilling ? 1.1f : 0.55f);
        if (this.method_37908().method_8608()) {
            double chance = this.engineSpinUpStrength + this.getEnginePower();
            if (this.method_37908().field_9229.method_43058() < chance) {
                boolean fire = this.method_37908().field_9229.method_43057() < this.engineSpinUpStrength;
                Matrix4f transform = this.getVehicleTransform();
                Vector4f pos = this.transformPosition(transform, 1.0f, 2.45f, -0.9375f);
                this.method_37908().method_8406((class_2394)(fire ? class_2398.field_27783 : class_2398.field_11251), (double)pos.x, (double)pos.y, (double)pos.z, 0.0, 0.1, 0.0);
            }
        }
    }

    public float getDrillSpeed() {
        return (this.hasShards() ? 2.0f : 1.0f) * this.getProperties().get(Common.DRILLING_SPEED);
    }

    public boolean hasShards() {
        return this.getSlots(Common.SLOT_SHARDS).stream().anyMatch(slot -> !slot.method_7960());
    }

    public void burnShards(float destroySpeed) {
        List shards;
        if ((double)this.field_5974.method_43057() < (double)destroySpeed / 64.0 && !(shards = this.getSlots(Common.SLOT_SHARDS)).isEmpty()) {
            ((class_1799)shards.get(this.field_5974.method_43048(shards.size()))).method_7934(1);
        }
    }

    @Override
    protected void updateController() {
        boolean newDilling;
        super.updateController();
        if (!this.method_37908().method_8608()) {
            return;
        }
        int newDrillY = this.movementY > 0.0f ? 1 : (this.movementY < 0.0f ? -1 : 0);
        boolean bl = newDilling = (this.movementY != 0.0f || this.movementZ > 0.0f) && this.drillOn && this.getEnginePower() > 0.1f;
        if (newDrillY != this.drillY || newDilling != this.drilling) {
            this.drillY = newDrillY;
            this.drilling = newDilling;
            NetworkHandler.sendToServer((Message)new TunnelDiggerControlsUpdate(this.drillY, this.drilling));
        }
        if (this.movementX == 0.0f) {
            float yRot = this.method_36454();
            double step = 90.0;
            double targetRotation = (double)Math.round((double)yRot / step) * step;
            double speed = 0.06f;
            this.method_36456((float)((double)yRot * (1.0 - speed) + targetRotation * speed));
            if (this.movementZ == 0.0f) {
                double vSpeed = 0.04f;
                class_243 deltaMovement = this.method_18798();
                double dx = this.method_23317() - ((double)Math.round(this.method_23317() - 0.5) + 0.5);
                double dz = this.method_23321() - ((double)Math.round(this.method_23321() - 0.5) + 0.5);
                this.method_18799(deltaMovement.method_1031(-dx * vSpeed, 0.0, -dz * vSpeed));
            }
        }
        if (KeyBindings.HORN.method_1436()) {
            this.toggleDrill();
        }
    }

    public void toggleDrill() {
        this.drillOn = !this.drillOn;
        class_1309 pilot = this.method_5642();
        if (pilot != null) {
            pilot.method_43496((class_2561)class_2561.method_43471((String)(this.drillOn ? "immersive_machinery.tunnel_digger.drill_on" : "immersive_machinery.tunnel_digger.drill_off")));
        }
    }

    public class_243 attemptToDismount(class_1309 passenger, float ox, float oy, float oz) {
        Vector3f p = new Vector3f((float)this.method_23317() + ox * 2.0f, (float)this.method_23318() + oy * 2.0f, (float)this.method_23321() + oz * 2.0f);
        class_243 position = new class_243((double)p.x, (double)p.y, (double)p.z);
        for (class_4050 entityPose : passenger.method_24831()) {
            if (!class_5275.method_33353((class_1941)this.method_37908(), (class_243)position, (class_1309)passenger, (class_4050)entityPose)) continue;
            passenger.method_18380(entityPose);
            return position;
        }
        return null;
    }

    @NotNull
    public class_243 method_24829(class_1309 passenger) {
        Vector3f forwardDirection = this.getForwardDirection();
        class_243 dismountLocation = this.attemptToDismount(passenger, -forwardDirection.x(), 0.0f, -forwardDirection.z());
        if (dismountLocation != null) {
            return dismountLocation;
        }
        Vector3f rightDirection = this.getRightDirection();
        dismountLocation = this.attemptToDismount(passenger, rightDirection.x(), 0.0f, rightDirection.z());
        if (dismountLocation != null) {
            return dismountLocation;
        }
        dismountLocation = this.attemptToDismount(passenger, -rightDirection.x(), 0.0f, -rightDirection.z());
        if (dismountLocation != null) {
            return dismountLocation;
        }
        dismountLocation = this.attemptToDismount(passenger, forwardDirection.x(), 0.0f, forwardDirection.z());
        if (dismountLocation != null) {
            return dismountLocation;
        }
        return super.method_24829(passenger);
    }

    public boolean isTrackMoving() {
        return this.getSpeedVector().method_1027() > (double)1.0E-5f;
    }

    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set((String)"drill", (float)(this.getDrillingAnimation(tickDelta) * 64.0f));
        BBAnimationVariables.set((String)"drill_rx", (float)0.0f);
        BBAnimationVariables.set((String)"drill_rz", (float)0.0f);
        double p = this.enginePower.getSmooth();
        BBAnimationVariables.set((String)"engine_vibration_x", (float)((float)((this.field_5974.method_43058() - 0.5) * p)));
        BBAnimationVariables.set((String)"engine_vibration_y", (float)((float)((this.field_5974.method_43058() - 0.5) * p)));
        BBAnimationVariables.set((String)"engine_vibration_z", (float)((float)((this.field_5974.method_43058() - 0.5) * p)));
    }

    public float getDrillingAnimation(float tickDelta) {
        return this.lastDrillingAnimation + (this.drillingAnimation - this.lastDrillingAnimation) * tickDelta;
    }

    public double getZoom() {
        return 4.0;
    }

    protected class_3414 getEngineSound() {
        return this.drilling ? Sounds.TUNNEL_DIGGER_DRILLING.get() : Sounds.TUNNEL_DIGGER.get();
    }
}

