/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_machinery.Items;
import immersive_machinery.Sounds;
import immersive_machinery.Utils;
import immersive_machinery.config.Config;
import immersive_machinery.entity.MachineEntity;
import immersive_machinery.entity.NavigatingMachine;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2421;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.minecraft.class_8237;
import org.jetbrains.annotations.NotNull;

public class RedstoneSheep
extends NavigatingMachine {
    private static final int INVENTORY_BUFFER_SPACE = 3;
    private static final int RESCAN_INTERVAL = 100;
    private class_2338 home;
    private class_2338 task;
    private int reloadingTicks;
    private int rescanningTicks;
    private int tasksHarvested;
    private Set<class_2338> workingSet = new HashSet<class_2338>();
    private Set<class_2338> backlogSet = new HashSet<class_2338>();

    public RedstoneSheep(class_1299<? extends MachineEntity> entityType, class_1937 world) {
        super(entityType, world, false, false, 0);
        this.method_49477(1.1f);
    }

    public boolean method_5740() {
        return false;
    }

    protected class_3414 getEngineSound() {
        return Sounds.REDSTONE_SHEEP.get();
    }

    protected float getEnginePitch() {
        float speed = (float)this.getSpeedVector().method_1033();
        return Math.min(1.0f, 0.75f + speed * 10.0f);
    }

    protected float getEngineReactionSpeed() {
        return 10.0f;
    }

    @Override
    public void method_5773() {
        double dz;
        double dx;
        super.method_5773();
        if (this.home == null || this.home.method_10263() == 0 && this.home.method_10264() == 0 && this.home.method_10260() == 0) {
            this.home = this.method_24515();
        }
        if ((dx = this.method_23317() - this.lastX) * dx + (dz = this.method_23321() - this.lastZ) * dz > 1.0E-5) {
            this.method_36456(Utils.lerpAngle(this.method_36454(), (float)Math.toDegrees(Math.atan2(dz, dx)) + 90.0f, 10.0f));
        } else {
            this.method_36456(Utils.lerpAngle(this.method_36454(), (float)(Math.floor(this.method_36454() / 90.0f + 0.5f) * 90.0), 5.0f));
        }
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.isFuelLow() || this.isInventoryFull()) {
            this.reloadingTicks = 60;
        }
        --this.rescanningTicks;
        this.setEngineTarget(this.task != null ? 1.0f : 0.0f);
        if (this.reloadingTicks > 0) {
            if (this.moveTo(this.home) || !this.navigator.hasPath()) {
                --this.reloadingTicks;
            }
        } else if (this.task != null) {
            if (this.moveTo(this.task)) {
                VerifyState state = this.verify(this.task);
                if (state == VerifyState.VALID) {
                    this.work(this.task);
                }
                this.task = null;
            } else if (!this.navigator.hasPath()) {
                this.backlogSet.remove(this.task);
                this.task = null;
            }
        } else if (!this.workingSet.isEmpty()) {
            if ((this.method_37908().method_8510() + (long)this.method_5628()) % 5L == 0L) {
                class_2338 closest = this.workingSet.stream().min(Comparator.comparingDouble(a -> a.method_10268(this.method_23317(), this.method_23318(), this.method_23321()))).get();
                VerifyState state = this.verify(closest);
                if (state == VerifyState.VALID) {
                    this.task = closest;
                    this.backlogSet.add(closest);
                    ++this.tasksHarvested;
                    this.rescanningTicks = 100;
                } else if (state == VerifyState.NOT_MATURE) {
                    this.backlogSet.add(closest);
                }
                this.workingSet.remove(closest);
            }
        } else if (!this.backlogSet.isEmpty()) {
            this.workingSet = this.backlogSet;
            this.backlogSet = new HashSet<class_2338>();
            if (this.tasksHarvested == 0) {
                if (this.rescanningTicks <= 0) {
                    if (this.playerIsClose()) {
                        this.rescan();
                    }
                    this.rescanningTicks = 100;
                }
                this.reloadingTicks = 60;
            }
            this.tasksHarvested = 0;
        } else if (this.rescanningTicks <= 0) {
            this.rescan();
            this.rescanningTicks = 100;
        }
    }

    public boolean method_5782() {
        return true;
    }

    private void rescan() {
        this.workingSet.clear();
        this.backlogSet.clear();
        int range = Config.getInstance().redstoneSheepMinHorizontalScanRange;
        LongOpenHashSet visited = new LongOpenHashSet();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(this.home);
        visited.add(this.home.method_10063());
        while (!queue.isEmpty()) {
            class_2338 origin = (class_2338)queue.poll();
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 pos = new class_2338(x + origin.method_10263(), origin.method_10264(), z + origin.method_10260());
                    if (visited.contains(pos.method_10063())) continue;
                    visited.add(pos.method_10063());
                    if (this.verify(pos) == VerifyState.INVALID) continue;
                    this.workingSet.add(pos);
                    queue.add(pos);
                }
            }
        }
    }

    private boolean playerIsClose() {
        return this.method_37908().method_18460((class_1297)this, 32.0) != null;
    }

    private void work(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2248.method_9562((class_2680)state, (class_3218)serverLevel, (class_2338)pos, null).forEach(stack -> {
                class_1799 remainder = this.addItem((class_1799)stack);
                if (!remainder.method_7960()) {
                    class_2248.method_9577((class_1937)serverLevel, (class_2338)pos, (class_1799)remainder);
                }
            });
            RedstoneSheep.getAgeProperty(state).ifPresentOrElse(age -> serverLevel.method_8501(pos, (class_2680)state.method_11657(age, (Comparable)Integer.valueOf(0))), () -> serverLevel.method_22352(pos, false));
            this.consumeFuel(Config.getInstance().fuelTicksPerHarvest);
            serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11206, state), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10, 0.5, 0.0, 0.5, 1.0);
            serverLevel.method_8396(null, pos, class_3417.field_14706, class_3419.field_15245, 1.0f, 1.2f);
        }
    }

    private VerifyState verify(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        class_2248 block = state.method_26204();
        if (RedstoneSheep.isCrop(block)) {
            if (RedstoneSheep.isMature(state)) {
                return VerifyState.VALID;
            }
            return VerifyState.NOT_MATURE;
        }
        return VerifyState.INVALID;
    }

    public static boolean isCrop(class_2248 block) {
        String key = class_7923.field_41175.method_10221((Object)block).toString();
        if (Config.getInstance().validCrops.containsKey(key)) {
            return Config.getInstance().validCrops.get(key);
        }
        return block instanceof class_2302 || block instanceof class_2421 || block instanceof class_2282 || block instanceof class_8237;
    }

    public static Optional<class_2769<Integer>> getAgeProperty(class_2680 state) {
        for (class_2769 property : state.method_28501()) {
            if (!property.method_11899().equals("age")) continue;
            try {
                return Optional.of(property);
            }
            catch (ClassCastException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static boolean isMature(class_2680 state) {
        return RedstoneSheep.getAgeProperty(state).filter(p -> !Objects.equals(state.method_11654(p), Collections.max(p.method_11898()))).isEmpty();
    }

    private boolean isInventoryFull() {
        return this.countItems() > this.method_5439() - 3;
    }

    private int countItems() {
        int i = 0;
        for (int j = 0; j < this.method_5439(); ++j) {
            class_1799 itemStack = this.method_5438(j);
            if (itemStack.method_7960()) continue;
            ++i;
        }
        return i;
    }

    public class_1792 asItem() {
        return Items.REDSTONE_SHEEP.get();
    }

    protected void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("HomeX", this.home.method_10263());
        tag.method_10569("HomeY", this.home.method_10264());
        tag.method_10569("HomeZ", this.home.method_10260());
    }

    protected void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.home = new class_2338(tag.method_10550("HomeX"), tag.method_10550("HomeY"), tag.method_10550("HomeZ"));
    }

    public void method_5453(class_1263 sender) {
        if (this.reloadingTicks > 0) {
            this.reloadingTicks = 60;
        }
    }

    public float getFuelConsumption() {
        return 0.0f;
    }

    static enum VerifyState {
        VALID,
        NOT_MATURE,
        INVALID;

    }
}

