/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.joml.Vector3f;

public abstract class MachineEntity
extends EngineVehicle {
    public MachineEntity(class_1299<? extends MachineEntity> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    public void method_5773() {
        this.prevRoll = this.roll;
        if (this.method_24828()) {
            this.setZRot(this.roll * 0.9f);
        } else {
            float speed = (float)this.method_18798().method_1033();
            this.setZRot(-this.pressingInterpolatedX.getSmooth() * this.getProperties().get(VehicleStat.ROLL_FACTOR) * speed);
        }
        super.method_5773();
    }

    protected void updateController() {
        this.setEngineTarget(1.0f);
        this.method_36456(this.method_36454() - this.getProperties().get(VehicleStat.YAW_SPEED) * this.pressingInterpolatedX.getSmooth());
        if (this.method_24828()) {
            Vector3f direction = this.getForwardDirection();
            float speed = this.getSpeed() * this.pressingInterpolatedZ.getSmooth();
            this.method_18799(this.method_18798().method_1019(this.toVec3d(direction.mul(speed))));
        }
    }

    protected float getSpeed() {
        return (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED));
    }

    protected void updateVelocity() {
        float decay = 1.0f - this.getProperties().get(VehicleStat.FRICTION);
        float gravity = this.getGravity();
        if (this.field_5957) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.method_24828()) {
            decay = this.getProperties().get(VehicleStat.GROUND_FRICTION);
        }
        float hd = this.getProperties().get(VehicleStat.HORIZONTAL_DECAY);
        float vd = this.getProperties().get(VehicleStat.VERTICAL_DECAY);
        class_243 velocity = this.method_18798();
        this.method_18800(velocity.field_1352 * (double)decay * (double)hd, velocity.field_1351 * (double)decay * (double)vd + (double)gravity, velocity.field_1350 * (double)decay * (double)hd);
        float rf = decay * this.getProperties().get(VehicleStat.ROTATION_DECAY);
        this.pressingInterpolatedX.decay(0.0f, 1.0f - rf);
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - rf);
    }

    public class_1799 addItem(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = stack.method_7972();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.moveItemToEmptySlots(itemStack);
        return itemStack.method_7960() ? class_1799.field_8037 : itemStack;
    }

    private void moveItemToOccupiedSlotsWithSameType(class_1799 stack) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
            this.moveItemsBetweenStacks(stack, itemStack);
            if (!stack.method_7960()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(class_1799 stack, class_1799 other) {
        int i = Math.min(this.method_5444(), other.method_7914());
        int j = Math.min(stack.method_7947(), i - other.method_7947());
        if (j > 0) {
            other.method_7933(j);
            stack.method_7934(j);
            this.method_5431();
        }
    }

    private void moveItemToEmptySlots(class_1799 stack) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack;
            if (!this.method_5437(i, stack) || !(itemStack = this.method_5438(i)).method_7960()) continue;
            this.method_5447(i, stack.method_51164());
            return;
        }
    }
}

