/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_machinery.Items;
import immersive_machinery.Sounds;
import immersive_machinery.client.KeyBindings;
import immersive_machinery.entity.MachineEntity;
import immersive_machinery.network.c2s.SonarMessage;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Copperfin
extends MachineEntity {
    public float waterSurface = 62.875f;
    public float dripping = 0.0f;
    public float bubbling = 0.0f;
    public int ambientSoundTime = 0;
    private int sonarCooldown = 0;

    public Copperfin(class_1299<? extends MachineEntity> entityType, class_1937 world) {
        super(entityType, world, true);
    }

    public class_1792 asItem() {
        return Items.COPPERFIN.get();
    }

    @Override
    protected void updateController() {
        super.updateController();
        --this.sonarCooldown;
        if (this.method_37908().method_8608() && KeyBindings.HORN.method_1436() && this.sonarCooldown < 0) {
            this.requestSonar();
        }
        this.method_18799(this.method_18798().method_1031(0.0, (double)(this.getSpeed() * this.getProperties().get(VehicleStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3f direction = this.getForwardDirection();
        float thrust = this.getSpeed() * this.pressingInterpolatedZ.getSmooth();
        Vector3f f = direction.mul(thrust);
        this.method_18799(this.method_18798().method_1031((double)f.x, (double)f.y, (double)f.z));
    }

    @Override
    protected float getSpeed() {
        return super.getSpeed() * (this.method_5869() ? 1.0f : 0.0f);
    }

    public boolean worksUnderWater() {
        return true;
    }

    protected class_3414 getEngineStartSound() {
        return super.getEngineStartSound();
    }

    protected class_3414 getEngineSound() {
        return Sounds.SUBMARINE_ENGINE.get();
    }

    protected float getGravity() {
        return this.method_5869() ? 0.0f : super.getGravity();
    }

    protected float method_18378(@NotNull class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.25f;
    }

    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
        this.method_43077(Sounds.HATCH_CLOSE.get());
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        this.method_43077(Sounds.HATCH_OPEN.get());
    }

    public float getUnderwaterFraction() {
        return (float)Math.min(1.0, Math.max(0.0, ((double)this.waterSurface - this.method_23318()) / (double)this.method_17682()));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8510() % 13L == 0L) {
            boolean air = false;
            for (int y = (int)(this.method_23318() + (double)this.method_17682()); y >= this.method_31478(); --y) {
                class_3610 fluidState = this.method_37908().method_8316(new class_2338(this.method_31477(), y, this.method_31479()));
                if (fluidState.method_15769()) {
                    air = true;
                    continue;
                }
                if (!air) continue;
                float ownHeight = fluidState.method_20785();
                this.waterSurface = (float)y + ownHeight;
                break;
            }
        }
        this.method_5685().forEach(passenger -> {
            if (passenger instanceof class_1309) {
                class_1309 livingEntity = (class_1309)passenger;
                livingEntity.method_5855(livingEntity.method_5748());
            }
        });
        if (this.method_37908().field_9236) {
            this.tickClient();
        } else {
            this.tickServer();
        }
    }

    public void tickClient() {
        Vector3f pos;
        int i;
        float underwaterFraction = this.getUnderwaterFraction();
        if (underwaterFraction >= this.dripping) {
            this.dripping = underwaterFraction;
        } else if ((double)underwaterFraction < 0.6) {
            this.dripping = Math.max(0.0f, this.dripping - 0.005f);
            float r = this.field_5974.method_43057();
            this.spawnParticlesAround((class_2394)class_2398.field_18306, 10.0f * this.dripping, 1.625f * r + 1.625f * underwaterFraction * (1.0f - r));
        }
        if (underwaterFraction <= this.bubbling) {
            this.bubbling = underwaterFraction;
        } else if ((double)underwaterFraction > 0.8) {
            this.bubbling = Math.min(1.0f, this.bubbling + 0.01f);
            this.spawnParticlesAround((class_2394)class_2398.field_11247, 10.0f, this.field_5974.method_43057() * underwaterFraction);
        }
        float rawSpeed = (float)this.getCurrentSpeed();
        double speed = (double)rawSpeed * 3.0 + 0.5;
        if ((double)underwaterFraction > 0.6 && this.method_37908().method_8608() && this.pressingInterpolatedZ.getSmooth() > -0.01f && this.method_5869()) {
            for (i = 0; i < (int)(speed * 2.5 + (double)this.field_5974.method_43057()); ++i) {
                pos = this.transformPosition(this.getVehicleTransform(), (this.field_5974.method_43057() - 0.5f) * 0.5f, (this.field_5974.method_43057() - 0.5f) * 0.5f + this.method_17682() * 0.5f + 0.1f, -1.0f);
                Vector3f vec = this.transformVector(this.getVehicleNormalTransform(), 0.0f, 0.0f, -1.0f * (this.pressingInterpolatedZ.getSmooth() + 0.25f));
                this.method_37908().method_8406((class_2394)class_2398.field_11247, (double)pos.x, (double)pos.y, (double)pos.z, (double)vec.x, 0.0, (double)vec.z);
            }
        }
        this.method_36457((float)((double)(this.pressingInterpolatedY.getSmooth() * -15.0f) * speed));
        this.setZRot((float)((double)(this.pressingInterpolatedX.getSmooth() * -20.0f) * speed));
        if ((double)underwaterFraction > 0.0 && (double)underwaterFraction < 1.0 && rawSpeed > 0.0f) {
            i = 0;
            while ((double)i < (double)rawSpeed * 8.0) {
                pos = this.getParticlePosition(0.0f);
                this.method_37908().method_8406((class_2394)class_2398.field_11202, (double)pos.x, (double)this.waterSurface, (double)pos.z, 0.0, 1.0, 0.0);
                ++i;
            }
            if (this.field_5974.method_43048(10) == 0) {
                this.method_5783(class_3417.field_14737, 1.0f, 0.8f + 0.4f * this.field_5974.method_43057());
            }
        }
    }

    public void tickServer() {
        if (this.method_5782()) {
            this.ambientSoundTime -= this.method_23318() < this.lastY - 1.0E-5 ? 1 : 3;
            if (this.ambientSoundTime <= 0) {
                this.ambientSoundTime = 100 + this.field_5974.method_43048(250);
                this.method_43077(Sounds.SUBMARINE_AMBIENCE.get());
            }
        }
    }

    public Vector3f getParticlePosition(float y) {
        float z;
        float x;
        boolean front = this.field_5974.method_43056();
        float w = 0.875f;
        float l = 1.0f;
        if (front) {
            x = (this.field_5974.method_43057() - 0.5f) * w;
            float mz = this.pressingInterpolatedZ.getSmooth();
            z = Math.abs(mz) < 0.01f ? (this.field_5974.method_43056() ? -l : l) : (mz > 0.0f ? -l : l);
        } else {
            x = this.field_5974.method_43056() ? -w : w;
            z = (this.field_5974.method_43057() - 0.5f) * l;
        }
        Vector4f vector4f = this.transformPosition(this.getVehicleTransform(), x, y, z);
        return new Vector3f(vector4f.x, vector4f.y, vector4f.z);
    }

    protected void spawnParticlesAround(class_2394 type, float amount, float height) {
        int i = 0;
        while ((float)i < amount + this.field_5974.method_43057()) {
            Vector3f pos = this.getParticlePosition(height);
            this.method_37908().method_8406(type, (double)pos.x, (double)pos.y, (double)pos.z, 0.0, 1.0, 0.0);
            ++i;
        }
    }

    public void requestSonar() {
        NetworkHandler.sendToServer((Message)new SonarMessage());
        this.sonarCooldown = 60;
    }

    public void sonar() {
        this.method_37908().method_8335((class_1297)this, new class_238(this.method_23312(), this.method_23312()).method_1014(48.0)).forEach(e -> {
            if (e instanceof class_1309) {
                class_1309 le = (class_1309)e;
                if (!e.method_5794((class_1297)this)) {
                    le.method_6092(new class_1293(class_1294.field_5912, 30));
                }
            }
        });
        this.method_43077(Sounds.SONAR.get());
    }

    protected double getCurrentSpeed() {
        double dx = this.method_23317() - this.field_6038;
        double dz = this.method_23321() - this.field_5989;
        return Math.sqrt(dx * dx + dz * dz);
    }

    protected boolean method_5818(@NotNull class_1297 passenger) {
        return this.method_5685().size() < this.getPassengerSpace();
    }

    public Vector3f getForwardDirection() {
        return new Vector3f(class_3532.method_15374((float)(-this.method_36454() * ((float)Math.PI / 180))), 0.0f, class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))).normalize();
    }

    public Vector3f getRightDirection() {
        return new Vector3f(class_3532.method_15362((float)(-this.method_36454() * ((float)Math.PI / 180))), 0.0f, class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)))).normalize();
    }

    public Float modifyWaterVision(float waterVision) {
        return Float.valueOf(waterVision * 0.25f + 0.75f);
    }
}

