/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_machinery.Common;
import immersive_machinery.Items;
import immersive_machinery.Sounds;
import immersive_machinery.Utils;
import immersive_machinery.entity.MachineEntity;
import immersive_machinery.entity.NavigatingMachine;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class BambooBee
extends NavigatingMachine {
    private Configuration configuration = new Configuration();
    private final List<ContainerPosition> containerPositions = new LinkedList<ContainerPosition>();
    private Task currentTask;
    private int searchCooldown = 0;
    public static final int WORK_SLOT = 0;

    public BambooBee(class_1299<? extends MachineEntity> entityType, class_1937 world) {
        super(entityType, world, false, true, 1);
    }

    protected class_3414 getEngineSound() {
        return Sounds.BAMBOO_BEE.get();
    }

    protected float getEnginePitch() {
        float speed = (float)this.getSpeedVector().method_1033();
        return 0.65f + speed * 1.25f;
    }

    protected float getGravity() {
        return (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            double dx = this.x - this.secondLastX;
            double dy = this.y - this.secondLastY;
            double dz = this.z - this.secondLastZ;
            double d2 = dx * dx + dy * dy + dz * dz;
            if (d2 > 0.0 && d2 < 10.0) {
                float yRot = this.method_36454();
                this.method_36457(Utils.lerpAngle(this.method_36455(), (float)(dy * 45.0), 2.0f));
                this.method_36456(Utils.lerpAngle(yRot, (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f, 8.0f));
                this.setZRot(Utils.lerpAngle(this.getRoll(), (this.method_36454() - yRot) * 2.0f, 2.0f));
                if (this.method_37908().method_8510() % 4L == 0L) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.x, this.y + 0.4, this.z, 0.0, 0.0, 0.0);
                }
            } else {
                this.method_36457(Utils.lerpAngle(this.method_36455(), 0.0f, 5.0f));
                this.setZRot(Utils.lerpAngle(this.getRoll(), 0.0f, 5.0f));
            }
            return;
        }
        this.setEngineTarget(this.currentTask != null ? 1.0f : 0.0f);
        if (this.currentTask == null) {
            --this.searchCooldown;
            if (this.searchCooldown <= 0) {
                this.currentTask = this.getTask();
                if (this.currentTask == null) {
                    this.searchCooldown = 60;
                }
            }
        } else {
            class_1799 carries = this.method_32318(0).method_32327();
            if (carries.method_7960()) {
                if (this.moveTowards(this.currentTask.source())) {
                    class_2586 blockEntity = this.method_37908().method_8321(this.currentTask.source());
                    if (blockEntity instanceof class_1263) {
                        class_1263 container = (class_1263)blockEntity;
                        class_1799 item = container.method_5438(this.currentTask.slot());
                        if (this.match(item, this.currentTask.stack())) {
                            class_1799 stack = container.method_5434(this.currentTask.slot(), item.method_7947());
                            this.method_32318(0).method_32332(stack);
                            this.method_43077(class_3417.field_17604);
                            blockEntity.method_5431();
                        } else {
                            this.error("Item mismatches!");
                            this.currentTask = null;
                        }
                    } else {
                        this.error("Container gone!");
                        this.currentTask = null;
                    }
                }
            } else if (this.match(carries, this.currentTask.stack())) {
                if (this.moveTowards(this.currentTask.target())) {
                    class_2586 blockEntity = this.method_37908().method_8321(this.currentTask.target());
                    if (blockEntity instanceof class_1263) {
                        class_1263 container = (class_1263)blockEntity;
                        this.addToContainer(container, carries);
                        this.method_43077(class_3417.field_17603);
                        blockEntity.method_5431();
                        if (carries.method_7960()) {
                            this.currentTask = null;
                        } else {
                            this.returnItem();
                        }
                    } else {
                        this.error("Container gone!");
                        this.currentTask = null;
                    }
                }
            } else {
                this.error("Wrong item, returning to source!");
                this.returnItem();
            }
        }
    }

    public boolean method_5782() {
        return true;
    }

    protected void method_18379() {
    }

    private void addToContainer(class_1263 container, class_1799 carries) {
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            class_1799 stack = container.method_5438(slot);
            if (!container.method_5437(slot, carries)) continue;
            if (class_1799.method_31577((class_1799)carries, (class_1799)stack)) {
                int count = Math.min(carries.method_7947(), stack.method_7914() - stack.method_7947());
                stack.method_7933(count);
                carries.method_7934(count);
                container.method_5447(slot, stack);
                continue;
            }
            if (!stack.method_7960()) continue;
            container.method_5447(slot, carries.method_51164());
        }
    }

    private void returnItem() {
        class_1799 carries = this.method_32318(0).method_32327();
        this.currentTask = new Task(this.currentTask.source(), this.currentTask.slot(), carries.method_7972(), this.currentTask.source());
    }

    private void error(String message) {
        class_5250 error = class_2561.method_43471((String)"entity.immersive_machinery.bamboo_bee").method_27695(new class_124[]{class_124.field_1056, class_124.field_1065}).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)message));
        this.method_37908().method_18456().stream().filter((? super T player) -> player.method_5858((class_1297)this) < 64.0).forEach(player -> player.method_7353((class_2561)error, false));
    }

    private List<ContainerPosition> getPositions(boolean input) {
        LinkedList<ContainerPosition> positions = new LinkedList<ContainerPosition>();
        for (ContainerPosition position : this.containerPositions) {
            if (position.input() != input) continue;
            positions.add(position);
        }
        if (this.configuration.order == Configuration.Order.ROUND_ROBIN) {
            Collections.rotate(positions, (int)this.method_37908().method_8510());
        }
        return positions;
    }

    private Task getTask() {
        for (ContainerPosition position : this.getPositions(true)) {
            class_2586 blockEntity = this.method_37908().method_8321(position.pos());
            if (!(blockEntity instanceof class_1263)) continue;
            class_1263 container = (class_1263)blockEntity;
            for (int slot = 0; slot < container.method_5439(); ++slot) {
                Task task;
                class_1799 item = container.method_5438(slot);
                if (item.method_7960() || !container.method_49104(container, slot, item) || !this.filter(item) || (task = this.findTask(position.pos(), slot, item)) == null) continue;
                return task;
            }
        }
        return null;
    }

    private Task findTask(class_2338 source, int slot, class_1799 item) {
        for (ContainerPosition position : this.getPositions(false)) {
            class_1263 container;
            class_2586 blockEntity = this.method_37908().method_8321(position.pos());
            if (!(blockEntity instanceof class_1263) || !this.couldMove(item, container = (class_1263)blockEntity)) continue;
            return new Task(source, slot, item.method_7972(), position.pos());
        }
        return null;
    }

    private boolean couldMove(class_1799 item, class_1263 container) {
        int count = item.method_7947();
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            class_1799 stack = container.method_5438(slot);
            if (!container.method_5437(slot, item)) continue;
            if (class_1799.method_31577((class_1799)item, (class_1799)stack)) {
                count -= stack.method_7914() - stack.method_7947();
            } else if (stack.method_7960()) {
                count -= item.method_7914();
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    private boolean filter(class_1799 stack) {
        List slots = this.getSlots(Common.SLOT_FILTER);
        return this.isEmpty(slots) || slots.stream().anyMatch(other -> this.match(stack, (class_1799)other));
    }

    private boolean isEmpty(List<class_1799> slots) {
        return slots.stream().allMatch(class_1799::method_7960);
    }

    private boolean match(class_1799 stack, class_1799 other) {
        if (this.configuration.compareTag) {
            return class_1799.method_31577((class_1799)stack, (class_1799)other);
        }
        return class_1799.method_7984((class_1799)stack, (class_1799)other);
    }

    protected void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        this.writeConfiguration(tag);
    }

    protected void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.readConfiguration(tag);
    }

    protected void addItemTag(@NotNull class_2487 tag) {
        super.addItemTag(tag);
        this.writeConfiguration(tag);
    }

    protected void readItemTag(@NotNull class_2487 tag) {
        super.readItemTag(tag);
        this.readConfiguration(tag);
    }

    private void readConfiguration(class_2487 tag) {
        if (tag.method_10545("ContainerPositions")) {
            class_2499 list = tag.method_10554("ContainerPositions", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 containerTag = list.method_10602(i);
                this.containerPositions.add(ContainerPosition.fromTag(containerTag));
            }
        }
        this.configuration.read(tag);
    }

    private void writeConfiguration(class_2487 tag) {
        class_2499 list = new class_2499();
        for (ContainerPosition position : this.containerPositions) {
            list.add((Object)position.toTag());
        }
        tag.method_10566("ContainerPositions", (class_2520)list);
        this.configuration.write(tag);
    }

    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set((String)"grabber", (float)(this.getInventory().method_5438(0).method_7960() ? -45.0f : 0.0f));
    }

    public class_1792 asItem() {
        return Items.BAMBOO_BEE.get();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public static class Configuration {
        public boolean blacklist;
        public boolean compareTag;
        public Order order = Order.ROUND_ROBIN;
        private boolean dirty;

        public void read(class_2487 tag) {
            if (tag.method_10545("Order")) {
                this.blacklist = tag.method_10577("Blacklist");
                this.compareTag = tag.method_10577("CompareTag");
                this.order = Order.valueOf(tag.method_10558("Order"));
            }
        }

        public void write(class_2487 tag) {
            tag.method_10556("Blacklist", this.blacklist);
            tag.method_10556("CompareTag", this.compareTag);
            tag.method_10582("Order", this.order.name());
        }

        public void setDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void encode(class_2540 b) {
            b.writeBoolean(this.blacklist);
            b.writeBoolean(this.compareTag);
            b.method_10817((Enum)this.order);
        }

        public void decode(class_2540 b) {
            this.blacklist = b.readBoolean();
            this.compareTag = b.readBoolean();
            this.order = (Order)b.method_10818(Order.class);
        }

        public static enum Order {
            FIRST,
            ROUND_ROBIN;


            public Order next() {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case FIRST -> ROUND_ROBIN;
                    case ROUND_ROBIN -> FIRST;
                };
            }
        }
    }

    public record Task(class_2338 source, int slot, class_1799 stack, class_2338 target) {
    }

    public record ContainerPosition(class_2338 pos, String name, boolean input) {
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10544("pos", this.getPos());
            tag.method_10582("name", this.name());
            tag.method_10556("input", this.input());
            return tag;
        }

        public static ContainerPosition fromTag(class_2487 tag) {
            class_2338 pos = class_2338.method_10092((long)tag.method_10537("pos"));
            String name = tag.method_10558("name");
            boolean input = tag.method_10577("input");
            return new ContainerPosition(pos, name, input);
        }

        public long getPos() {
            return this.pos().method_10063();
        }
    }
}

