/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.client.render.entity.renderer;

import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_machinery.Common;
import immersive_machinery.client.render.entity.renderer.MachineryRenderer;
import immersive_machinery.config.Config;
import immersive_machinery.entity.Copperfin;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5498;
import net.minecraft.class_5617;
import net.minecraft.class_5636;
import net.minecraft.class_7833;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class CopperfinRenderer<T extends Copperfin>
extends MachineryRenderer<T> {
    private static final class_2960 ID = Common.locate("copperfin");
    private final ModelPartRenderHandler<T> model = new ModelPartRenderHandler();

    private Matrix3f getVehicleNormalTransform(T entity, float yaw, float tickDelta) {
        Matrix3f transform = new Matrix3f();
        transform.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-yaw));
        transform.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(entity.method_5695(tickDelta)));
        transform.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(entity.getRoll(tickDelta)));
        return transform;
    }

    public void renderWaterMask(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 source, int light) {
        Matrix3f transform = this.getVehicleNormalTransform(entity, yaw, tickDelta);
        float z = 0.04f;
        float waterHeight = (float)((double)(((Copperfin)((Object)entity)).waterSurface + z) - (entity.method_23318() * (double)tickDelta + ((Copperfin)((Object)entity)).field_5971 * (1.0 - (double)tickDelta)));
        boolean firstPerson = class_310.method_1551().field_1690.method_31044() != class_5498.field_26664;
        float iz = firstPerson ? z : -z;
        Vector3f b0 = new Vector3f(-0.75f + iz, 0.125f + iz, -0.25f + iz);
        Vector3f b1 = new Vector3f(0.75f - iz, 0.125f + iz, -0.25f + iz);
        Vector3f b2 = new Vector3f(0.75f - iz, 0.125f + iz, 0.9375f - iz);
        Vector3f b3 = new Vector3f(-0.75f + iz, 0.125f + iz, 0.9375f - iz);
        float h0 = Math.fma((float)transform.m01(), (float)b0.x, (float)Math.fma((float)transform.m11(), (float)b0.y, (float)(transform.m21() * b0.z)));
        float h1 = Math.fma((float)transform.m01(), (float)b1.x, (float)Math.fma((float)transform.m11(), (float)b1.y, (float)(transform.m21() * b1.z)));
        float h2 = Math.fma((float)transform.m01(), (float)b2.x, (float)Math.fma((float)transform.m11(), (float)b2.y, (float)(transform.m21() * b2.z)));
        float h3 = Math.fma((float)transform.m01(), (float)b3.x, (float)Math.fma((float)transform.m11(), (float)b3.y, (float)(transform.m21() * b3.z)));
        float ht0 = Math.fma((float)transform.m01(), (float)b0.x, (float)Math.fma((float)transform.m11(), (float)(b0.y + 1.0f), (float)(transform.m21() * b0.z)));
        float ht1 = Math.fma((float)transform.m01(), (float)b1.x, (float)Math.fma((float)transform.m11(), (float)(b1.y + 1.0f), (float)(transform.m21() * b1.z)));
        float ht2 = Math.fma((float)transform.m01(), (float)b2.x, (float)Math.fma((float)transform.m11(), (float)(b2.y + 1.0f), (float)(transform.m21() * b2.z)));
        float ht3 = Math.fma((float)transform.m01(), (float)b3.x, (float)Math.fma((float)transform.m11(), (float)(b3.y + 1.0f), (float)(transform.m21() * b3.z)));
        float maxHeight = 1.5f - z;
        float f0 = java.lang.Math.max(0.0f, java.lang.Math.min(maxHeight, (waterHeight - h0) / (ht0 - h0)));
        float f1 = java.lang.Math.max(0.0f, java.lang.Math.min(maxHeight, (waterHeight - h1) / (ht1 - h1)));
        float f2 = java.lang.Math.max(0.0f, java.lang.Math.min(maxHeight, (waterHeight - h2) / (ht2 - h2)));
        float f3 = java.lang.Math.max(0.0f, java.lang.Math.min(maxHeight, (waterHeight - h3) / (ht3 - h3)));
        if (f0 == 0.0f || f1 == 0.0f || f2 == 0.0f || f3 == 0.0f) {
            return;
        }
        Vector3f t0 = new Vector3f(0.0f, f0, 0.0f).add((Vector3fc)b0);
        Vector3f t1 = new Vector3f(0.0f, f1, 0.0f).add((Vector3fc)b1);
        Vector3f t2 = new Vector3f(0.0f, f2, 0.0f).add((Vector3fc)b2);
        Vector3f t3 = new Vector3f(0.0f, f3, 0.0f).add((Vector3fc)b3);
        Vector3f[][] faces = new Vector3f[][]{{t0, t1, t2, t3}, {t3, t2, t1, t0}, {b3, b2, b1, b0}, {b0, b1, t1, t0}, {b1, b2, t2, t1}, {b2, b3, t3, t2}, {b3, b0, t0, t3}};
        Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f)};
        int averageWaterColor = class_1163.method_4961((class_1920)entity.method_37908(), (class_2338)entity.method_23312());
        boolean renderTop = f0 < maxHeight || f1 < maxHeight || f2 < maxHeight || f3 < maxHeight;
        boolean cameraInFluid = class_310.method_1551().field_1773.method_19418().method_19334() != class_5636.field_27888;
        for (int j = renderTop ? 0 : 2; j < (firstPerson || !cameraInFluid ? 7 : 2); ++j) {
            class_4588 buffer = j < 2 ? source.getBuffer(class_1921.method_23589()) : source.getBuffer(class_1921.method_23580((class_2960)Common.locate("textures/white.png")));
            for (int i = 0; i < 4; ++i) {
                Vector3f v = faces[j][i];
                Vector3f n = normals[i];
                Vector4f v2 = matrixStack.method_23760().method_23761().transform(new Vector4f(v.x, v.y + (j == 0 ? -z * 2.0f : 0.0f), v.z, 1.0f));
                buffer.method_22912((double)v2.x, (double)v2.y, (double)v2.z);
                buffer.method_39415(averageWaterColor | 0x70000000);
                buffer.method_22913(0.5f, 0.5f);
                buffer.method_22922(class_4608.field_21444);
                buffer.method_22916(light);
                buffer.method_23763(matrixStack.method_23760().method_23762(), n.x, n.y, n.z);
                buffer.method_1344();
            }
        }
    }

    public void renderLocal(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4587.class_4665 peek, class_4597 vertexConsumerProvider, int light) {
        super.renderLocal(entity, yaw, tickDelta, matrixStack, peek, vertexConsumerProvider, light);
        if (Config.getInstance().waterRenderingFixForCopperfin) {
            this.renderWaterMask(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
        }
    }

    protected class_2960 getModelId() {
        return ID;
    }

    public CopperfinRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.6f;
    }

    protected ModelPartRenderHandler<T> getModel(T entity) {
        return this.model;
    }
}

