/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.client.gui.screen;

import immersive_aircraft.client.gui.VehicleScreen;
import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.screen.VehicleScreenHandler;
import immersive_machinery.Common;
import immersive_machinery.client.gui.screen.widgets.ToggleImageButton;
import immersive_machinery.entity.BambooBee;
import immersive_machinery.network.c2s.BambooBeeConfigurationUpdate;
import java.net.URI;
import java.util.Locale;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class BambooBeeScreen
extends VehicleScreen {
    private final BambooBee bee;
    private static final class_2960 TEXTURE = Common.locate("textures/gui/container/inventory.png");
    private static final class_2561 TEXT_HELP = class_2561.method_43471((String)"gui.immersive_machinery.bamboo_bee.help");
    private static final class_2561 TEXT_WHITELIST = class_2561.method_43471((String)"gui.immersive_machinery.bamboo_bee.whitelist");
    private static final class_2561 TEXT_BLACKLIST = class_2561.method_43471((String)"gui.immersive_machinery.bamboo_bee.blacklist");
    private static final class_2561 TEXT_FILTER_NAME = class_2561.method_43471((String)"gui.immersive_machinery.bamboo_bee.filter.name");
    private static final class_2561 TEXT_FILTER_TAG = class_2561.method_43471((String)"gui.immersive_machinery.bamboo_bee.filter.tag");

    public BambooBeeScreen(BambooBee bee, VehicleScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.bee = bee;
    }

    protected void addImageButton(int x, int y, int u, int v, class_4185.class_4241 onPress, class_2561 text, boolean pressed) {
        ToggleImageButton b = new ToggleImageButton(this.getX() + x, this.getY() + y, 16, 16, u, v, 16, TEXTURE, 128, 128, onPress, text);
        b.method_47400(class_7919.method_47407((class_2561)text));
        b.setPressed(pressed);
        this.method_37063((class_364)b);
    }

    public void method_25419() {
        super.method_25419();
        BambooBee.Configuration c = this.bee.getConfiguration();
        if (c.isDirty()) {
            NetworkHandler.sendToServer((Message)new BambooBeeConfigurationUpdate(this.bee));
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        BambooBee.Configuration c = this.bee.getConfiguration();
        this.addImageButton(50, 20, c.blacklist ? 48 : 64, 80, b -> {
            c.blacklist = !c.blacklist;
            c.setDirty();
            this.method_25426();
        }, c.blacklist ? TEXT_BLACKLIST : TEXT_WHITELIST, false);
        this.addImageButton(50, 38, c.compareTag ? 0 : 16, 80, b -> {
            c.compareTag = !c.compareTag;
            c.setDirty();
            this.method_25426();
        }, c.compareTag ? TEXT_FILTER_TAG : TEXT_FILTER_NAME, false);
        this.addImageButton(50, 56, c.order.ordinal() * 16 + 64, 80, b -> {
            c.order = c.order.next();
            c.setDirty();
            this.method_25426();
        }, (class_2561)class_2561.method_43471((String)("gui.immersive_machinery.bamboo_bee.order." + c.order.name().toLowerCase(Locale.ROOT))), false);
        class_344 help = new class_344(this.getX() + 160, this.getY() + 5, 10, 10, 64, 0, 10, TEXTURE, 128, 128, b -> this.openHelp(), TEXT_HELP);
        help.method_47400(class_7919.method_47407((class_2561)TEXT_HELP));
        this.method_37063((class_364)help);
    }

    private void openHelp() {
        try {
            class_156.method_668().method_673(URI.create("https://github.com/Luke100000/ImmersiveMachinery/wiki/Bamboo-Bee"));
        }
        catch (Exception e) {
            Common.LOGGER.error("Failed to open help page", (Throwable)e);
        }
    }

    public void updateConfigurations() {
        this.method_25426();
    }
}

