/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery;

import immersive_aircraft.client.gui.SlotRenderer;
import immersive_aircraft.client.gui.VehicleScreen;
import immersive_aircraft.client.gui.VehicleScreenRegistry;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.screen.VehicleScreenHandler;
import immersive_machinery.Common;
import immersive_machinery.client.gui.MachinerySlotRenderer;
import immersive_machinery.client.gui.screen.BambooBeeScreen;
import immersive_machinery.client.gui.screen.CopperfinScreen;
import immersive_machinery.client.gui.screen.TunnelDiggerScreen;
import immersive_machinery.entity.BambooBee;
import immersive_machinery.entity.Copperfin;
import immersive_machinery.entity.TunnelDigger;
import immersive_machinery.network.ClientNetworkManager;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class Client {
    public static void init() {
        Common.networkManager = new ClientNetworkManager(class_310.method_1551());
    }

    private static <T extends VehicleEntity, S extends VehicleScreen> void registerVehicleScreen(Class<T> vehicleClass, TriFunction<T, VehicleScreenHandler, class_746, S> screenFactory) {
        VehicleScreenRegistry.register(vehicleClass, (vehicle, player, message) -> {
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && client.field_1724 != null && vehicleClass.isInstance(vehicle)) {
                VehicleEntity castedVehicle = (VehicleEntity)vehicleClass.cast(vehicle);
                VehicleScreenHandler handler = (VehicleScreenHandler)vehicle.createMenu(message.getSyncId(), client.field_1724.method_31548(), (class_1657)client.field_1724);
                assert (handler != null);
                VehicleScreen screen = (VehicleScreen)screenFactory.apply(castedVehicle, handler, client.field_1724);
                client.field_1724.field_7512 = screen.method_17577();
                client.method_1507((class_437)screen);
            }
        });
    }

    static {
        Client.registerVehicleScreen(BambooBee.class, (vehicle, handler, player) -> new BambooBeeScreen((BambooBee)((Object)vehicle), (VehicleScreenHandler)handler, player.method_31548(), vehicle.method_5476()));
        Client.registerVehicleScreen(TunnelDigger.class, (vehicle, handler, player) -> new TunnelDiggerScreen((TunnelDigger)((Object)vehicle), (VehicleScreenHandler)handler, player.method_31548(), vehicle.method_5476()));
        Client.registerVehicleScreen(Copperfin.class, (vehicle, handler, player) -> new CopperfinScreen((Copperfin)((Object)vehicle), (VehicleScreenHandler)handler, player.method_31548(), vehicle.method_5476()));
        SlotRenderer.register((String)Common.SLOT_SHARDS, (SlotRenderer.Renderer)new MachinerySlotRenderer(0, 22, false));
        SlotRenderer.register((String)Common.SLOT_FILTER, (SlotRenderer.Renderer)new MachinerySlotRenderer(110, 18, true));
    }

    @FunctionalInterface
    static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

