/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.google.common.collect.Lists;
import earth.terrarium.adastra.api.systems.GravityApi;
import immersive_aircraft.CompatUtil;
import immersive_aircraft.Main;
import immersive_aircraft.Sounds;
import immersive_aircraft.client.KeyBindings;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.data.VehicleDataLoader;
import immersive_aircraft.entity.misc.BoundingBoxDescriptor;
import immersive_aircraft.entity.misc.PositionDescriptor;
import immersive_aircraft.network.c2s.CollisionMessage;
import immersive_aircraft.network.c2s.CommandMessage;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5250;
import net.minecraft.class_5275;
import net.minecraft.class_5712;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class VehicleEntity
extends class_1297 {
    public final class_2960 identifier;
    private static final class_2940<Float> DATA_HEALTH = class_2945.method_12791(VehicleEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(VehicleEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(VehicleEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(VehicleEntity.class, (class_2941)class_2943.field_13320);
    protected final boolean canExplodeOnCrash;
    protected static final class_2940<Integer> BOOST = class_2945.method_12791(VehicleEntity.class, (class_2941)class_2943.field_13327);
    protected int interpolationSteps;
    protected int lastTriedToExit;
    protected double x;
    protected double y;
    protected double z;
    protected double serverYRot;
    protected double serverXRot;
    protected float movementX;
    protected float movementY;
    protected float movementZ;
    public final InterpolatedFloat pressingInterpolatedX;
    public final InterpolatedFloat pressingInterpolatedY;
    public final InterpolatedFloat pressingInterpolatedZ;
    public float roll;
    public float prevRoll;
    public double lastX;
    public double lastY;
    public double lastZ;
    public double secondLastX;
    public double secondLastY;
    public double secondLastZ;
    public boolean adaptPlayerRotation = true;
    private int drowning;
    protected static final Vector4f ZERO_VEC4 = new Vector4f();

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    public void method_36457(float pitch) {
        float loops = (float)(Math.floor((pitch + 180.0f) / 360.0f) * 360.0);
        this.field_6004 -= loops;
        super.method_36457(pitch -= loops);
    }

    public void setZRot(float rot) {
        this.roll = rot;
    }

    public void boost() {
        this.boost(100);
    }

    public void boost(int ticks) {
        this.field_6011.method_12778(BOOST, (Object)ticks);
    }

    protected void applyBoost() {
    }

    public boolean canBoost() {
        return false;
    }

    public int getBoost() {
        return (Integer)this.field_6011.method_12789(BOOST);
    }

    public List<List<PositionDescriptor>> getPassengerPositions() {
        return VehicleDataLoader.get(this.identifier).getPassengerPositions();
    }

    public int getPassengerSpace() {
        return this.getPassengerPositions().size();
    }

    public VehicleEntity(class_1299<? extends VehicleEntity> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super(entityType, world);
        this.canExplodeOnCrash = canExplodeOnCrash;
        this.field_23807 = true;
        this.method_49477(0.55f);
        this.pressingInterpolatedX = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedY = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedZ = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.identifier = class_7923.field_41177.method_10221((Object)this.method_5864());
    }

    public void fromItemStack(class_1799 stack) {
        if (stack.method_7985()) {
            assert (stack.method_7969() != null);
            this.readItemTag(stack.method_7969());
        }
    }

    protected float getInputInterpolationSteps() {
        return 10.0f;
    }

    protected float method_18378(@NotNull class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    protected void method_5693() {
        this.field_6011.method_12784(DAMAGE_WOBBLE_TICKS, (Object)0);
        this.field_6011.method_12784(DAMAGE_WOBBLE_SIDE, (Object)1);
        this.field_6011.method_12784(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_HEALTH, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(BOOST, (Object)0);
    }

    public boolean method_30949(@NotNull class_1297 other) {
        return VehicleEntity.canCollide(this, other);
    }

    public static boolean canCollide(class_1297 entity, class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !entity.method_5794(other);
    }

    public boolean method_30948() {
        return true;
    }

    protected class_243 method_30633(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2350.class_2351 portalAxis, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5459.class_5460 portalRect) {
        return class_1309.method_31079((class_243)super.method_30633(portalAxis, portalRect));
    }

    public boolean method_5698(@NotNull class_1297 attacker) {
        return this.method_5626(attacker) || super.method_5698(attacker);
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (this.method_37908().field_9236 || this.method_31481()) {
            return true;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (player.method_31549().field_7477) {
                this.dropInventory();
                this.method_31472();
                return true;
            }
        }
        if (amount > 0.0f && source.method_5529() instanceof class_1657 && this.method_5685().isEmpty() && !source.method_48790()) {
            amount = Math.max(5.0f, amount);
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength((float)((double)this.getDamageWobbleStrength() + Math.sqrt(amount) * 5.0 / (double)(1.0f + this.getDamageWobbleStrength() * 0.05f)));
        this.method_32875(class_5712.field_28736, source.method_5529());
        boolean force = !(source.method_5526() instanceof class_1657);
        this.applyDamage(amount / this.getDurability() / (float)Config.getInstance().damagePerHealthPoint, force);
        return true;
    }

    private void applyDamage(float amount, boolean force) {
        if (this.method_31481()) {
            return;
        }
        float health = this.getHealth() - amount;
        if (health <= 0.0f) {
            this.setHealth(0.0f);
            if (force && this.canExplodeOnCrash && Config.getInstance().enableCrashExplosion) {
                this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), Config.getInstance().crashExplosionRadius, Config.getInstance().enableCrashFire, Config.getInstance().enableCrashBlockDestruction ? class_1937.class_7867.field_40890 : class_1937.class_7867.field_40888);
            }
            if (this.method_37908().method_8450().method_8355(class_1928.field_19393) && Config.getInstance().enableDropsForNonPlayer) {
                this.dropInventory();
                this.drop();
            }
            this.method_31472();
        } else {
            this.setHealth(health);
        }
    }

    private void repair(float amount) {
        float health = Math.min(1.0f, this.getHealth() + amount);
        this.setHealth(health);
    }

    public float getDurability() {
        return 1.0f;
    }

    protected void drop() {
        if (Config.getInstance().dropAircraft) {
            class_1799 stack = new class_1799((class_1935)this.asItem());
            class_2487 tag = stack.method_7948();
            this.addItemTag(tag);
            this.method_5775(stack);
        }
    }

    protected void dropInventory() {
    }

    public void method_5700(boolean drag) {
        this.method_37908().method_8406((class_2394)class_2398.field_11202, this.method_23317() + (double)this.field_5974.method_43057(), this.method_23318() + 0.7, this.method_23321() + (double)this.field_5974.method_43057(), 0.0, 0.0, 0.0);
        if (this.field_5974.method_43048(20) == 0) {
            this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), this.method_5625(), this.method_5634(), 1.0f, 0.8f + 0.4f * this.field_5974.method_43057(), false);
        }
        this.method_32875(class_5712.field_28160, (class_1297)this.method_5642());
    }

    public class_1792 asItem() {
        return class_1802.field_8600;
    }

    public void method_5879(float yaw) {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    private static float getMovementMultiplier(boolean positive, boolean negative) {
        if (positive == negative) {
            return 0.0f;
        }
        return positive ? 1.0f : -1.0f;
    }

    protected boolean useAirplaneControls() {
        return false;
    }

    public void method_5773() {
        int t;
        if (this.field_6012 % 10 == 0) {
            this.secondLastX = this.lastX;
            this.secondLastY = this.lastY;
            this.secondLastZ = this.lastZ;
            this.lastX = this.method_23317();
            this.lastY = this.method_23318();
            this.lastZ = this.method_23321();
            if (this.secondLastX == 0.0 && this.secondLastY == 0.0 && this.secondLastZ == 0.0) {
                this.secondLastX = this.lastX;
                this.secondLastY = this.lastY;
                this.secondLastZ = this.lastZ;
            }
        }
        if (!this.method_5685().isEmpty()) {
            this.tickPilot();
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.method_5773();
        this.handleClientSync();
        int boost = this.getBoost();
        if (boost > 0) {
            this.field_6011.method_12778(BOOST, (Object)(boost - 1));
        }
        if (this.method_5787()) {
            this.updateVelocity();
            if (boost > 0) {
                this.applyBoost();
            }
            this.updateController();
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
        this.method_5852();
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009((double)0.2f, (double)-0.01f, (double)0.2f), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            boolean bl = !this.method_37908().field_9236 && !(this.method_5642() instanceof class_1657);
            for (class_1297 entity : list) {
                if (entity.method_5626((class_1297)this) || !bl || this.method_5685().size() >= this.getPassengerSpace() - 1 || entity.method_5765() || !(entity.method_17681() < this.method_17681()) || !(entity instanceof class_1309) || entity instanceof class_1480 || entity instanceof class_1657) continue;
                entity.method_5804((class_1297)this);
            }
        }
        if (this.method_5787()) {
            this.pressingInterpolatedX.update(this.movementX);
            this.pressingInterpolatedY.update(this.movementY);
            this.pressingInterpolatedZ.update(this.movementZ);
        }
        this.tickDamageParticles();
        if (!this.method_37908().field_9236 && (t = Config.getInstance().regenerateHealthEveryNTicks) > 0 && this.method_37908().method_8510() % (long)t == 0L) {
            this.repair(0.05f / this.getDurability());
        }
    }

    private void tickDamageParticles() {
        double z;
        double y;
        double x;
        class_243 center;
        if (this.method_37908().field_9236 && this.field_5974.method_43057() > this.getHealth()) {
            List<class_238> shapes = this.getShapes();
            class_238 shape = shapes.get(this.field_5974.method_43048(shapes.size()));
            center = shape.method_1005();
            x = center.field_1352 + shape.method_17939() * (this.field_5974.method_43058() - 0.5) * 1.5;
            y = center.field_1351 + shape.method_17940() * (this.field_5974.method_43058() - 0.5) * 1.5;
            z = center.field_1350 + shape.method_17941() * (this.field_5974.method_43058() - 0.5) * 1.5;
            class_243 speed = this.getSpeedVector();
            this.method_37908().method_8406((class_2394)class_2398.field_11251, x, y, z, speed.field_1352, speed.field_1351, speed.field_1350);
            if ((double)this.getHealth() < 0.5) {
                this.method_37908().method_8406((class_2394)class_2398.field_27783, x, y, z, speed.field_1352, speed.field_1351, speed.field_1350);
            }
        }
        if (this.method_5869() && this.drowning < 200) {
            ++this.drowning;
            for (class_238 shape : this.getShapes()) {
                center = shape.method_1005();
                x = center.field_1352 + shape.method_17939() * (this.field_5974.method_43058() - 0.5) * 1.5;
                y = center.field_1351 + shape.method_17940() * (this.field_5974.method_43058() - 0.5) * 1.5;
                z = center.field_1350 + shape.method_17941() * (this.field_5974.method_43058() - 0.5) * 1.5;
                this.method_37908().method_8406((class_2394)class_2398.field_11247, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void tickPilot() {
        class_1657 player;
        for (class_1297 entity : this.method_5685()) {
            class_1657 player2;
            if (!(entity instanceof class_1657) || !(player2 = (class_1657)entity).method_7340()) continue;
            if (KeyBindings.down.method_1434() && this.method_24828() && this.method_18798().method_1033() < 0.01) {
                player2.method_7353((class_2561)class_2561.method_43469((String)"mount.onboard", (Object[])new Object[]{KeyBindings.dismount.method_16007()}), true);
            }
            if (KeyBindings.dismount.method_1436()) {
                if (this.method_24828() || this.field_6012 - this.lastTriedToExit < 20) {
                    NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.DISMOUNT, this.method_18798()));
                    player2.method_6100(false);
                } else {
                    this.lastTriedToExit = this.field_6012;
                    player2.method_7353((class_2561)class_2561.method_43471((String)"immersive_aircraft.tried_dismount"), true);
                }
            }
            if (!KeyBindings.boost.method_1436() || !this.canBoost()) continue;
            NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.BOOST, this.method_18798()));
            class_243 p = this.method_19538();
            this.method_37908().method_8486(p.method_10216(), p.method_10214(), p.method_10215(), class_3417.field_14702, class_3419.field_15254, 1.0f, 1.0f, true);
        }
        class_1297 pilot = (class_1297)this.method_5685().get(0);
        if (pilot instanceof class_1657 && (player = (class_1657)pilot).method_7340()) {
            this.setInputs(VehicleEntity.getMovementMultiplier(KeyBindings.left.method_1434(), KeyBindings.right.method_1434()), VehicleEntity.getMovementMultiplier(KeyBindings.up.method_1434(), KeyBindings.down.method_1434()), VehicleEntity.getMovementMultiplier(this.useAirplaneControls() ? KeyBindings.push.method_1434() : KeyBindings.forward.method_1434(), this.useAirplaneControls() ? KeyBindings.pull.method_1434() : KeyBindings.backward.method_1434()));
        } else {
            this.setInputs(0.0f, 0.0f, 0.0f);
        }
    }

    private void handleClientSync() {
        if (this.method_5787()) {
            this.interpolationSteps = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.method_23317() + (this.x - this.method_23317()) / (double)this.interpolationSteps;
        double interpolatedY = this.method_23318() + (this.y - this.method_23318()) / (double)this.interpolationSteps;
        double interpolatedZ = this.method_23321() + (this.z - this.method_23321()) / (double)this.interpolationSteps;
        double interpolatedYaw = class_3532.method_15338((double)(this.serverYRot - (double)this.method_36454()));
        this.method_36456(this.method_36454() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.method_36457(this.method_36455() + (float)(this.serverXRot - (double)this.method_36455()) / (float)this.interpolationSteps);
        this.method_5814(interpolatedX, interpolatedY, interpolatedZ);
        this.method_5710(this.method_36454(), this.method_36455());
        --this.interpolationSteps;
    }

    protected abstract void updateVelocity();

    protected float getGravity() {
        return -0.04f * (CompatUtil.isModLoaded("ad_astra") ? GravityApi.API.getGravity(this.method_37908(), class_2338.method_49638((class_2374)this.method_33571())) : 1.0f);
    }

    protected abstract void updateController();

    public void method_5865(@NotNull class_1297 passenger, @NotNull class_1297.class_4738 positionUpdater) {
        int i;
        List<List<PositionDescriptor>> positions;
        if (!this.method_5626(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        int size = this.method_5685().size() - 1;
        if (size < (positions = this.getPassengerPositions()).size() && (i = this.method_5685().indexOf(passenger)) >= 0 && i < positions.get(size).size()) {
            PositionDescriptor positionDescriptor = positions.get(size).get(i);
            float x = positionDescriptor.x();
            float y = positionDescriptor.y();
            float z = positionDescriptor.z();
            if (passenger instanceof class_1429) {
                z += 0.2f;
            }
            Vector4f worldPosition = this.transformPosition(transform, x, y += (float)passenger.method_5678(), z);
            passenger.method_5814((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            if (this.adaptPlayerRotation) {
                passenger.method_36456(passenger.method_36454() + (this.method_36454() - this.field_5982));
                passenger.method_5847(passenger.method_5791() + (this.method_36454() - this.field_5982));
            }
            positionUpdater.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            this.copyEntityData(passenger);
            if (passenger instanceof class_1429) {
                class_1429 animal = (class_1429)passenger;
                if (size > 1) {
                    int angle = passenger.method_5628() % 2 == 0 ? 90 : 270;
                    passenger.method_5636(animal.field_6283 + (float)angle);
                    passenger.method_5847(passenger.method_5791() + (float)angle);
                }
            }
        }
    }

    private class_243 getDismountOffset(double vehicleWidth, double passengerWidth) {
        double offset = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float yaw = this.method_36454() + 90.0f;
        float x = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
        float z = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
        float n = Math.max(Math.abs(x), Math.abs(z));
        return new class_243((double)x * offset / (double)n, 0.0, (double)z * offset / (double)n);
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 vec3d = this.getDismountOffset(this.method_17681() * class_3532.field_15724, passenger.method_17681() * class_3532.field_15724);
        double ox = this.method_23317() + vec3d.field_1352;
        double oz = this.method_23321() + vec3d.field_1350;
        class_2338 exitPos = new class_2338((int)ox, (int)this.method_23318(), (int)oz);
        class_2338 floorPos = exitPos.method_10074();
        if (!this.method_37908().method_22351(floorPos)) {
            double floorHeight;
            ArrayList list = Lists.newArrayList();
            double exitHeight = this.method_37908().method_30347(exitPos);
            if (class_5275.method_27932((double)exitHeight)) {
                list.add(new class_243(ox, (double)exitPos.method_10264() + exitHeight, oz));
            }
            if (class_5275.method_27932((double)(floorHeight = this.method_37908().method_30347(floorPos)))) {
                list.add(new class_243(ox, (double)floorPos.method_10264() + floorHeight, oz));
            }
            for (class_4050 entityPose : passenger.method_24831()) {
                for (class_243 vec3d2 : list) {
                    if (!class_5275.method_33353((class_1941)this.method_37908(), (class_243)vec3d2, (class_1309)passenger, (class_4050)entityPose)) continue;
                    passenger.method_18380(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.method_24829(passenger);
    }

    public void copyEntityData(class_1297 entity) {
        entity.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entity.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entity.field_5982 += g - f;
        entity.method_36456(entity.method_36454() + g - f);
        entity.method_5847(entity.method_36454());
    }

    public void method_5644(@NotNull class_1297 passenger) {
        this.copyEntityData(passenger);
    }

    protected void method_5652(@NotNull class_2487 tag) {
        tag.method_10548("VehicleHealth", this.getHealth());
    }

    protected void method_5749(@NotNull class_2487 tag) {
        if (tag.method_10545("VehicleHealth")) {
            this.setHealth(tag.method_10583("VehicleHealth"));
        }
    }

    protected void addItemTag(@NotNull class_2487 tag) {
        class_2487 displayTag = new class_2487();
        tag.method_10566("display", (class_2520)displayTag);
        if (this.method_16914()) {
            displayTag.method_10582("Name", class_2561.class_2562.method_10867((class_2561)this.method_5797()));
        }
    }

    protected void readItemTag(@NotNull class_2487 tag) {
        class_2487 displayTag = tag.method_10562("display");
        if (displayTag.method_10573("Name", 8)) {
            this.method_5665((class_2561)class_2561.class_2562.method_10877((String)displayTag.method_10558("Name")));
        }
    }

    public boolean method_5740() {
        return true;
    }

    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.getHealth() < 1.0f && (player.method_5715() || !Config.getInstance().requireShiftForRepair) && !this.method_5626((class_1297)player)) {
            if (!this.method_37908().field_9236) {
                player.method_7322(Config.getInstance().repairExhaustion);
                this.repair(Config.getInstance().repairSpeed);
                class_5250 component = class_2561.method_43469((String)"immersive_aircraft.repair", (Object[])new Object[]{(int)(this.getHealth() * 100.0f)});
                if ((double)this.getHealth() < 0.33) {
                    component.method_27692(class_124.field_1061);
                } else if ((double)this.getHealth() < 0.66) {
                    component.method_27692(class_124.field_1065);
                } else {
                    component.method_27692(class_124.field_1060);
                }
                player.method_7353((class_2561)component, true);
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Sounds.REPAIR.get(), class_3419.field_15254, 1.0f, 0.7f + this.field_5974.method_43057() * 0.2f);
            } else {
                for (class_238 shape : this.getAdditionalShapes()) {
                    for (int i = 0; i < 5; ++i) {
                        class_243 center = shape.method_1005();
                        double x = center.field_1352 + shape.method_17939() * (this.field_5974.method_43058() - 0.5) * 1.5;
                        double y = center.field_1351 + shape.method_17940() * (this.field_5974.method_43058() - 0.5) * 1.5;
                        double z = center.field_1350 + shape.method_17941() * (this.field_5974.method_43058() - 0.5) * 1.5;
                        this.method_37908().method_8406((class_2394)class_2398.field_17741, x, y, z, 0.0, this.field_5974.method_43058(), 0.0);
                    }
                }
            }
            return class_1269.field_21466;
        }
        if (!this.isValidDimension()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"immersive_aircraft.invalid_dimension"), true);
            return class_1269.field_5814;
        }
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (!this.method_37908().field_9236) {
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (this.method_5626((class_1297)player)) {
            return class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public void method_5784(@NotNull class_1313 movementType, @NotNull class_243 movement) {
        class_243 prediction = this.method_19538().method_1019(movement);
        super.method_5784(movementType, movement);
        if ((this.field_5992 || this.field_5976) && this.method_37908().field_9236 && Config.getInstance().collisionDamage) {
            float repeat;
            float collision;
            double maxPossibleError = movement.method_1033();
            double error = prediction.method_1022(this.method_19538());
            if (error <= maxPossibleError && (collision = (float)(error - (this.field_5992 ? (double)Math.abs(this.getGravity()) : 0.0)) - 0.05f) > 0.0f && (repeat = 1.0f - (float)(this.getDamageWobbleTicks() + 1) / 10.0f) > 1.0E-4f) {
                float damage = collision * Config.getInstance().collisionDamageMultiplier * repeat * repeat;
                NetworkHandler.sendToServer(new CollisionMessage(damage));
            }
        }
    }

    protected void method_5623(double heightDifference, boolean onGround, @NotNull class_2680 landedState, @NotNull class_2338 landedPosition) {
    }

    public void setDamageWobbleStrength(float wobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(wobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public void setDamageWobbleTicks(int wobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    public void setDamageWobbleSide(int side) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, (Object)side);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    public float getHealth() {
        return ((Float)this.field_6011.method_12789(DATA_HEALTH)).floatValue();
    }

    public void setHealth(float damage) {
        this.field_6011.method_12778(DATA_HEALTH, (Object)Float.valueOf(damage));
    }

    protected boolean method_5818(@NotNull class_1297 passenger) {
        return this.method_5685().size() < this.getPassengerSpace() && !this.method_5777(class_3486.field_15517);
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1309) {
            class_1309 le = (class_1309)class_12972;
            return le;
        }
        return super.method_5642();
    }

    @Nullable
    public class_1297 getGunner(int offset) {
        List passengers = this.method_5685();
        return passengers.isEmpty() ? null : (class_1297)passengers.get(Math.max(0, passengers.size() - 1 - offset));
    }

    public void setInputs(float x, float y, float z) {
        this.movementX = x;
        this.movementY = y;
        this.movementZ = z;
    }

    public boolean canTurnOnEngine(class_1297 pilot) {
        return pilot instanceof class_1657;
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.asItem());
    }

    public boolean isWithinParticleRange() {
        return Main.cameraGetter.getPosition().method_1025(this.method_19538()) < 1024.0;
    }

    protected Vector4f transformPosition(Matrix4f transform, float x, float y, float z) {
        return transform.transform(new Vector4f(x, y, z, 1.0f));
    }

    protected Vector3f transformVector(float x, float y, float z) {
        return this.transformVector(this.getVehicleNormalTransform(), x, y, z);
    }

    protected Vector3f transformVectorQuantized(float x, float y, float z) {
        return this.transformVector(this.getVehicleNormalTransformQuantized(), x, y, z);
    }

    protected Vector3f transformVector(Matrix3f transform, float x, float y, float z) {
        return transform.transform(new Vector3f(x, y, z));
    }

    public Matrix4f getVehicleTransform() {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)this.method_23317(), (float)this.method_23318(), (float)this.method_23321());
        transform.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-this.method_36454()));
        transform.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(this.method_36455()));
        transform.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.getRoll()));
        return transform;
    }

    private float quantize(float value) {
        int floor = class_3532.method_15375((float)(value * 256.0f / 360.0f));
        return (float)(floor * 360) / 256.0f;
    }

    public Matrix3f getVehicleNormalTransformQuantized() {
        Matrix3f transform = new Matrix3f();
        transform.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-this.quantize(this.method_36454())));
        transform.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(this.quantize(this.method_36455())));
        transform.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.quantize(this.getRoll())));
        return transform;
    }

    public Matrix3f getVehicleNormalTransform() {
        Matrix3f transform = new Matrix3f();
        transform.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-this.method_36454()));
        transform.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(this.method_36455()));
        transform.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.getRoll()));
        return transform;
    }

    public Vector3f getForwardDirection() {
        return this.transformVector(0.0f, 0.0f, 1.0f);
    }

    public Vector3f getRightDirection() {
        Vector3f f = this.transformVector(1.0f, 0.0f, 0.0f);
        return new Vector3f(f.x(), f.y(), f.z());
    }

    public Vector3f getTopDirection() {
        return this.transformVector(0.0f, 1.0f, 0.0f);
    }

    public boolean method_5640(double distance) {
        double d = (double)Config.getInstance().renderDistance * VehicleEntity.method_5824();
        return distance < d * d;
    }

    public void chill() {
    }

    public class_243 toVec3d(Vector3f v) {
        return new class_243((double)v.x, (double)v.y, (double)v.z);
    }

    public boolean isValidDimension() {
        return Config.getInstance().validDimensions.getOrDefault(this.method_37908().method_27983().method_29177().toString(), true);
    }

    protected class_238 getOffsetBoundingBox(BoundingBoxDescriptor descriptor) {
        Vector3f center = this.transformVectorQuantized(descriptor.x(), descriptor.y(), descriptor.z());
        return new class_238((double)center.x() - (double)descriptor.width() / 2.0 + this.method_23317(), (double)center.y() - (double)descriptor.height() / 2.0 + this.method_23318(), (double)center.z() - (double)descriptor.width() / 2.0 + this.method_23321(), (double)center.x() + (double)descriptor.width() / 2.0 + this.method_23317(), (double)center.y() + (double)descriptor.height() / 2.0 + this.method_23318(), (double)center.z() + (double)descriptor.width() / 2.0 + this.method_23321());
    }

    public List<class_238> getAdditionalShapes() {
        return VehicleDataLoader.get(this.identifier).getBoundingBoxes().stream().map(this::getOffsetBoundingBox).toList();
    }

    public List<class_238> getShapes() {
        ArrayList<class_238> shapes = new ArrayList<class_238>(this.getAdditionalShapes());
        shapes.add(this.method_5829());
        return shapes;
    }

    public class_243 getSpeedVector() {
        return new class_243((this.lastX - this.secondLastX) / 10.0, (this.lastY - this.secondLastY) / 10.0, (this.lastZ - this.secondLastZ) / 10.0);
    }

    public boolean isPilotCreative() {
        class_1657 player;
        class_1309 class_13092 = this.method_5642();
        return class_13092 instanceof class_1657 && (player = (class_1657)class_13092).method_7337();
    }

    public double getZoom() {
        return 0.0;
    }

    public class_238 method_5830() {
        class_238 box = super.method_5830();
        for (class_238 additionalShape : this.getAdditionalShapes()) {
            box = box.method_991(additionalShape);
        }
        return box;
    }

    public void setAnimationVariables(float tickDelta) {
        BBAnimationVariables.set("pressing_interpolated_x", this.pressingInterpolatedX.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_y", this.pressingInterpolatedY.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_z", this.pressingInterpolatedZ.getSmooth(tickDelta));
        class_243 speed = this.getSpeedVector();
        BBAnimationVariables.set("velocity_x", (float)speed.field_1352);
        BBAnimationVariables.set("velocity_y", (float)speed.field_1351);
        BBAnimationVariables.set("velocity_z", (float)speed.field_1350);
    }

    public class_2561 method_5476() {
        return super.method_5476();
    }
}

