/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.peripheral.dim_stack.DimEntryWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimListWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntryEditScreen;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGuiController;
import qouteall.imm_ptl.peripheral.dim_stack.SelectDimensionScreen;
import qouteall.q_misc_util.my_util.GuiHelper;

@Environment(value=EnvType.CLIENT)
public class DimStackScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(DimStackScreen.class);
    private final DimStackGuiController controller;
    @Nullable
    public final class_437 parent;
    private final class_4185 finishButton;
    private final class_4185 toggleButton;
    private final class_4185 addDimensionButton;
    private final class_4185 removeDimensionButton;
    private final class_4185 editButton;
    private final class_4185 helpButton;
    private final class_4185 setAsPresetButton;
    private final class_4185 loopButton;
    private final class_4185 gravityModeButton;
    private int titleY;
    public final DimListWidget dimListWidget;
    private boolean isEnabled = false;

    public DimStackScreen(@Nullable class_437 parent, DimStackGuiController controller) {
        super((class_2561)class_2561.method_43471((String)"imm_ptl.altius_screen"));
        this.parent = parent;
        this.toggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"..."), buttonWidget -> controller.toggleEnabled()).method_46431();
        this.loopButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"..."), buttonWidget -> controller.toggleLoop()).method_46431();
        this.gravityModeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"..."), gravityModeButton -> controller.toggleGravityMode()).method_46431();
        this.finishButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"imm_ptl.finish"), buttonWidget -> controller.onFinish()).method_46431();
        this.controller = controller;
        this.addDimensionButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"imm_ptl.dim_stack_add"), buttonWidget -> this.onAddEntry()).method_46431();
        this.removeDimensionButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"imm_ptl.dim_stack_remove"), buttonWidget -> this.onRemoveEntry()).method_46431();
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"imm_ptl.dim_stack_edit"), buttonWidget -> this.onEditEntry()).method_46431();
        this.dimListWidget = new DimListWidget(this.field_22789, this.field_22790, 100, 200, 50, this, DimListWidget.Type.mainDimensionList, controller::onDragged);
        this.helpButton = DimStackScreen.createHelpButton(this);
        this.setAsPresetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"imm_ptl.set_as_dim_stack_default"), button -> this.controller.setAsDefault()).method_46431();
    }

    public void setLoopEnabled(boolean loopEnabled) {
        this.loopButton.method_25355((class_2561)class_2561.method_43471((String)(loopEnabled ? "imm_ptl.loop_enabled" : "imm_ptl.loop_disabled")));
    }

    public void setGravityTransformEnabled(boolean gravityTransformEnabled) {
        this.gravityModeButton.method_25355((class_2561)class_2561.method_43471((String)(gravityTransformEnabled ? "imm_ptl.dim_stack.gravity_transform_enabled" : "imm_ptl.dim_stack.gravity_transform_disabled")));
    }

    public static class_4185 createHelpButton(class_437 parent) {
        return class_4185.method_46430((class_2561)class_2561.method_43470((String)"?"), button -> CHelper.openLinkConfirmScreen((class_437)parent, (String)"https://qouteall.fun/immptl/wiki/Dimension-Stack")).method_46431();
    }

    public DimEntryWidget createDimEntryWidget(DimStackEntry entry) {
        return new DimEntryWidget(entry.getDimension(), this.dimListWidget, this.getElementSelectCallback(), entry);
    }

    protected void method_25426() {
        this.method_37063((class_364)this.toggleButton);
        this.method_37063((class_364)this.finishButton);
        this.method_37063((class_364)this.addDimensionButton);
        this.method_37063((class_364)this.removeDimensionButton);
        this.method_37063((class_364)this.editButton);
        this.method_37063((class_364)this.helpButton);
        this.method_37063((class_364)this.setAsPresetButton);
        this.method_37063((class_364)this.loopButton);
        this.method_37063((class_364)this.gravityModeButton);
        this.method_25429((class_364)this.dimListWidget);
        GuiHelper.layout((int)0, (int)this.field_22790, (GuiHelper.LayoutElement[])new GuiHelper.LayoutElement[]{GuiHelper.blankSpace((int)5), new GuiHelper.LayoutElement(true, 20, (from, to) -> {
            this.helpButton.method_46421(this.field_22789 - 30);
            this.helpButton.method_46419(from);
            this.helpButton.method_25358(20);
            this.setAsPresetButton.method_46421(this.field_22789 - 125);
            this.setAsPresetButton.method_46419(from);
            this.setAsPresetButton.method_25358(90);
        }), new GuiHelper.LayoutElement(true, 20, GuiHelper.combine((GuiHelper.LayoutFunc[])new GuiHelper.LayoutFunc[]{GuiHelper.layoutButtonVertically((class_339)this.toggleButton), GuiHelper.layoutButtonVertically((class_339)this.loopButton), GuiHelper.layoutButtonVertically((class_339)this.gravityModeButton)})), GuiHelper.blankSpace((int)5), new GuiHelper.LayoutElement(false, 1, (from, to) -> this.dimListWidget.method_25323(this.field_22789, this.field_22790, from, to)), GuiHelper.blankSpace((int)5), new GuiHelper.LayoutElement(true, 20, (from, to) -> {
            this.finishButton.method_46419(from);
            this.addDimensionButton.method_46419(from);
            this.removeDimensionButton.method_46419(from);
            this.editButton.method_46419(from);
            GuiHelper.layout((int)0, (int)this.field_22789, (GuiHelper.LayoutElement[])new GuiHelper.LayoutElement[]{GuiHelper.blankSpace((int)10), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((class_339)this.finishButton)), GuiHelper.blankSpace((int)5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((class_339)this.addDimensionButton)), GuiHelper.blankSpace((int)5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((class_339)this.removeDimensionButton)), GuiHelper.blankSpace((int)5), new GuiHelper.LayoutElement(false, 1, GuiHelper.layoutButtonHorizontally((class_339)this.editButton)), GuiHelper.blankSpace((int)10)});
        }), GuiHelper.blankSpace((int)5)});
        GuiHelper.layout((int)0, (int)this.field_22789, (GuiHelper.LayoutElement[])new GuiHelper.LayoutElement[]{GuiHelper.blankSpace((int)10), new GuiHelper.LayoutElement(false, 10, GuiHelper.layoutButtonHorizontally((class_339)this.toggleButton)), GuiHelper.blankSpace((int)5), new GuiHelper.LayoutElement(false, 8, GuiHelper.layoutButtonHorizontally((class_339)this.loopButton)), GuiHelper.blankSpace((int)5), new GuiHelper.LayoutElement(false, 10, GuiHelper.layoutButtonHorizontally((class_339)this.gravityModeButton)), GuiHelper.blankSpace((int)10)});
    }

    public void method_25419() {
        this.controller.onFinish();
    }

    private Consumer<DimEntryWidget> getElementSelectCallback() {
        return w -> this.dimListWidget.method_25313((class_350.class_351)w);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        if (this.isEnabled) {
            this.dimListWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        class_327 font = class_310.method_1551().field_1772;
        guiGraphics.method_27535(font, this.field_22785, 20, 10, -1);
    }

    public void setEnabled(boolean cond) {
        this.isEnabled = cond;
        if (this.isEnabled) {
            this.toggleButton.method_25355((class_2561)class_2561.method_43471((String)"imm_ptl.altius_toggle_true"));
        } else {
            this.toggleButton.method_25355((class_2561)class_2561.method_43471((String)"imm_ptl.altius_toggle_false"));
        }
        this.addDimensionButton.field_22764 = this.isEnabled;
        this.removeDimensionButton.field_22764 = this.isEnabled;
        this.editButton.field_22764 = this.isEnabled;
        this.loopButton.field_22764 = this.isEnabled;
        this.gravityModeButton.field_22764 = this.isEnabled;
    }

    private void onAddEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.method_25334();
        int position = selected == null ? 0 : this.dimListWidget.method_25396().indexOf((Object)selected);
        if (position < 0 || position > this.dimListWidget.method_25396().size()) {
            position = -1;
        }
        int insertingPosition = position + 1;
        class_310.method_1551().method_1507((class_437)new SelectDimensionScreen(this, dimensionType -> this.controller.addEntry(insertingPosition, new DimStackEntry((class_5321<class_1937>)dimensionType)), this.controller.getDimensionList()));
    }

    private void onRemoveEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.method_25334();
        if (selected == null) {
            return;
        }
        int position = this.dimListWidget.method_25396().indexOf((Object)selected);
        if (position == -1) {
            return;
        }
        this.controller.removeEntry(position);
    }

    private void onEditEntry() {
        DimEntryWidget selected = (DimEntryWidget)this.dimListWidget.method_25334();
        if (selected == null) {
            return;
        }
        class_310.method_1551().method_1507((class_437)new DimStackEntryEditScreen(this, selected, () -> {
            int newlyChangingEntryIndex = this.dimListWidget.method_25396().indexOf((Object)selected);
            if (newlyChangingEntryIndex == -1) {
                LOGGER.error("The edited entry is missing in the list");
                return;
            }
            this.controller.editEntry(newlyChangingEntryIndex, selected.entry);
        }));
    }
}

