/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;

public class KnockoutRestrictionHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(UseBlockEvent.class, KnockoutRestrictionHandler::onUseBlock, EventPriority.Highest);
        Balm.getEvents().onEvent(UseItemEvent.class, KnockoutRestrictionHandler::onUseItem, EventPriority.Highest);
        Balm.getEvents().onEvent(TossItemEvent.class, KnockoutRestrictionHandler::onTossItem, EventPriority.Highest);
        Balm.getEvents().onEvent(PlayerAttackEvent.class, KnockoutRestrictionHandler::onAttack, EventPriority.Highest);
        Balm.getEvents().onEvent(DigSpeedEvent.class, KnockoutRestrictionHandler::onDigSpeed, EventPriority.Highest);
        Balm.getEvents().onEvent(LivingHealEvent.class, KnockoutRestrictionHandler::onHeal);
    }

    public static void onHeal(LivingHealEvent event) {
        class_1657 player;
        class_1309 class_13092 = event.getEntity();
        if (class_13092 instanceof class_1657 && HardcoreRevival.getRevivalData((class_1297)(player = (class_1657)class_13092)).isKnockedOut()) {
            event.setCanceled(false);
        }
    }

    public static void onDigSpeed(DigSpeedEvent event) {
        class_1657 player = event.getPlayer();
        if (player != null && HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut()) {
            event.setSpeedOverride(Float.valueOf(0.0f));
            event.setCanceled(true);
        }
    }

    public static void onUseBlock(UseBlockEvent event) {
        class_1657 player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut()) {
            class_1799 itemStack = player.method_5998(event.getHand());
            if (!HardcoreRevivalConfig.getActive().allowBows || !(itemStack.method_7909() instanceof class_1753)) {
                event.setCanceled(true);
            }
        }
    }

    public static void onUseItem(UseItemEvent event) {
        class_1657 player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut()) {
            class_1799 itemStack = player.method_5998(event.getHand());
            if (!HardcoreRevivalConfig.getActive().allowBows || !(itemStack.method_7909() instanceof class_1753)) {
                event.setCanceled(true);
            }
        }
    }

    public static void onTossItem(TossItemEvent event) {
        class_1657 player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut() && player.method_7270(event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    public static void onAttack(PlayerAttackEvent event) {
        class_1657 player = event.getPlayer();
        if (player != null && HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut()) {
            if (HardcoreRevivalConfig.getActive().allowUnarmedMelee && player.method_6047().method_7960()) {
                return;
            }
            event.setCanceled(true);
        }
    }
}

