/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeTask
extends AbstractBooleanTask {
    private static final class_5321<class_1959> DEFAULT_BIOME = class_1972.field_9451;
    private static final List<String> KNOWN_BIOMES = new ArrayList<String>();
    private Either<class_5321<class_1959>, class_6862<class_1959>> biome = Either.left(DEFAULT_BIOME);

    public BiomeTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.BIOME;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("biome", this.getBiome());
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.setBiome(nbt.method_10558("biome"));
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10814(this.getBiome());
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.setBiome(buffer.method_10800(Short.MAX_VALUE));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("biome", (Object)this.getBiome(), this::setBiome, NameMap.of((Object)DEFAULT_BIOME.method_29177().toString(), this.getKnownBiomes()).create());
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.task.ftbquests.biome").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.getBiome())).method_27692(class_124.field_1077);
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    @Override
    public boolean canSubmit(TeamData teamData, class_3222 player) {
        if (player.method_7325()) {
            return false;
        }
        class_6880 biomeHolder = player.method_37908().method_23753(player.method_24515());
        return (Boolean)this.biome.map(key -> biomeHolder.method_40230().map(k -> k == key).orElse(false), tagKey -> {
            class_2378 reg = (class_2378)player.method_37908().method_30349().method_33310(class_7924.field_41236).orElseThrow();
            return reg.method_40266(tagKey).map(holderSet -> holderSet.method_40241(biomeHolder)).orElse(false);
        });
    }

    private String getBiome() {
        return (String)this.biome.map(key -> key.method_29177().toString(), tagKey -> "#" + tagKey.comp_327());
    }

    private void setBiome(String str) {
        this.biome = str.startsWith("#") ? Either.right((Object)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)this.safeResourceLocation(str.substring(1), DEFAULT_BIOME.method_29177()))) : Either.left((Object)class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)this.safeResourceLocation(str, DEFAULT_BIOME.method_29177())));
    }

    private List<String> getKnownBiomes() {
        if (KNOWN_BIOMES.isEmpty()) {
            class_5455 registryAccess = FTBQuestsClient.getClientPlayer().method_37908().method_30349();
            KNOWN_BIOMES.addAll(registryAccess.method_30530(class_7924.field_41236).method_42021().stream().map(o -> o.method_29177().toString()).sorted(String::compareTo).toList());
            KNOWN_BIOMES.addAll(registryAccess.method_30530(class_7924.field_41236).method_40273().map(o -> "#" + o.comp_327()).sorted(String::compareTo).toList());
        }
        return KNOWN_BIOMES;
    }
}

