/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;

public final class QuestShape
extends Icon {
    private static final Map<String, QuestShape> MAP = new LinkedHashMap<String, QuestShape>();
    private static QuestShape defaultShape;
    public static NameMap<String> idMap;
    public static NameMap<String> idMapWithDefault;
    private final String id;
    private final ImageIcon background;
    private final ImageIcon outline;
    private final ImageIcon shape;
    private PixelBuffer shapePixels;

    public QuestShape(String id) {
        this.id = id;
        this.background = new ImageIcon(new class_2960("ftbquests", "textures/shapes/" + this.id + "/background.png"));
        this.outline = new ImageIcon(new class_2960("ftbquests", "textures/shapes/" + this.id + "/outline.png"));
        this.shape = new ImageIcon(new class_2960("ftbquests", "textures/shapes/" + this.id + "/shape.png"));
    }

    public static void reload(List<String> list) {
        MAP.clear();
        list.forEach(s -> MAP.put((String)s, new QuestShape((String)s)));
        defaultShape = MAP.values().iterator().next();
        idMap = NameMap.of((Object)list.get(0), list).baseNameKey("ftbquests.quest.shape").create();
        list.add(0, "default");
        idMapWithDefault = NameMap.of((Object)list.get(0), list).baseNameKey("ftbquests.quest.shape").create();
    }

    public static QuestShape get(String id) {
        return MAP.getOrDefault(id, defaultShape);
    }

    public String toString() {
        return "quest_shape:" + this.id;
    }

    @Environment(value=EnvType.CLIENT)
    public void draw(class_332 graphics, int x, int y, int w, int h) {
        this.background.draw(graphics, x, y, w, h);
        this.outline.draw(graphics, x, y, w, h);
    }

    public ImageIcon getBackground() {
        return this.background;
    }

    public ImageIcon getOutline() {
        return this.outline;
    }

    public ImageIcon getShape() {
        return this.shape;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public PixelBuffer getShapePixels() {
        if (this.shapePixels == null) {
            try {
                class_2960 shapeLoc = new class_2960("ftbquests", "textures/shapes/" + this.id + "/shape.png");
                class_3298 resource = (class_3298)class_310.method_1551().method_1478().method_14486(shapeLoc).get();
                try (InputStream stream = resource.method_14482();){
                    this.shapePixels = PixelBuffer.from((InputStream)stream);
                }
            }
            catch (Exception ex) {
                this.shapePixels = new PixelBuffer(1, 1);
                this.shapePixels.setRGB(0, 0, -1);
            }
        }
        return this.shapePixels;
    }

    public static Map<String, QuestShape> map() {
        return Collections.unmodifiableMap(MAP);
    }
}

