/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventActor;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.MultilineTextEditorScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.net.MoveMovableMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.DependencyDepthException;
import dev.ftb.mods.ftbquests.quest.DependencyLoopException;
import dev.ftb.mods.ftbquests.quest.DependencyRequirement;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardClaimType;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbquests.util.TextUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public final class Quest
extends QuestObject
implements Movable {
    public static final String PAGEBREAK_CODE = "{@pagebreak}";
    private Chapter chapter;
    private String rawSubtitle;
    private double x;
    private double y;
    private Tristate hideUntilDepsVisible;
    private String shape;
    private final List<String> rawDescription;
    private final List<QuestObject> dependencies;
    private final List<Task> tasks;
    private final List<Reward> rewards;
    private DependencyRequirement dependencyRequirement;
    private String guidePage;
    private Tristate hideDependencyLines;
    private boolean hideDependentLines;
    private int minRequiredDependencies;
    private Tristate hideTextUntilComplete;
    private Tristate disableJEI;
    private Tristate hideDetailsUntilStartable;
    private double size;
    private boolean optional;
    private int minWidth;
    private Tristate canRepeat;
    private boolean invisible;
    private int invisibleUntilTasks;
    private Tristate requireSequentialTasks;
    private double iconScale;
    private class_2561 cachedSubtitle = null;
    private List<class_2561> cachedDescription = null;
    private boolean ignoreRewardBlocking;
    private ProgressionMode progressionMode;
    private final Set<Long> dependantIDs;

    public Quest(long id, Chapter chapter) {
        super(id);
        this.chapter = chapter;
        this.rawSubtitle = "";
        this.x = 0.0;
        this.y = 0.0;
        this.shape = "";
        this.rawDescription = new ArrayList<String>(0);
        this.dependencies = new ArrayList<QuestObject>(0);
        this.tasks = new ArrayList<Task>(1);
        this.rewards = new ArrayList<Reward>(1);
        this.guidePage = "";
        this.hideDependencyLines = Tristate.DEFAULT;
        this.hideDependentLines = false;
        this.hideUntilDepsVisible = Tristate.DEFAULT;
        this.dependencyRequirement = DependencyRequirement.ALL_COMPLETED;
        this.minRequiredDependencies = 0;
        this.hideTextUntilComplete = Tristate.DEFAULT;
        this.disableJEI = Tristate.DEFAULT;
        this.hideDetailsUntilStartable = Tristate.DEFAULT;
        this.size = 0.0;
        this.optional = false;
        this.minWidth = 0;
        this.canRepeat = Tristate.DEFAULT;
        this.invisible = false;
        this.invisibleUntilTasks = 0;
        this.ignoreRewardBlocking = false;
        this.progressionMode = ProgressionMode.DEFAULT;
        this.dependantIDs = new HashSet<Long>();
        this.requireSequentialTasks = Tristate.DEFAULT;
        this.iconScale = 1.0;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public BaseQuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this.chapter;
    }

    @Override
    public long getParentID() {
        return this.chapter.id;
    }

    public Collection<Task> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public List<Task> getTasksAsList() {
        return Collections.unmodifiableList(this.tasks);
    }

    public Collection<Reward> getRewards() {
        return Collections.unmodifiableList(this.rewards);
    }

    public int getMinRequiredDependencies() {
        return this.minRequiredDependencies;
    }

    public boolean shouldHideDependentLines() {
        return this.hideDependentLines;
    }

    public String getGuidePage() {
        return this.guidePage;
    }

    public Tristate getHideTextUntilComplete() {
        return this.hideTextUntilComplete;
    }

    public boolean showInRecipeMod() {
        return this.disableJEI.get(!this.getQuestFile().isDefaultQuestDisableJEI());
    }

    public String getRawSubtitle() {
        return this.rawSubtitle;
    }

    public void setRawSubtitle(String rawSubtitle) {
        this.rawSubtitle = rawSubtitle;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getSize() {
        return this.size == 0.0 ? this.chapter.getDefaultQuestSize() : this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public boolean canBeRepeated() {
        return this.canRepeat.get(this.chapter.isDefaultRepeatable());
    }

    public List<String> getRawDescription() {
        return this.rawDescription;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    @Override
    public boolean isOptionalForProgression() {
        return this.isOptional();
    }

    public boolean getRequireSequentialTasks() {
        return this.requireSequentialTasks.get(this.chapter.isRequireSequentialTasks());
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10549("x", this.x);
        nbt.method_10549("y", this.y);
        if (!this.shape.isEmpty()) {
            nbt.method_10582("shape", this.shape);
        }
        if (!this.rawSubtitle.isEmpty()) {
            nbt.method_10582("subtitle", this.rawSubtitle);
        }
        if (!this.rawDescription.isEmpty()) {
            class_2499 array = new class_2499();
            for (String value : this.rawDescription) {
                array.add((Object)class_2519.method_23256((String)value));
            }
            nbt.method_10566("description", (class_2520)array);
        }
        if (!this.guidePage.isEmpty()) {
            nbt.method_10582("guide_page", this.guidePage);
        }
        this.hideDependencyLines.write(nbt, "hide_dependency_lines");
        if (this.hideDependentLines) {
            nbt.method_10556("hide_dependent_lines", true);
        }
        if (this.minRequiredDependencies > 0) {
            nbt.method_10569("min_required_dependencies", (int)((byte)this.minRequiredDependencies));
        }
        this.removeInvalidDependencies();
        if (this.hasDependencies()) {
            class_2499 deps = new class_2499();
            for (QuestObject dep : this.dependencies) {
                deps.add((Object)class_2519.method_23256((String)dep.getCodeString()));
            }
            nbt.method_10566("dependencies", (class_2520)deps);
        }
        this.hideUntilDepsVisible.write(nbt, "hide");
        if (this.dependencyRequirement != DependencyRequirement.ALL_COMPLETED) {
            nbt.method_10582("dependency_requirement", this.dependencyRequirement.getId());
        }
        this.hideTextUntilComplete.write(nbt, "hide_text_until_complete");
        if (this.size != 0.0) {
            nbt.method_10549("size", this.size);
        }
        if (this.iconScale != 1.0) {
            nbt.method_10549("icon_scale", this.iconScale);
        }
        if (this.optional) {
            nbt.method_10556("optional", true);
        }
        if (this.minWidth > 0) {
            nbt.method_10569("min_width", this.minWidth);
        }
        this.canRepeat.write(nbt, "can_repeat");
        if (this.invisible) {
            nbt.method_10556("invisible", true);
        }
        if (this.invisibleUntilTasks > 0) {
            nbt.method_10569("invisible_until_tasks", this.invisibleUntilTasks);
        }
        if (this.ignoreRewardBlocking) {
            nbt.method_10556("ignore_reward_blocking", true);
        }
        if (this.progressionMode != ProgressionMode.DEFAULT) {
            nbt.method_10582("progression_mode", this.progressionMode.getId());
        }
        this.hideDetailsUntilStartable.write(nbt, "hide_details_until_startable");
        this.requireSequentialTasks.write(nbt, "require_sequential_tasks");
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.rawSubtitle = nbt.method_10558("subtitle");
        this.x = nbt.method_10574("x");
        this.y = nbt.method_10574("y");
        this.shape = nbt.method_10558("shape");
        if (this.shape.equals("default")) {
            this.shape = "";
        }
        this.rawDescription.clear();
        class_2499 list = nbt.method_10554("description", 8);
        for (int k = 0; k < list.size(); ++k) {
            this.rawDescription.add(list.method_10608(k));
        }
        this.guidePage = nbt.method_10558("guide_page");
        this.hideDependencyLines = Tristate.read((class_2487)nbt, (String)"hide_dependency_lines");
        this.hideDependentLines = nbt.method_10577("hide_dependent_lines");
        this.minRequiredDependencies = nbt.method_10550("min_required_dependencies");
        this.clearDependencies();
        if (nbt.method_10573("dependencies", 11)) {
            for (int i : nbt.method_10561("dependencies")) {
                QuestObject object = this.chapter.file.get(i);
                if (object == null) continue;
                this.addDependency(object);
            }
        } else {
            class_2499 deps = nbt.method_10554("dependencies", 8);
            for (int i = 0; i < deps.size(); ++i) {
                QuestObject object = this.chapter.file.get(this.chapter.file.getID(deps.method_10608(i)));
                if (object == null) continue;
                this.addDependency(object);
            }
        }
        this.hideUntilDepsVisible = Tristate.read((class_2487)nbt, (String)"hide");
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.get(nbt.method_10558("dependency_requirement")));
        this.hideTextUntilComplete = Tristate.read((class_2487)nbt, (String)"hide_text_until_complete");
        this.size = nbt.method_10574("size");
        this.iconScale = nbt.method_10573("icon_scale", 6) ? nbt.method_10574("icon_scale") : 1.0;
        this.optional = nbt.method_10577("optional");
        this.minWidth = nbt.method_10550("min_width");
        this.canRepeat = Tristate.read((class_2487)nbt, (String)"can_repeat");
        this.invisible = nbt.method_10577("invisible");
        this.invisibleUntilTasks = nbt.method_10550("invisible_until_tasks");
        this.ignoreRewardBlocking = nbt.method_10577("ignore_reward_blocking");
        this.progressionMode = (ProgressionMode)((Object)ProgressionMode.NAME_MAP.get(nbt.method_10558("progression_mode")));
        this.hideDetailsUntilStartable = Tristate.read((class_2487)nbt, (String)"hide_details_until_startable");
        this.requireSequentialTasks = Tristate.read((class_2487)nbt, (String)"require_sequential_tasks");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.rawSubtitle.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.rawDescription.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.size != 0.0 ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (!this.guidePage.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (boolean)this.ignoreRewardBlocking);
        flags = Bits.setFlag((int)flags, (int)32, (boolean)this.hideDependentLines);
        flags = Bits.setFlag((int)flags, (int)128, (boolean)this.invisible);
        flags = Bits.setFlag((int)flags, (int)256, (boolean)this.optional);
        flags = Bits.setFlag((int)flags, (int)512, (this.minWidth > 0 ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)1024, (this.invisibleUntilTasks > 0 ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2048, (this.hideDetailsUntilStartable != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4096, (this.hideDetailsUntilStartable == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8192, (this.canRepeat != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16384, (this.canRepeat == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32768, (this.requireSequentialTasks != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)65536, (this.requireSequentialTasks == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)131072, (this.iconScale != 1.0 ? 1 : 0) != 0);
        buffer.method_10804(flags);
        this.hideUntilDepsVisible.write(buffer);
        this.hideDependencyLines.write(buffer);
        this.hideTextUntilComplete.write(buffer);
        if (!this.rawSubtitle.isEmpty()) {
            buffer.method_10788(this.rawSubtitle, Short.MAX_VALUE);
        }
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.method_10788(this.shape, Short.MAX_VALUE);
        if (!this.rawDescription.isEmpty()) {
            NetUtils.writeStrings(buffer, this.rawDescription);
        }
        if (!this.guidePage.isEmpty()) {
            buffer.method_10788(this.guidePage, Short.MAX_VALUE);
        }
        buffer.method_10804(this.minRequiredDependencies);
        DependencyRequirement.NAME_MAP.write(buffer, (Object)this.dependencyRequirement);
        buffer.method_10804(this.dependencies.size());
        for (QuestObject d : this.dependencies) {
            buffer.writeLong(d.invalid ? 0L : d.id);
        }
        if (this.size != 0.0) {
            buffer.writeDouble(this.size);
        }
        if (this.iconScale != 1.0) {
            buffer.writeDouble(this.iconScale);
        }
        if (this.minWidth > 0) {
            buffer.method_10804(this.minWidth);
        }
        if (this.invisibleUntilTasks > 0) {
            buffer.method_10804(this.invisibleUntilTasks);
        }
        ProgressionMode.NAME_MAP.write(buffer, (Object)this.progressionMode);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        int flags = buffer.method_10816();
        this.hideUntilDepsVisible = Tristate.read((class_2540)buffer);
        this.hideDependencyLines = Tristate.read((class_2540)buffer);
        this.hideTextUntilComplete = Tristate.read((class_2540)buffer);
        this.rawSubtitle = Bits.getFlag((int)flags, (int)1) ? buffer.method_10800(Short.MAX_VALUE) : "";
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.shape = buffer.method_10800(Short.MAX_VALUE);
        if (Bits.getFlag((int)flags, (int)2)) {
            NetUtils.readStrings(buffer, this.rawDescription);
        } else {
            this.rawDescription.clear();
        }
        this.guidePage = Bits.getFlag((int)flags, (int)8) ? buffer.method_10800(Short.MAX_VALUE) : "";
        this.minRequiredDependencies = buffer.method_10816();
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.read(buffer));
        this.clearDependencies();
        int d = buffer.method_10816();
        for (int i = 0; i < d; ++i) {
            QuestObject object = this.chapter.file.get(buffer.readLong());
            if (object == null) continue;
            this.addDependency(object);
        }
        this.size = Bits.getFlag((int)flags, (int)4) ? buffer.readDouble() : 0.0;
        this.iconScale = Bits.getFlag((int)flags, (int)131072) ? buffer.readDouble() : 1.0;
        this.minWidth = Bits.getFlag((int)flags, (int)512) ? buffer.method_10816() : 0;
        this.ignoreRewardBlocking = Bits.getFlag((int)flags, (int)16);
        this.hideDependentLines = Bits.getFlag((int)flags, (int)32);
        this.canRepeat = Bits.getFlag((int)flags, (int)8192) ? (Bits.getFlag((int)flags, (int)16384) ? Tristate.TRUE : Tristate.FALSE) : Tristate.DEFAULT;
        this.invisible = Bits.getFlag((int)flags, (int)128);
        this.optional = Bits.getFlag((int)flags, (int)256);
        int n = this.invisibleUntilTasks = Bits.getFlag((int)flags, (int)1024) ? buffer.method_10816() : 0;
        Tristate tristate = Bits.getFlag((int)flags, (int)2048) ? (Bits.getFlag((int)flags, (int)4096) ? Tristate.TRUE : Tristate.FALSE) : (this.hideDetailsUntilStartable = Tristate.DEFAULT);
        this.requireSequentialTasks = Bits.getFlag((int)flags, (int)32768) ? (Bits.getFlag((int)flags, (int)65536) ? Tristate.TRUE : Tristate.FALSE) : Tristate.DEFAULT;
        this.progressionMode = (ProgressionMode)((Object)ProgressionMode.NAME_MAP.read(buffer));
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        if (this.tasks.isEmpty()) {
            return data.areDependenciesComplete(this) ? 100 : 0;
        }
        int progress = 0;
        for (Task task : this.tasks) {
            progress += data.getRelativeProgress(task);
        }
        if (progress > 0 && !data.areDependenciesComplete(this)) {
            return 0;
        }
        return Quest.getRelativeProgressFromChildren(progress, this.tasks.size());
    }

    @Override
    public void onStarted(QuestProgressEventData<?> data) {
        data.setStarted(this.id);
        ((EventActor)ObjectStartedEvent.QUEST.invoker()).act((Object)new ObjectStartedEvent.QuestEvent(data.withObject(this)));
        if (!data.getTeamData().isStarted(this.chapter)) {
            this.chapter.onStarted(data.withObject(this.chapter));
        }
    }

    @Override
    public void onCompleted(QuestProgressEventData<?> data) {
        data.setCompleted(this.id);
        ((EventActor)ObjectCompletedEvent.QUEST.invoker()).act((Object)new ObjectCompletedEvent.QuestEvent(data.withObject(this)));
        if (!this.disableToast) {
            data.notifyPlayers(this.id);
        }
        if (this.chapter.isCompletedRaw(data.getTeamData())) {
            this.chapter.onCompleted(data.withObject(this.chapter));
        }
        data.getTeamData().checkAutoCompletion(this);
        this.checkForDependantCompletion(data.getTeamData());
    }

    private void checkForDependantCompletion(TeamData data) {
        this.getDependants().forEach(questObject -> {
            if (questObject instanceof Quest) {
                Quest quest = (Quest)questObject;
                if (quest.getProgressionMode() == ProgressionMode.FLEXIBLE) {
                    if (quest.streamDependencies().allMatch(data::isCompleted)) {
                        quest.tasks.forEach(task -> {
                            if (data.getProgress(task.id) >= task.getMaxProgress()) {
                                data.markTaskCompleted((Task)task);
                            }
                        });
                    }
                }
                data.checkAutoCompletion(quest);
            }
        });
    }

    public ProgressionMode getProgressionMode() {
        return this.progressionMode == ProgressionMode.DEFAULT ? this.chapter.getProgressionMode() : this.progressionMode;
    }

    @Override
    public void forceProgress(TeamData teamData, ProgressChange progressChange) {
        super.forceProgress(teamData, progressChange);
        for (Reward r : this.rewards) {
            r.forceProgress(teamData, progressChange);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        if (!this.tasks.isEmpty()) {
            return this.tasks.get(0).getTitle();
        }
        return class_2561.method_43471((String)"ftbquests.unnamed");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Task task : this.tasks) {
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.removeQuest(this);
        ArrayList linksToDel = new ArrayList();
        this.getQuestFile().forAllQuestLinks(l -> {
            if (l.linksTo(this)) {
                linksToDel.add(l);
            }
        });
        linksToDel.forEach(l -> this.getQuestFile().deleteObject(l.id));
    }

    @Override
    public void deleteChildren() {
        for (Task task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        for (Reward reward : this.rewards) {
            reward.deleteChildren();
            reward.invalid = true;
        }
        this.tasks.clear();
        this.rewards.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.addQuest(this);
        if (!this.tasks.isEmpty()) {
            ArrayList<Task> l = new ArrayList<Task>(this.tasks);
            this.tasks.clear();
            for (Task task : l) {
                task.onCreated();
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("subtitle", this.rawSubtitle, v -> {
            this.rawSubtitle = v;
        }, "");
        StringConfig descType = new StringConfig();
        config.add("description", (ConfigValue)new ListConfig<String, StringConfig>(descType){

            public void onClicked(Widget clicked, MouseButton button, ConfigCallback callback) {
                new MultilineTextEditorScreen((class_2561)class_2561.method_43471((String)"ftbquests.gui.edit_description"), this, callback).openGui();
            }
        }, this.rawDescription, t -> {
            this.rawDescription.clear();
            this.rawDescription.addAll((Collection<String>)t);
        }, Collections.emptyList());
        ConfigGroup appearance = config.getOrCreateSubgroup("appearance");
        appearance.addEnum("shape", (Object)(this.shape.isEmpty() ? "default" : this.shape), v -> {
            this.shape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        appearance.addDouble("size", this.size, v -> {
            this.size = v;
        }, 0.0, 0.0, 8.0);
        appearance.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        appearance.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        appearance.addInt("min_width", this.minWidth, v -> {
            this.minWidth = v;
        }, 0, 0, 3000);
        appearance.addDouble("icon_scale", this.iconScale, v -> {
            this.iconScale = v;
        }, 1.0, 0.1, 2.0);
        ConfigGroup visibility = config.getOrCreateSubgroup("visibility");
        visibility.addTristate("hide", this.hideUntilDepsVisible, v -> {
            this.hideUntilDepsVisible = v;
        });
        visibility.addBool("invisible", this.invisible, v -> {
            this.invisible = v;
        }, false);
        visibility.addInt("invisible_until_tasks", this.invisibleUntilTasks, v -> {
            this.invisibleUntilTasks = v;
        }, 0, 0, Integer.MAX_VALUE).setCanEdit(this.invisible);
        visibility.addTristate("hide_details_until_startable", this.hideDetailsUntilStartable, v -> {
            this.hideDetailsUntilStartable = v;
        });
        visibility.addTristate("hide_text_until_complete", this.hideTextUntilComplete, v -> {
            this.hideTextUntilComplete = v;
        });
        Predicate<QuestObjectBase> depTypes = object -> object != this.chapter.file && object != this.chapter && object instanceof QuestObject;
        this.removeInvalidDependencies();
        ConfigGroup deps = config.getOrCreateSubgroup("dependencies");
        deps.addList("dependencies", this.dependencies, new ConfigQuestObject(depTypes), null).setNameKey("ftbquests.dependencies");
        deps.addEnum("dependency_requirement", (Object)this.dependencyRequirement, v -> {
            this.dependencyRequirement = v;
        }, DependencyRequirement.NAME_MAP);
        deps.addInt("min_required_dependencies", this.minRequiredDependencies, v -> {
            this.minRequiredDependencies = v;
        }, 0, 0, Integer.MAX_VALUE);
        deps.addTristate("hide_dependency_lines", this.hideDependencyLines, v -> {
            this.hideDependencyLines = v;
        });
        deps.addBool("hide_dependent_lines", this.hideDependentLines, v -> {
            this.hideDependentLines = v;
        }, false);
        ConfigGroup misc = config.getOrCreateSubgroup("misc");
        misc.addString("guide_page", this.guidePage, v -> {
            this.guidePage = v;
        }, "");
        misc.addEnum("disable_jei", (Object)this.disableJEI, v -> {
            this.disableJEI = v;
        }, Tristate.NAME_MAP);
        misc.addTristate("can_repeat", this.canRepeat, v -> {
            this.canRepeat = v;
        });
        misc.addBool("optional", this.optional, v -> {
            this.optional = v;
        }, false);
        misc.addBool("ignore_reward_blocking", this.ignoreRewardBlocking, v -> {
            this.ignoreRewardBlocking = v;
        }, false);
        misc.addEnum("progression_mode", (Object)this.progressionMode, v -> {
            this.progressionMode = v;
        }, ProgressionMode.NAME_MAP);
        misc.addTristate("require_sequential_tasks", this.requireSequentialTasks, v -> {
            this.requireSequentialTasks = v;
        });
    }

    public boolean shouldHideDependencyLines() {
        return this.hideDependencyLines.get(this.chapter.defaultHideDependencyLines);
    }

    @Override
    public long getMovableID() {
        return this.id;
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.getSize();
    }

    @Override
    public double getHeight() {
        return this.getSize();
    }

    @Override
    public String getShape() {
        return this.shape.isEmpty() ? this.chapter.getDefaultQuestShape() : this.shape;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void move(Chapter to, double x, double y) {
        new MoveMovableMessage(this, to.id, x, y).sendToServer();
    }

    @Override
    public boolean isVisible(TeamData data) {
        block5: {
            block6: {
                if (!this.invisible || data.isCompleted(this)) break block5;
                if (this.invisibleUntilTasks == 0) break block6;
                if (this.tasks.stream().filter(data::isCompleted).limit(this.invisibleUntilTasks).count() >= (long)this.invisibleUntilTasks) break block5;
            }
            return false;
        }
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (this.hideUntilDepsVisible.get(this.chapter.hideQuestUntilDepsVisible())) {
            return data.areDependenciesComplete(this);
        }
        return this.streamDependencies().anyMatch(object -> object.isVisible(data));
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedSubtitle = null;
        this.cachedDescription = null;
        for (Task task : this.tasks) {
            task.clearCachedData();
        }
        for (Reward reward : this.rewards) {
            reward.clearCachedData();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 getSubtitle() {
        if (this.cachedSubtitle == null) {
            this.cachedSubtitle = TextUtils.parseRawText(this.rawSubtitle);
        }
        return this.cachedSubtitle;
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getDescription() {
        if (this.cachedDescription == null) {
            this.cachedDescription = this.rawDescription.stream().map(TextUtils::parseRawText).toList();
        }
        return this.cachedDescription;
    }

    public boolean hasDependency(QuestObject object) {
        if (object.invalid) {
            return false;
        }
        for (QuestObject dependency : this.dependencies) {
            if (dependency != object) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean validateEditedConfig() {
        try {
            this.verifyDependenciesInternal(this.id, 0);
            return true;
        }
        catch (DependencyDepthException | DependencyLoopException ex) {
            this.clearDependencies();
            if (!this.getQuestFile().isServerSide()) {
                QuestScreen.displayError((class_2561)class_2561.method_43471((String)"ftbquests.gui.looping_dependencies"));
            }
            return false;
        }
    }

    public boolean verifyDependencies(boolean autofix) {
        try {
            this.verifyDependenciesInternal(this.id, 0);
            return true;
        }
        catch (DependencyDepthException ex) {
            if (autofix) {
                FTBQuests.LOGGER.error("Too deep dependencies found in " + this + " (referenced in " + ex.object + ")! Deleting all dependencies...");
                this.clearDependencies();
                this.chapter.file.markDirty();
            } else {
                FTBQuests.LOGGER.error("Too deep dependencies found in " + this + " (referenced in " + ex.object + ")!");
            }
            return false;
        }
        catch (DependencyLoopException ex) {
            if (autofix) {
                FTBQuests.LOGGER.error("Looping dependencies found in " + this + " (referenced in " + ex.object + ")! Deleting all dependencies...");
                this.clearDependencies();
                this.chapter.file.markDirty();
            } else {
                FTBQuests.LOGGER.error("Looping dependencies found in " + this + " (referenced in " + ex.object + ")!");
            }
            return false;
        }
    }

    @Override
    protected void verifyDependenciesInternal(long original, int depth) {
        this._verify(original, (LongSet)new LongOpenHashSet(), 0);
    }

    private void _verify(long original, LongSet visited, int depth) {
        if (visited.add(this.id)) {
            if (depth >= 1000) {
                throw new DependencyDepthException(this);
            }
            for (QuestObject dependency : this.dependencies) {
                if (dependency.id == original) {
                    throw new DependencyLoopException(this);
                }
                if (!(dependency instanceof Quest)) continue;
                Quest q = (Quest)dependency;
                q._verify(original, visited, depth + 1);
            }
        }
    }

    @Override
    public Set<RecipeModHelper.Components> componentsToRefresh() {
        return EnumSet.of(RecipeModHelper.Components.QUESTS);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.refreshQuestPanel();
            gui.refreshViewQuestPanel();
        }
    }

    @Override
    public void onMoved(double newX, double newY, long newChapterId) {
        Chapter newChapter;
        this.x = newX;
        this.y = newY;
        if (newChapterId != this.chapter.id && (newChapter = this.getQuestFile().getChapter(newChapterId)) != null) {
            this.chapter.removeQuest(this);
            newChapter.addQuest(this);
            this.chapter = newChapter;
        }
    }

    @Override
    public void copyToClipboard() {
        FTBQuestsClient.copyToClipboard(this);
    }

    public boolean isProgressionIgnored() {
        return this.canBeRepeated() || this.optional;
    }

    public Collection<QuestObject> getDependants() {
        return this.dependantIDs.stream().map(id -> this.getQuestFile().get((long)id)).filter(q -> q != null && !q.invalid).toList();
    }

    public void checkRepeatable(TeamData data, UUID player) {
        if (this.canBeRepeated() && this.rewards.stream().allMatch(r -> data.isRewardClaimed(player, (Reward)r))) {
            this.forceProgress(data, new ProgressChange(data.getFile(), this, player));
        }
    }

    @Override
    public Collection<? extends QuestObject> getChildren() {
        return this.tasks;
    }

    @Override
    public boolean isCompletedRaw(TeamData data) {
        return data.canStartTasks(this) && super.isCompletedRaw(data);
    }

    @Override
    public boolean hasUnclaimedRewardsRaw(TeamData teamData, UUID player) {
        if (teamData.isCompleted(this)) {
            for (Reward reward : this.rewards) {
                if (teamData.isRewardBlocked(reward) || teamData.getClaimType(player, reward) != RewardClaimType.CAN_CLAIM) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ignoreRewardBlocking() {
        return this.ignoreRewardBlocking;
    }

    public void writeTasks(class_2487 tag) {
        class_2499 t = new class_2499();
        for (Task task : this.tasks) {
            TaskType type = task.getType();
            SNBTCompoundTag nbt3 = new SNBTCompoundTag();
            nbt3.method_10582("id", task.getCodeString());
            nbt3.method_10582("type", type.getTypeForNBT());
            task.writeData((class_2487)nbt3);
            t.add((Object)nbt3);
        }
        tag.method_10566("tasks", (class_2520)t);
    }

    public void writeRewards(class_2487 tag) {
        class_2499 r = new class_2499();
        for (Reward reward : this.rewards) {
            RewardType type = reward.getType();
            SNBTCompoundTag nbt3 = new SNBTCompoundTag();
            nbt3.method_10582("id", reward.getCodeString());
            nbt3.method_10582("type", type.getTypeForNBT());
            reward.writeData((class_2487)nbt3);
            r.add((Object)nbt3);
        }
        tag.method_10566("rewards", (class_2520)r);
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    public Stream<QuestObject> streamDependencies() {
        return this.dependencies.stream();
    }

    public void addDependency(QuestObject object) {
        this.dependencies.add(object);
        if (object instanceof Quest) {
            Quest q = (Quest)object;
            q.addDependant(this.id);
        }
    }

    public void removeDependency(QuestObject object) {
        this.dependencies.remove(object);
        if (object instanceof Quest) {
            Quest q = (Quest)object;
            q.removeDependant(this.id);
        }
    }

    public void removeInvalidDependencies() {
        Iterator<QuestObject> iter = this.dependencies.iterator();
        while (iter.hasNext()) {
            QuestObject qo = iter.next();
            if (qo != null && !qo.invalid && qo != this) continue;
            iter.remove();
            if (!(qo instanceof Quest)) continue;
            Quest q = (Quest)qo;
            q.removeDependant(this.id);
        }
    }

    public void clearDependencies() {
        this.dependencies.forEach(qo -> {
            if (qo instanceof Quest) {
                Quest q = (Quest)qo;
                q.removeDependant(this.id);
            }
        });
        this.dependencies.clear();
    }

    private void addDependant(long id) {
        this.dependantIDs.add(id);
    }

    private void removeDependant(long id) {
        this.dependantIDs.remove(id);
    }

    public boolean allTasksCompleted(TeamData teamData) {
        return this.tasks.stream().allMatch(task -> teamData.getProgress((Task)task) >= task.getMaxProgress());
    }

    public boolean hideDetailsUntilStartable() {
        return this.hideDetailsUntilStartable.get(this.chapter.hideQuestDetailsUntilStartable());
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public void removeTask(Task task) {
        this.tasks.remove(task);
    }

    public void addReward(Reward reward) {
        this.rewards.add(reward);
    }

    public void removeReward(Reward reward) {
        this.rewards.remove(reward);
    }

    public boolean areDependenciesComplete(TeamData teamData) {
        if (this.minRequiredDependencies > 0) {
            return this.streamDependencies().filter(dep -> teamData.isCompleted((QuestObject)dep) && !dep.invalid).limit(this.minRequiredDependencies).count() == (long)this.minRequiredDependencies;
        }
        if (this.dependencyRequirement.needOnlyOne()) {
            return this.streamDependencies().anyMatch(dep -> !dep.invalid && (this.dependencyRequirement.needCompletion() ? teamData.isCompleted((QuestObject)dep) : teamData.isStarted((QuestObject)dep)));
        }
        return this.streamDependencies().allMatch(dep -> !dep.invalid && (this.dependencyRequirement.needCompletion() ? teamData.isCompleted((QuestObject)dep) : teamData.isStarted((QuestObject)dep)));
    }

    public List<Pair<Integer, Integer>> buildDescriptionIndex() {
        int l1;
        ArrayList<Pair<Integer, Integer>> index = new ArrayList<Pair<Integer, Integer>>();
        for (int l2 = l1 = 0; l2 < this.rawDescription.size(); ++l2) {
            if (!this.rawDescription.get(l2).equals(PAGEBREAK_CODE)) continue;
            index.add((Pair<Integer, Integer>)Pair.of((Object)l1, (Object)(l2 - 1)));
            l1 = l2 + 1;
        }
        if (l1 < this.rawDescription.size()) {
            index.add((Pair<Integer, Integer>)Pair.of((Object)l1, (Object)(this.rawDescription.size() - 1)));
        }
        return index;
    }
}

