/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.GuiProviders;
import dev.ftb.mods.ftbquests.client.QuestFileCacheReloader;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.net.SetCustomImageMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3675;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7706;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClient {
    public static class_304 KEY_QUESTS;

    public static void init() {
        FTBQuestsClientConfig.init();
        ClientLifecycleEvent.CLIENT_SETUP.register(FTBQuestsClient::onClientSetup);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new QuestFileCacheReloader());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new ThemeLoader());
        KEY_QUESTS = new class_304("key.ftbquests.quests", class_3675.class_307.field_1668, -1, "key.categories.ftbquests");
        KeyMappingRegistry.register((class_304)KEY_QUESTS);
        new FTBQuestsClientEventHandler().init();
    }

    private static void onClientSetup(class_310 minecraft) {
        RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.BARRIER.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.STAGE_BARRIER.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.TASK_SCREEN_1.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.TASK_SCREEN_3.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.TASK_SCREEN_5.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.TASK_SCREEN_7.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23577(), (class_2248[])new class_2248[]{(class_2248)FTBQuestsBlocks.AUX_SCREEN.get()});
        GuiProviders.setTaskGuiProviders();
        GuiProviders.setRewardGuiProviders();
    }

    @Nullable
    public static BaseQuestFile getClientQuestFile() {
        return ClientQuestFile.INSTANCE;
    }

    public static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    public static class_1937 getClientLevel() {
        return class_310.method_1551().field_1687;
    }

    public static boolean isClientDataLoaded() {
        return ClientQuestFile.exists();
    }

    public static TeamData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.selfTeamData;
    }

    public static BaseQuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }

    public static void openGui() {
        ClientQuestFile.openGui();
    }

    public static void openCustomIconGui(class_1657 player, class_1268 hand) {
        ImageResourceConfig config = new ImageResourceConfig();
        config.onClicked(null, MouseButton.LEFT, accepted -> {
            if (accepted) {
                if (config.isEmpty()) {
                    player.method_5998(hand).method_7983("Icon");
                } else {
                    player.method_5998(hand).method_7959("Icon", (class_2520)class_2519.method_23256((String)((class_2960)config.getValue()).toString()));
                }
                new SetCustomImageMessage(hand, (class_2960)config.getValue()).sendToServer();
            }
            class_310.method_1551().method_1507(null);
        });
    }

    public static void openScreenConfigGui(class_2338 pos) {
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(pos);
        if (class_25862 instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)class_25862;
            new EditConfigScreen(coreScreen.fillConfigGroup(ClientQuestFile.INSTANCE.getOrCreateTeamData(coreScreen.getTeamId()))).setAutoclose(true).openGui();
        }
    }

    public static float[] getTextureUV(class_2680 state, class_2350 face) {
        if (state == null) {
            return null;
        }
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        List quads = model.method_4707(state, face, class_5819.method_43047());
        if (!quads.isEmpty()) {
            class_1058 sprite = ((class_777)quads.get(0)).method_35788();
            return new float[]{sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575()};
        }
        return new float[0];
    }

    public static void rebuildCreativeTabs() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            FTBQuests.LOGGER.debug("deferring creative tab rebuild, client player still null");
            FTBQuestsClientEventHandler.creativeTabRebuildPending = true;
        } else {
            FTBQuests.LOGGER.debug("rebuilding creative tabs now");
            class_1761.class_8128 params = new class_1761.class_8128(player.field_3944.method_45735(), player.method_7338(), (class_7225.class_7874)player.method_37908().method_30349());
            ((class_1761)FTBQuestsItems.CREATIVE_TAB.get()).method_47306(params);
            class_7706.method_47344().method_47306(params);
        }
    }

    public static Optional<class_5455> registryAccess() {
        return class_310.method_1551().field_1687 == null ? Optional.empty() : Optional.of(class_310.method_1551().field_1687.method_30349());
    }

    public static void copyToClipboard(QuestObjectBase qo) {
        Widget.setClipboardString((String)qo.getCodeString());
    }
}

