/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.command.FTBQuestsCommands;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.DeferredInventoryDetection;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbteams.api.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public enum FTBQuestsEventHandler {
    INSTANCE;

    private List<KillTask> killTasks = null;
    private List<Task> autoSubmitTasks = null;

    void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(this::registerCommands);
        LifecycleEvent.SERVER_STARTED.register(this::serverStarted);
        LifecycleEvent.SERVER_STOPPING.register(this::serverStopped);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(this::worldSaved);
        FTBQuestsBlocks.register();
        FTBQuestsItems.register();
        FTBQuestsBlockEntities.register();
        ClearFileCacheEvent.EVENT.register(this::fileCacheClear);
        TeamEvent.PLAYER_LOGGED_IN.register(this::playerLoggedIn);
        TeamEvent.CREATED.register(this::teamCreated);
        TeamEvent.PLAYER_CHANGED.register(this::playerChangedTeam);
        EntityEvent.LIVING_DEATH.register(this::playerKill);
        TickEvent.PLAYER_POST.register(this::playerTick);
        PlayerEvent.CRAFT_ITEM.register(this::itemCrafted);
        PlayerEvent.SMELT_ITEM.register(this::itemSmelted);
        PlayerEvent.PLAYER_CLONE.register(this::cloned);
        PlayerEvent.CHANGE_DIMENSION.register(this::changedDimension);
        PlayerEvent.OPEN_MENU.register(this::containerOpened);
        TickEvent.SERVER_POST.register(DeferredInventoryDetection::tick);
    }

    private void serverAboutToStart(MinecraftServer server) {
        ServerQuestFile.INSTANCE = new ServerQuestFile(server);
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 selection) {
        FTBQuestsCommands.register(dispatcher);
    }

    private void serverStarted(MinecraftServer server) {
        ServerQuestFile.INSTANCE.load();
    }

    private void serverStopped(MinecraftServer server) {
        ServerQuestFile.INSTANCE.saveNow();
        ServerQuestFile.INSTANCE.unload();
        ServerQuestFile.INSTANCE = null;
    }

    private void worldSaved(class_3218 level) {
        if (ServerQuestFile.INSTANCE != null) {
            ServerQuestFile.INSTANCE.saveNow();
        }
    }

    private void fileCacheClear(BaseQuestFile file) {
        if (file.isServerSide()) {
            this.killTasks = null;
            this.autoSubmitTasks = null;
        }
    }

    private void playerLoggedIn(PlayerLoggedInAfterTeamEvent event) {
        ServerQuestFile.INSTANCE.playerLoggedIn(event);
    }

    private void teamCreated(TeamCreatedEvent event) {
        ServerQuestFile.INSTANCE.teamCreated(event);
    }

    private void playerChangedTeam(PlayerChangedTeamEvent event) {
        ServerQuestFile.INSTANCE.playerChangedTeam(event);
    }

    private EventResult playerKill(class_1309 entity, class_1282 source) {
        class_3222 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222 && !PlayerHooks.isFake((class_1657)(player = (class_3222)class_12972))) {
            if (this.killTasks == null) {
                this.killTasks = ServerQuestFile.INSTANCE.collect(KillTask.class);
            }
            if (this.killTasks.isEmpty()) {
                return EventResult.pass();
            }
            TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((class_1297)player);
            for (KillTask task : this.killTasks) {
                if (data.getProgress(task) >= task.getMaxProgress() || !data.canStartTasks(task.getQuest())) continue;
                task.kill(data, entity);
            }
        }
        return EventResult.pass();
    }

    private void playerTick(class_1657 player) {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (player instanceof class_3222 && file != null && !PlayerHooks.isFake((class_1657)player)) {
            if (this.autoSubmitTasks == null) {
                this.autoSubmitTasks = file.collect(o -> o instanceof Task && ((Task)o).autoSubmitOnPlayerTick() > 0);
            }
            if (this.autoSubmitTasks == null || this.autoSubmitTasks.isEmpty()) {
                return;
            }
            TeamData data = file.getOrCreateTeamData((class_1297)player);
            if (data.isLocked()) {
                return;
            }
            long t = player.method_37908().method_8510();
            file.withPlayerContext((class_3222)player, () -> {
                for (Task task : this.autoSubmitTasks) {
                    long d = task.autoSubmitOnPlayerTick();
                    if (d <= 0L || t % d != 0L || data.isCompleted(task) || !data.canStartTasks(task.getQuest())) continue;
                    task.submitTask(data, (class_3222)player);
                }
            });
        }
    }

    private void itemCrafted(class_1657 player, class_1799 crafted, class_1263 inventory) {
        if (player instanceof class_3222 && !crafted.method_7960()) {
            FTBQuestsInventoryListener.detect((class_3222)player, crafted, 0L);
        }
    }

    private void itemSmelted(class_1657 player, class_1799 smelted) {
        if (player instanceof class_3222 && !smelted.method_7960()) {
            FTBQuestsInventoryListener.detect((class_3222)player, smelted, 0L);
        }
    }

    private void cloned(class_3222 oldPlayer, class_3222 newPlayer, boolean wonGame) {
        newPlayer.field_7498.method_7596((class_1712)new FTBQuestsInventoryListener(newPlayer));
        if (wonGame) {
            return;
        }
        if (PlayerHooks.isFake((class_1657)newPlayer) || newPlayer.method_37908().method_8450().method_8355(class_1928.field_19389)) {
            return;
        }
        for (int i = 0; i < oldPlayer.method_31548().field_7547.size(); ++i) {
            class_1799 stack = (class_1799)oldPlayer.method_31548().field_7547.get(i);
            if (stack.method_7909() != FTBQuestsItems.BOOK.get() || !newPlayer.method_7270(stack)) continue;
            oldPlayer.method_31548().field_7547.set(i, (Object)class_1799.field_8037);
        }
    }

    private void changedDimension(class_3222 player, class_5321<class_1937> oldLevel, class_5321<class_1937> newLevel) {
        if (!PlayerHooks.isFake((class_1657)player)) {
            ServerQuestFile file = ServerQuestFile.INSTANCE;
            TeamData data = file.getOrCreateTeamData((class_1297)player);
            if (data.isLocked()) {
                return;
            }
            file.withPlayerContext(player, () -> {
                for (DimensionTask task : file.collect(DimensionTask.class)) {
                    if (!data.canStartTasks(task.getQuest())) continue;
                    task.submitTask(data, player);
                }
            });
        }
    }

    private void containerOpened(class_1657 player, class_1703 menu) {
        if (player instanceof class_3222 && !PlayerHooks.isFake((class_1657)player) && !(menu instanceof class_1723)) {
            menu.method_7596((class_1712)new FTBQuestsInventoryListener((class_3222)player));
        }
    }
}

