/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class MenuScreenWrapper<T extends class_1703>
extends class_465<T>
implements IScreenWrapper {
    private final BaseScreen wrappedGui;
    private boolean drawSlots = true;
    private final TooltipList tooltipList = new TooltipList();

    public MenuScreenWrapper(BaseScreen g, T c, class_1661 playerInventory, class_2561 title) {
        super(c, playerInventory, title);
        this.wrappedGui = g;
    }

    public MenuScreenWrapper<T> disableSlotDrawing() {
        this.drawSlots = false;
        return this;
    }

    public void method_25426() {
        super.method_25426();
        this.wrappedGui.initGui();
        this.field_2776 = this.wrappedGui.getX();
        this.field_2800 = this.wrappedGui.getY();
        this.field_2792 = this.wrappedGui.width;
        this.field_2779 = this.wrappedGui.height;
    }

    public boolean method_25421() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean method_25402(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        this.wrappedGui.mousePressed(MouseButton.get(button));
        return super.method_25402(x, y, button);
    }

    public boolean method_25406(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.method_25406(x, y, button);
    }

    public boolean method_25401(double x, double y, double scroll) {
        this.wrappedGui.mouseScrolled(scroll);
        return super.method_25401(x, y, scroll);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
        } else if (this.wrappedGui.onClosedByKey(key) && this.method_25422()) {
            this.wrappedGui.closeGui(true);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.method_25400(keyChar, (int)keyChar);
    }

    protected void method_2389(class_332 graphics, float f, int mx, int my) {
        Theme theme = this.wrappedGui.getTheme();
        GuiHelper.setupDrawing();
        this.method_25420(graphics);
        GuiHelper.setupDrawing();
        this.wrappedGui.draw(graphics, theme, this.field_2776, this.field_2800, this.field_2792, this.field_2779);
        if (this.drawSlots) {
            GuiHelper.setupDrawing();
            for (class_1735 slot : this.field_2797.field_7761) {
                theme.drawContainerSlot(graphics, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872, 16, 16);
            }
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)(-this.field_2776), (float)(-this.field_2800), 0.0f);
        GuiHelper.setupDrawing();
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.drawForeground(graphics, theme, this.field_2776, this.field_2800, this.field_2792, this.field_2779);
        this.wrappedGui.addMouseOverText(this.tooltipList);
        if (!this.tooltipList.shouldRender()) {
            this.wrappedGui.getIngredientUnderMouse().ifPresent(underMouse -> {
                class_1799 stack;
                Object ingredient;
                if (underMouse.tooltip() && (ingredient = underMouse.ingredient()) instanceof class_1799 && !(stack = (class_1799)ingredient).method_7960()) {
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416(0.0f, 0.0f, (float)this.tooltipList.zOffsetItemTooltip);
                    graphics.method_51446(theme.getFont(), (class_1799)ingredient, mouseX, mouseY);
                    graphics.method_51448().method_22909();
                }
            });
        } else {
            this.tooltipList.render(graphics, mouseX, Math.max(mouseY, 18), this.wrappedGui.getScreen().method_4486(), this.wrappedGui.getScreen().method_4502(), theme.getFont());
        }
        this.tooltipList.reset();
        if (this.wrappedGui.getContextMenu().isEmpty()) {
            this.method_2380(graphics, mouseX, mouseY);
        }
        graphics.method_51448().method_22909();
    }

    public void method_25420(class_332 graphics) {
        if (this.wrappedGui.drawDefaultBackground(graphics)) {
            super.method_25420(graphics);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public void method_37432() {
        super.method_37432();
        this.wrappedGui.tick();
    }

    @Override
    public BaseScreen getGui() {
        return this.wrappedGui;
    }

    public void method_25432() {
        this.wrappedGui.onClosed();
        super.method_25432();
    }
}

