/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_4802;
import net.minecraft.class_5321;
import net.minecraft.class_5803;

public final class GlareLocateGlowBerriesTask
extends class_4097<GlareEntity> {
    public GlareLocateGlowBerriesTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), class_4141.field_18457, FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), class_4141.field_18457));
    }

    protected boolean shouldRun(class_3218 world, GlareEntity glare) {
        return FriendsAndFoes.getConfig().enableGlareGriefing && !glare.method_5934() && !glare.method_24345() && !glare.method_5765() && glare.method_6118(class_1304.field_6173).method_7960();
    }

    protected void run(class_3218 world, GlareEntity glare, long time) {
        class_2338 glowBerriesPos = this.findNearestGlowBerries(glare);
        if (glowBerriesPos == null) {
            GlareBrain.setLocatingGlowBerriesCooldown(glare, class_4802.method_24505((int)10, (int)10));
            return;
        }
        class_5321 registryKey = glare.method_37908().method_27983();
        glare.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), (Object)class_4208.method_19443((class_5321)registryKey, (class_2338)glowBerriesPos));
    }

    private class_2338 findNearestGlowBerries(GlareEntity glare) {
        int horizontalRange = 16;
        int verticalRange = 8;
        List<class_2338> glowBerries = this.findAllGlowBerriesInRange(glare.method_24515(), horizontalRange, verticalRange, blockPos -> {
            class_2680 blockState = glare.method_37908().method_8320(blockPos);
            return class_5803.method_33618((class_2680)blockState);
        });
        if (glowBerries.isEmpty()) {
            return null;
        }
        return glowBerries.get(glare.method_6051().method_43048(glowBerries.size()));
    }

    private List<class_2338> findAllGlowBerriesInRange(class_2338 glarePos, int horizontalRange, int verticalRange, Predicate<class_2338> condition) {
        ArrayList<class_2338> buttons = new ArrayList<class_2338>();
        for (class_2338 blockPos : class_2338.method_25996((class_2338)glarePos, (int)horizontalRange, (int)verticalRange, (int)horizontalRange)) {
            class_2338.class_2339 possibleGlowBerriesBlockPos = blockPos.method_25503();
            if (!condition.test((class_2338)possibleGlowBerriesBlockPos)) continue;
            buttons.add((class_2338)possibleGlowBerriesBlockPos);
        }
        return buttons;
    }
}

