/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.state;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import me.mgin.graves.Graves;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.state.PlayerState;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;

public class ServerState
extends class_18 {
    public HashMap<UUID, PlayerState> players = new HashMap();

    public static ServerState createFromNbt(class_2487 tag) {
        ServerState serverState = new ServerState();
        class_2487 playersTag = tag.method_10562("players");
        playersTag.method_10541().forEach(key -> {
            PlayerState playerState = new PlayerState();
            playerState.graves = (class_2499)playersTag.method_10562(key).method_10580("graves");
            UUID uuid = UUID.fromString(key);
            serverState.players.put(uuid, playerState);
        });
        return serverState;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2487 playersNbt = new class_2487();
        this.players.forEach((UUID2, playerData) -> {
            class_2487 playerNbt = new class_2487();
            playerNbt.method_10566("graves", (class_2520)playerData.graves);
            playersNbt.method_10566(String.valueOf(UUID2), (class_2520)playerNbt);
        });
        nbt.method_10566("players", (class_2520)playersNbt);
        return nbt;
    }

    public static ServerState getServerState(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        class_26 persistentStateManager = Objects.requireNonNull(server.method_3847(class_1937.field_25179)).method_17983();
        return (ServerState)persistentStateManager.method_17924(ServerState::createFromNbt, ServerState::new, Graves.MOD_ID);
    }

    public static PlayerState getPlayerState(MinecraftServer server, UUID uuid) {
        ServerState serverState = ServerState.getServerState(server);
        PlayerState playerState = serverState.players.computeIfAbsent(uuid, id -> new PlayerState());
        return playerState;
    }

    public static void storePlayerGrave(class_1657 player, GraveBlockEntity graveEntity) {
        if (graveEntity == null || player == null) {
            return;
        }
        MinecraftServer server = Objects.requireNonNull(graveEntity.method_10997()).method_8503();
        PlayerState playerState = ServerState.getPlayerState(server, player.method_5667());
        if (GravesConfig.getConfig().server.storedGravesAmount == 0) {
            ServerState.cleanupPlayerGraves(playerState);
            return;
        }
        class_2487 graveNbt = graveEntity.toNbt();
        class_2338 gravePos = graveEntity.method_11016();
        graveNbt.method_10569("x", gravePos.method_10263());
        graveNbt.method_10569("y", gravePos.method_10264());
        graveNbt.method_10569("z", gravePos.method_10260());
        graveNbt.method_10582("dimension", String.valueOf(graveEntity.method_10997().method_44013().method_29177()));
        playerState.graves.add((Object)graveNbt);
        ServerState.cleanupPlayerGraves(playerState);
        ServerState.getServerState(server).method_80();
    }

    private static void cleanupPlayerGraves(PlayerState playerState) {
        GravesConfig config = GravesConfig.getConfig();
        int storedGravesAmount = config.server.storedGravesAmount;
        int amountOfStoredGraves = playerState.graves.size();
        int difference = amountOfStoredGraves - storedGravesAmount;
        if (difference > 0) {
            playerState.graves.subList(0, difference).clear();
        }
    }
}

