/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.gametest.tests;

import me.mgin.graves.block.utility.PlaceGrave;
import me.mgin.graves.block.utility.RetrieveGrave;
import me.mgin.graves.gametest.GraveTestHelper;
import me.mgin.graves.gametest.GraveTestNBTHelper;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4516;
import net.minecraft.class_5321;

public class RetrieveGraveTest {
    public static void basicRetrieval(class_4516 context, class_1657 player, class_2338 pos) {
        String fullInventory = "[{Slot: 0b, id: \"minecraft:red_sand\", Count: 64b}, {Slot: 1b, id: \"minecraft:dark_oak_planks\", Count: 64b}, {Slot: 2b, id: \"minecraft:sand\", Count: 64b}, {Slot: 3b, id: \"minecraft:crimson_planks\", Count: 64b}, {Slot: 4b, id: \"minecraft:bedrock\", Count: 64b}, {Slot: 5b, id: \"minecraft:gravel\", Count: 64b}, {Slot: 6b, id: \"minecraft:warped_planks\", Count: 64b}, {Slot: 7b, id: \"minecraft:coal_ore\", Count: 64b}, {Slot: 8b, id: \"minecraft:mangrove_planks\", Count: 64b}, {Slot: 9b, id: \"minecraft:stone\", Count: 64b}, {Slot: 10b, id: \"minecraft:granite\", Count: 64b}, {Slot: 11b, id: \"minecraft:polished_granite\", Count: 64b}, {Slot: 12b, id: \"minecraft:diorite\", Count: 64b}, {Slot: 13b, id: \"minecraft:polished_diorite\", Count: 64b}, {Slot: 14b, id: \"minecraft:andesite\", Count: 64b}, {Slot: 15b, id: \"minecraft:polished_andesite\", Count: 64b}, {Slot: 16b, id: \"minecraft:deepslate\", Count: 64b}, {Slot: 17b, id: \"minecraft:cobbled_deepslate\", Count: 64b}, {Slot: 18b, id: \"minecraft:polished_deepslate\", Count: 64b}, {Slot: 19b, id: \"minecraft:calcite\", Count: 64b}, {Slot: 20b, id: \"minecraft:tuff\", Count: 64b}, {Slot: 21b, id: \"minecraft:dripstone_block\", Count: 64b}, {Slot: 22b, id: \"minecraft:grass_block\", Count: 64b}, {Slot: 23b, id: \"minecraft:dirt\", Count: 64b}, {Slot: 24b, id: \"minecraft:coarse_dirt\", Count: 64b}, {Slot: 25b, id: \"minecraft:podzol\", Count: 64b}, {Slot: 26b, id: \"minecraft:rooted_dirt\", Count: 64b}, {Slot: 27b, id: \"minecraft:mud\", Count: 64b}, {Slot: 28b, id: \"minecraft:crimson_nylium\", Count: 64b}, {Slot: 29b, id: \"minecraft:warped_nylium\", Count: 64b}, {Slot: 30b, id: \"minecraft:cobblestone\", Count: 64b}, {Slot: 31b, id: \"minecraft:oak_planks\", Count: 64b}, {Slot: 32b, id: \"minecraft:spruce_planks\", Count: 64b}, {Slot: 33b, id: \"minecraft:birch_planks\", Count: 64b}, {Slot: 34b, id: \"minecraft:jungle_planks\", Count: 64b}, {Slot: 35b, id: \"minecraft:acacia_planks\", Count: 64b}, {Slot: 100b, id: \"minecraft:diamond_boots\", Count: 1b, tag: {Damage: 0}}, {Slot: 101b, id: \"minecraft:diamond_leggings\", Count: 1b, tag: {Damage: 0}}, {Slot: 102b, id: \"minecraft:diamond_chestplate\", Count: 1b, tag: {Damage: 0}}, {Slot: 103b, id: \"minecraft:diamond_helmet\", Count: 1b, tag: {Damage: 0}}, {Slot: -106b, id: \"minecraft:shield\", Count: 1b, tag: {Damage: 0}}]";
        String partialInventory = "[{Count:64b,Slot:0b,id:\"minecraft:red_sand\"},{Count:64b,Slot:2b,id:\"minecraft:sand\"},{Count:64b,Slot:3b,id:\"minecraft:crimson_planks\"},{Count:64b,Slot:4b,id:\"minecraft:bedrock\"},{Count:64b,Slot:6b,id:\"minecraft:warped_planks\"},{Count:64b,Slot:8b,id:\"minecraft:mangrove_planks\"},{Count:64b,Slot:9b,id:\"minecraft:stone\"},{Count:32b,Slot:11b,id:\"minecraft:polished_granite\"},{Count:64b,Slot:12b,id:\"minecraft:diorite\"},{Count:64b,Slot:13b,id:\"minecraft:cobblestone\"},{Count:64b,Slot:14b,id:\"minecraft:andesite\"},{Count:32b,Slot:15b,id:\"minecraft:polished_andesite\"},{Count:64b,Slot:17b,id:\"minecraft:cobbled_deepslate\"},{Count:32b,Slot:18b,id:\"minecraft:polished_deepslate\"},{Count:64b,Slot:19b,id:\"minecraft:dirt\"},{Count:64b,Slot:20b,id:\"minecraft:tuff\"},{Count:64b,Slot:25b,id:\"minecraft:podzol\"},{Count:64b,Slot:26b,id:\"minecraft:rooted_dirt\"},{Count:64b,Slot:27b,id:\"minecraft:mud\"},{Count:64b,Slot:28b,id:\"minecraft:crimson_nylium\"},{Count:64b,Slot:29b,id:\"minecraft:warped_nylium\"},{Count:64b,Slot:31b,id:\"minecraft:oak_planks\"},{Count:32b,Slot:32b,id:\"minecraft:grass_block\"},{Count:64b,Slot:33b,id:\"minecraft:birch_planks\"},{Count:32b,Slot:35b,id:\"minecraft:acacia_planks\"},{Count:1b,Slot:100b,id:\"minecraft:diamond_boots\",tag:{Damage:0}},{Count:1b,Slot:102b,id:\"minecraft:diamond_chestplate\",tag:{Damage:0}}]";
        String emptyInventory = "[]";
        System.out.println(">> Running basicRetrieval <<");
        context.method_46226(RetrieveGraveTest.checkBasicRetrieval(player, pos, fullInventory), "The inventory didn't match the full inventory SNBT.");
        context.method_46226(RetrieveGraveTest.checkBasicRetrieval(player, pos, partialInventory), "The inventory didn't match the partial inventory SNBT.");
        context.method_46226(RetrieveGraveTest.checkBasicRetrieval(player, pos, emptyInventory), "The inventory didn't match the empty inventory SNBT.");
    }

    public static void mergeRetrieval(class_4516 context, class_1657 player, class_2338 pos) {
        String currentInv = "[{Count:39b,Slot:4b,id:\"minecraft:torch\"},{Count:1b,Slot:5b,id:\"minecraft:shield\",tag:{Damage:4}},{Count:1b,Slot:10b,id:\"minecraft:enchanted_book\",tag:{StoredEnchantments:[{lvl:4s,id:\"minecraft:sharpness\"}]}},{Count:33b,Slot:21b,id:\"minecraft:stick\",tag:{HideFlag:1,Enchantments:[{lvl:1000,id:\"knockback\"}]}},{Count:9b,Slot:23b,id:\"minecraft:stick\"},{Count:1b,Slot:100b,id:\"minecraft:netherite_boots\",tag:{Damage:4}},{Count:1b,Slot:102b,id:\"minecraft:diamond_chestplate\",tag:{Damage:8}},{Count:1b,Slot:103b,id:\"minecraft:iron_helmet\",tag:{Damage:0}},{Count:7b,Slot:-106b,id:\"minecraft:netherite_block\"}]";
        String graveInv = "[{Count:9b,Slot:4b,id:\"minecraft:torch\"},{Count:7b,Slot:9b,id:\"minecraft:stick\"},{Count:1b,Slot:10b,id:\"minecraft:enchanted_book\",tag:{StoredEnchantments:[{lvl:4s,id:\"minecraft:sharpness\"}]}},{Count:1b,Slot:12b,id:\"minecraft:stick\",tag:{HideFlag:1,Enchantments:[{lvl:1000,id:\"knockback\"}]}},{Count:1b,Slot:100b,id:\"minecraft:golden_boots\",tag:{Damage:0}},{Count:1b,Slot:101b,id:\"minecraft:leather_leggings\",tag:{Damage:0}},{Count:1b,Slot:103b,id:\"minecraft:chainmail_helmet\",tag:{Damage:2}},{Count:7b,Slot:-106b,id:\"minecraft:netherite_block\"}]";
        String graveInvMergeResult = "[{Count:1b,Slot:0b,id:\"minecraft:enchanted_book\",tag:{StoredEnchantments:[{id:\"minecraft:sharpness\",lvl:4s}]}},{Count:1b,Slot:1b,id:\"minecraft:netherite_boots\",tag:{Damage:4}},{Count:1b,Slot:2b,id:\"minecraft:iron_helmet\",tag:{Damage:0}},{Count:48b,Slot:4b,id:\"minecraft:torch\"},{Count:1b,Slot:5b,id:\"minecraft:shield\",tag:{Damage:4}},{Count:16b,Slot:9b,id:\"minecraft:stick\"},{Count:1b,Slot:10b,id:\"minecraft:enchanted_book\",tag:{StoredEnchantments:[{id:\"minecraft:sharpness\",lvl:4s}]}},{Count:34b,Slot:12b,id:\"minecraft:stick\",tag:{Enchantments:[{id:\"knockback\",lvl:1000}],HideFlag:1}},{Count:1b,Slot:100b,id:\"minecraft:golden_boots\",tag:{Damage:0}},{Count:1b,Slot:101b,id:\"minecraft:leather_leggings\",tag:{Damage:0}},{Count:1b,Slot:102b,id:\"minecraft:diamond_chestplate\",tag:{Damage:8}},{Count:1b,Slot:103b,id:\"minecraft:chainmail_helmet\",tag:{Damage:2}},{Count:14b,Slot:-106b,id:\"minecraft:netherite_block\"}]";
        String currentInvMergeResult = "[{Count:1b,Slot:0b,id:\"minecraft:enchanted_book\",tag:{StoredEnchantments:[{id:\"minecraft:sharpness\",lvl:4s}]}},{Count:1b,Slot:1b,id:\"minecraft:golden_boots\",tag:{Damage:0}},{Count:1b,Slot:2b,id:\"minecraft:chainmail_helmet\",tag:{Damage:2}},{Count:48b,Slot:4b,id:\"minecraft:torch\"},{Count:1b,Slot:5b,id:\"minecraft:shield\",tag:{Damage:4}},{Count:1b,Slot:10b,id:\"minecraft:enchanted_book\",tag:{StoredEnchantments:[{id:\"minecraft:sharpness\",lvl:4s}]}},{Count:34b,Slot:21b,id:\"minecraft:stick\",tag:{Enchantments:[{id:\"knockback\",lvl:1000}],HideFlag:1}},{Count:16b,Slot:23b,id:\"minecraft:stick\"},{Count:1b,Slot:100b,id:\"minecraft:netherite_boots\",tag:{Damage:4}},{Count:1b,Slot:101b,id:\"minecraft:leather_leggings\",tag:{Damage:0}},{Count:1b,Slot:102b,id:\"minecraft:diamond_chestplate\",tag:{Damage:8}},{Count:1b,Slot:103b,id:\"minecraft:iron_helmet\",tag:{Damage:0}},{Count:14b,Slot:-106b,id:\"minecraft:netherite_block\"}]";
        System.out.println(">> Running mergeRetrieval <<");
        GraveTestHelper.runCommand(context, "graves server config set mergeOrder GRAVE");
        context.method_46226(RetrieveGraveTest.checkMerge(player, pos, currentInv, graveInv, graveInvMergeResult), "The merge algorithm should have merged the current inventory into the grave inventory, but it failed.");
        GraveTestHelper.runCommand(context, "graves server config set mergeOrder CURRENT");
        context.method_46226(RetrieveGraveTest.checkMerge(player, pos, currentInv, graveInv, currentInvMergeResult), "The merge algorithm should have merged the grave inventory into the current inventory, but it failed.");
        GraveTestHelper.runCommand(context, "graves server config reset");
    }

    public static void overflowRetrieval(class_4516 context, class_1657 player, class_2338 pos) {
        String fullInventory = "[{Slot:0b,id:\"minecraft:stone\",Count:64b},{Slot:1b,id:\"minecraft:stone\",Count:64b},{Slot:2b,id:\"minecraft:stone\",Count:64b},{Slot:3b,id:\"minecraft:stone\",Count:64b},{Slot:4b,id:\"minecraft:stone\",Count:64b},{Slot:5b,id:\"minecraft:stone\",Count:64b},{Slot:6b,id:\"minecraft:stone\",Count:64b},{Slot:7b,id:\"minecraft:stone\",Count:64b},{Slot:8b,id:\"minecraft:stone\",Count:64b},{Slot:9b,id:\"minecraft:stone\",Count:64b},{Slot:10b,id:\"minecraft:stone\",Count:64b},{Slot:11b,id:\"minecraft:stone\",Count:64b},{Slot:12b,id:\"minecraft:stone\",Count:64b},{Slot:13b,id:\"minecraft:stone\",Count:64b},{Slot:14b,id:\"minecraft:stone\",Count:64b},{Slot:15b,id:\"minecraft:stone\",Count:64b},{Slot:16b,id:\"minecraft:stone\",Count:64b},{Slot:17b,id:\"minecraft:stone\",Count:64b},{Slot:18b,id:\"minecraft:stone\",Count:64b},{Slot:19b,id:\"minecraft:stone\",Count:64b},{Slot:20b,id:\"minecraft:stone\",Count:64b},{Slot:21b,id:\"minecraft:stone\",Count:64b},{Slot:22b,id:\"minecraft:stone\",Count:64b},{Slot:23b,id:\"minecraft:stone\",Count:64b},{Slot:24b,id:\"minecraft:stone\",Count:64b},{Slot:25b,id:\"minecraft:stone\",Count:64b},{Slot:26b,id:\"minecraft:stone\",Count:64b},{Slot:27b,id:\"minecraft:stone\",Count:64b},{Slot:28b,id:\"minecraft:stone\",Count:64b},{Slot:29b,id:\"minecraft:stone\",Count:64b},{Slot:30b,id:\"minecraft:stone\",Count:64b},{Slot:31b,id:\"minecraft:stone\",Count:64b},{Slot:32b,id:\"minecraft:stone\",Count:64b},{Slot:33b,id:\"minecraft:stone\",Count:64b},{Slot:34b,id:\"minecraft:stone\",Count:64b},{Slot:35b,id:\"minecraft:stone\",Count:64b},{Slot:-106b,id:\"minecraft:grass_block\",Count:48b}]";
        String partialInventory = "[{Slot:0b,id:\"minecraft:sandstone\",Count:64b},{Slot:1b,id:\"minecraft:sandstone\",Count:64b},{Slot:2b,id:\"minecraft:sandstone\",Count:64b},{Slot:3b,id:\"minecraft:sandstone\",Count:64b},{Slot:4b,id:\"minecraft:sandstone\",Count:64b},{Slot:5b,id:\"minecraft:sandstone\",Count:64b},{Slot:6b,id:\"minecraft:sandstone\",Count:64b},{Slot:9b,id:\"minecraft:sandstone\",Count:64b},{Slot:10b,id:\"minecraft:sandstone\",Count:64b},{Slot:11b,id:\"minecraft:sandstone\",Count:64b},{Slot:12b,id:\"minecraft:sandstone\",Count:64b},{Slot:13b,id:\"minecraft:sandstone\",Count:64b},{Slot:14b,id:\"minecraft:sandstone\",Count:64b},{Slot:15b,id:\"minecraft:sandstone\",Count:64b},{Slot:16b,id:\"minecraft:sandstone\",Count:64b},{Slot:17b,id:\"minecraft:sandstone\",Count:64b},{Slot:18b,id:\"minecraft:sandstone\",Count:64b},{Slot:19b,id:\"minecraft:sandstone\",Count:64b},{Slot:20b,id:\"minecraft:sandstone\",Count:64b},{Slot:21b,id:\"minecraft:sandstone\",Count:64b},{Slot:22b,id:\"minecraft:sandstone\",Count:64b},{Slot:23b,id:\"minecraft:sandstone\",Count:64b},{Slot:24b,id:\"minecraft:sandstone\",Count:64b},{Slot:25b,id:\"minecraft:sandstone\",Count:64b},{Slot:26b,id:\"minecraft:sandstone\",Count:64b},{Slot:27b,id:\"minecraft:sandstone\",Count:64b},{Slot:28b,id:\"minecraft:sandstone\",Count:64b},{Slot:29b,id:\"minecraft:sandstone\",Count:64b},{Slot:30b,id:\"minecraft:sandstone\",Count:64b},{Slot:31b,id:\"minecraft:sandstone\",Count:64b},{Slot:32b,id:\"minecraft:sandstone\",Count:64b},{Slot:33b,id:\"minecraft:sandstone\",Count:64b},{Slot:34b,id:\"minecraft:sandstone\",Count:64b},{Slot:35b,id:\"minecraft:sandstone\",Count:64b}]";
        String currentInventory = "[{Slot:0b,id:\"minecraft:grass_block\",Count:64b},{Slot:1b,id:\"minecraft:grass_block\",Count:64b},{Slot:2b,id:\"minecraft:grass_block\",Count:64b},{Slot:3b,id:\"minecraft:grass_block\",Count:64b}]";
        System.out.println(">> Running overflowRetrieval <<");
        GraveTestHelper.runCommand(context, "graves server config set mergeOrder GRAVE");
        RetrieveGraveTest.checkOverflow(context, player, pos, currentInventory, fullInventory, class_1802.field_8270, 240);
        RetrieveGraveTest.checkOverflow(context, player, pos, currentInventory, partialInventory, class_1802.field_8270, 64);
        GraveTestHelper.runCommand(context, "graves server config set mergeOrder CURRENT");
        RetrieveGraveTest.checkOverflow(context, player, pos, currentInventory, partialInventory, class_1802.field_20384, 64);
        GraveTestHelper.runCommand(context, "graves server config reset");
    }

    public static void unloadedModRetrieval(class_4516 context, class_1657 player, class_2338 pos) {
        String backslotSNBT = "{timers:{},trinkets:{Items:[]},CustomName:'{\"text\":\"BackSlot-Full\"}',XP:0,mstime:1681418977105L,x:-52,ItemCount:{trinkets:0,Items:41},y:-30,Items:{Items:[{Slot:0b,id:\"minecraft:bow\",Count:1b,tag:{Damage:0}},{Slot:1b,id:\"minecraft:diamond_sword\",Count:1b,tag:{Damage:0}}]},z:-21,id:\"forgottengraves:grave\",noDecay:0,GraveOwner:{Id:[I;1306594965,790902035,-1235400077,422671094],Name:\"BackSlot-Full\"}}";
        String backslotResult = "[{Count:1b,Slot:0b,id:\"minecraft:bow\",tag:{Damage:0}},{Count:1b,Slot:1b,id:\"minecraft:diamond_sword\",tag:{Damage:0}}]";
        String inventorioSNBT = "{timers:{},trinkets:{Items:[]},inventorio:{Items:[{Slot:27b,id:\"minecraft:flint_and_steel\",Count:1b,tag:{Damage:0}},{Slot:28b,id:\"minecraft:shield\",Count:1b,tag:{Damage:0}},{Slot:29b,id:\"minecraft:bow\",Count:1b,tag:{Damage:0}},{Slot:30b,id:\"minecraft:crossbow\",Count:1b,tag:{Damage:0}},{Slot:35b,id:\"minecraft:diamond_pickaxe\",Count:1b,tag:{Damage:0}},{Slot:36b,id:\"minecraft:diamond_sword\",Count:1b,tag:{Damage:0}},{Slot:37b,id:\"minecraft:diamond_axe\",Count:1b,tag:{Damage:0}},{Slot:38b,id:\"minecraft:diamond_shovel\",Count:1b,tag:{Damage:0}},{Slot:39b,id:\"minecraft:diamond_hoe\",Count:1b,tag:{Damage:0}}]},CustomName:'{\"text\":\"Inventorio-Full\"}',XP:0,mstime:1681418977105L,x:-52,ItemCount:{inventorio:40,trinkets:0,Items:41},y:-30,Items:{Items:[{Slot:0b,id:\"minecraft:diamond_sword\",Count:1b,tag:{Damage:0}}]},z:-23,id:\"forgottengraves:grave\",noDecay:0,GraveOwner:{Id:[I;955138089,-476628734,-1921395004,-719679505],Name:\"Inventorio-Full\"}}";
        String inventorioResult = "[{Count:1b,Slot:0b,id:\"minecraft:diamond_sword\",tag:{Damage:0}},{Count:1b,Slot:1b,id:\"minecraft:flint_and_steel\",tag:{Damage:0}},{Count:1b,Slot:2b,id:\"minecraft:shield\",tag:{Damage:0}},{Count:1b,Slot:3b,id:\"minecraft:bow\",tag:{Damage:0}},{Count:1b,Slot:4b,id:\"minecraft:crossbow\",tag:{Damage:0}},{Count:1b,Slot:5b,id:\"minecraft:diamond_pickaxe\",tag:{Damage:0}},{Count:1b,Slot:6b,id:\"minecraft:diamond_sword\",tag:{Damage:0}},{Count:1b,Slot:7b,id:\"minecraft:diamond_axe\",tag:{Damage:0}},{Count:1b,Slot:8b,id:\"minecraft:diamond_shovel\",tag:{Damage:0}},{Count:1b,Slot:9b,id:\"minecraft:diamond_hoe\",tag:{Damage:0}}]";
        String trinketsSNBT = "{timers:{},trinkets:{Items:[{Slot:0b,id:\"minecraft:golden_helmet\",Count:1b,tag:{Damage:0}},{Slot:1b,id:\"minecraft:golden_boots\",Count:1b,tag:{Damage:0}},{Slot:2b,id:\"minecraft:golden_chestplate\",Count:1b,tag:{Damage:0}},{Slot:3b,id:\"minecraft:elytra\",Count:1b,tag:{Damage:0}},{Slot:4b,id:\"minecraft:golden_leggings\",Count:1b,tag:{Damage:0}}]},CustomName:'{\"text\":\"Trinkets-BothFull\"}',XP:0,mstime:1681418977105L,x:-52,ItemCount:{trinkets:5,Items:41},y:-30,Items:{Items:[]},z:-19,id:\"forgottengraves:grave\",noDecay:0,GraveOwner:{Id:[I;768727527,1471035076,-1953447371,-1312966385],Name:\"Trinkets-BothFull\"}}";
        String trinketsResult = "[{Count:1b,Slot:0b,id:\"minecraft:golden_helmet\",tag:{Damage:0}},{Count:1b,Slot:1b,id:\"minecraft:golden_boots\",tag:{Damage:0}},{Count:1b,Slot:2b,id:\"minecraft:golden_chestplate\",tag:{Damage:0}},{Count:1b,Slot:3b,id:\"minecraft:elytra\",tag:{Damage:0}},{Count:1b,Slot:4b,id:\"minecraft:golden_leggings\",tag:{Damage:0}}]";
        System.out.println(">> Running unloadedModRetrieval <<");
        GraveTestHelper.runCommand(context, "graves server config set graveRobbing true");
        context.method_46226(RetrieveGraveTest.checkUnloadedInventories(context, player, pos, backslotSNBT, backslotResult), "The player's main inventory should contain the BackSlot items after retrieving the grave.");
        context.method_46226(RetrieveGraveTest.checkUnloadedInventories(context, player, pos, inventorioSNBT, inventorioResult), "The player's main inventory should contain the Inventorio items after retrieving the grave.");
        context.method_46226(RetrieveGraveTest.checkUnloadedInventories(context, player, pos, trinketsSNBT, trinketsResult), "The player's main inventory should contain the Trinkets items after retrieving the grave.");
        GraveTestHelper.runCommand(context, "graves server config reset");
    }

    private static boolean checkBasicRetrieval(class_1657 player, class_2338 pos, String inventorySNBT) {
        class_1937 world = GraveTestHelper.getWorld(player, (class_5321<class_1937>)class_1937.field_25179);
        GraveTestNBTHelper.setPlayerInventoryFromSNBT(player, inventorySNBT);
        String playerInventoryBefore = GraveTestNBTHelper.getPlayerInventorySNBT(player);
        PlaceGrave.place(world, GraveTestHelper.posToVec3d(pos), player);
        GraveTestHelper.clearPlayerInventory(player);
        RetrieveGrave.retrieveWithInteract(player, GraveTestHelper.getWorld(player, (class_5321<class_1937>)class_1937.field_25179), pos);
        String playerInventoryAfter = GraveTestNBTHelper.getPlayerInventorySNBT(player);
        return GraveTestNBTHelper.compareInventoriesSNBT(playerInventoryBefore, playerInventoryAfter);
    }

    private static boolean checkMerge(class_1657 player, class_2338 pos, String currentInv, String graveInv, String resultInv) {
        class_1937 world = GraveTestHelper.getWorld(player, (class_5321<class_1937>)class_1937.field_25179);
        GraveTestNBTHelper.setPlayerInventoryFromSNBT(player, graveInv);
        PlaceGrave.place(world, GraveTestHelper.posToVec3d(pos), player);
        GraveTestHelper.clearPlayerInventory(player);
        GraveTestNBTHelper.setPlayerInventoryFromSNBT(player, currentInv);
        RetrieveGrave.retrieveWithInteract(player, GraveTestHelper.getWorld(player, (class_5321<class_1937>)class_1937.field_25179), pos);
        String playerInventorySNBT = GraveTestNBTHelper.getPlayerInventorySNBT(player);
        return GraveTestNBTHelper.compareInventoriesSNBT(resultInv, playerInventorySNBT);
    }

    private static void checkOverflow(class_4516 context, class_1657 player, class_2338 pos, String currentInv, String graveInv, class_1792 item, int count) {
        class_1937 world = GraveTestHelper.getWorld(player, (class_5321<class_1937>)class_1937.field_25179);
        GraveTestNBTHelper.setPlayerInventoryFromSNBT(player, graveInv);
        PlaceGrave.place(world, GraveTestHelper.posToVec3d(pos), player);
        GraveTestHelper.clearPlayerInventory(player);
        GraveTestNBTHelper.setPlayerInventoryFromSNBT(player, currentInv);
        RetrieveGrave.retrieveWithInteract(player, GraveTestHelper.getWorld(player, (class_5321<class_1937>)class_1937.field_25179), pos);
        context.method_35970(item, new class_2338(3, 2, 3), 2.0, count);
        context.method_52207(class_1542.class);
        GraveTestHelper.clearPlayerInventory(player);
    }

    private static boolean checkUnloadedInventories(class_4516 context, class_1657 player, class_2338 pos, String graveSNBT, String expectedResult) {
        GraveTestHelper.runCommand(context, String.format("/setblock %d %d %d forgottengraves:grave%s", pos.method_10263(), pos.method_10264(), pos.method_10260(), graveSNBT));
        RetrieveGrave.retrieveWithInteract(player, GraveTestHelper.getWorld(player, (class_5321<class_1937>)class_1937.field_25179), pos);
        String playerInventorySNBT = GraveTestNBTHelper.getPlayerInventorySNBT(player);
        GraveTestHelper.clearPlayerInventory(player);
        return GraveTestNBTHelper.compareInventoriesSNBT(playerInventorySNBT, expectedResult);
    }
}

