/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.gametest.tests;

import java.util.Objects;
import me.mgin.graves.block.GraveBlockBase;
import me.mgin.graves.block.utility.PlaceGrave;
import me.mgin.graves.block.utility.RetrieveGrave;
import me.mgin.graves.effects.GraveEffects;
import me.mgin.graves.gametest.GraveTestHelper;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4516;
import net.minecraft.class_5321;

public class PlaceGraveTest {
    public static void sinkInLava$false(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(10, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(10, 7, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void sinkInWater$false(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(2, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(2, 7, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void sinkThroughBlocks$false(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(6, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(6, 7, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void sinkInAir$false(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(18, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(18, 7, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void sinkInLava$true(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(10, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(10, 2, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void sinkInWater$true(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(2, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(2, 2, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void sinkThroughBlocks$true(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(6, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(6, 2, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void sinksInAir$true(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(18, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(18, 2, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void replaceBlocks$false(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(19, 2, 2));
        class_2338 endPos = context.method_36052(new class_2338(18, 2, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void replaceBlocks$true(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(18, 2, 2));
        context.method_35943().method_8501(pos, class_2246.field_10214.method_9564());
        PlaceGraveTest.checkPlaceGrave(context, player, pos, pos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void respectsBlacklist(class_4516 context, class_1657 player) {
        class_2338 pos = context.method_36052(new class_2338(14, 7, 2));
        class_2338 endPos = context.method_36052(new class_2338(14, 9, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, pos, endPos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void spawnsInNether(class_4516 context, class_1657 player) {
        class_2338 pos = new class_2338(45, 63, 102);
        PlaceGraveTest.checkPlaceGrave(context, player, pos, pos, (class_5321<class_1937>)class_1937.field_25180);
    }

    public static void spawnsInEnd(class_4516 context, class_1657 player) {
        class_2338 pos = new class_2338(57, 56, 88);
        PlaceGraveTest.checkPlaceGrave(context, player, pos, pos, (class_5321<class_1937>)class_1937.field_25181);
    }

    public static void respectsWorldBoundaries(class_4516 context, class_1657 player) {
        class_2338 minYOverworldPos = context.method_36052(new class_2338(18, -10, 2));
        class_2338 maxYOverworldPos = context.method_36052(new class_2338(18, 400, 2));
        class_2338 overworldEndPos = context.method_36052(new class_2338(18, 2, 2));
        PlaceGraveTest.checkPlaceGrave(context, player, minYOverworldPos, overworldEndPos, (class_5321<class_1937>)class_1937.field_25179);
        PlaceGraveTest.checkPlaceGrave(context, player, maxYOverworldPos, overworldEndPos, (class_5321<class_1937>)class_1937.field_25179);
        class_2338 minYEndPos = new class_2338(100, -200, 100);
        class_2338 maxYEndPos = new class_2338(100, 320, 100);
        class_2338 endFinalPos = new class_2338(100, 1, 100);
        PlaceGraveTest.checkPlaceGrave(context, player, minYEndPos, endFinalPos, (class_5321<class_1937>)class_1937.field_25181);
        PlaceGraveTest.checkPlaceGrave(context, player, maxYEndPos, endFinalPos, (class_5321<class_1937>)class_1937.field_25181);
    }

    public static void graves$false(class_4516 context, class_1657 player) {
        class_2338 pos = new class_2338(18, 2, 2);
        PlaceGraveTest.checkGravesDisabled(context, player, pos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void respectsDisableEffect(class_4516 context, class_1657 player) {
        class_2338 pos = new class_2338(18, 2, 2);
        player.method_6092(new class_1293(GraveEffects.DISABLE_GRAVES_EFFECT, 300));
        PlaceGraveTest.checkGravesDisabled(context, player, pos, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static void disableInPvP$true(class_4516 context, class_1657 player) {
        class_2338 pos = new class_2338(18, 2, 2);
        class_1657 player2 = context.method_36021();
        player.method_5814(0.0, -58.0, 0.0);
        player2.method_5814(0.0, -58.0, 0.0);
        player2.method_7324((class_1297)player);
        PlaceGraveTest.checkGravesDisabled(context, player, pos, (class_5321<class_1937>)class_1937.field_25179);
    }

    private static void checkPlaceGrave(class_4516 context, class_1657 player, class_2338 pos, class_2338 endPos, class_5321<class_1937> worldKey) {
        System.out.println(">> Running " + Thread.currentThread().getStackTrace()[2].getMethodName() + " <<");
        class_3218 world = Objects.requireNonNull(player.method_5682()).method_3847(worldKey);
        if (world != null) {
            PlaceGrave.place((class_1937)world, GraveTestHelper.posToVec3d(pos), player);
            class_2248 block = world.method_8320(endPos).method_26204();
            String errorMessage = "Expect block to be a grave block at " + endPos + " got " + block.method_9518() + " in " + worldKey.method_29177();
            context.method_46226(block instanceof GraveBlockBase, errorMessage);
            RetrieveGrave.retrieveWithInteract(player, (class_1937)world, endPos);
        }
    }

    private static void checkGravesDisabled(class_4516 context, class_1657 player, class_2338 pos, class_5321<class_1937> worldKey) {
        System.out.println(">> Running " + Thread.currentThread().getStackTrace()[2].getMethodName() + " <<");
        class_3218 world = Objects.requireNonNull(player.method_5682()).method_3847(worldKey);
        if (world != null) {
            class_1799 stack = class_1802.field_8603.method_7854();
            stack.method_7939(5);
            player.method_7270(stack);
            class_2338 abs = context.method_36052(pos);
            GraveTestHelper.teleportPlayer(player, abs);
            GraveTestHelper.dropMockPlayerInventory(player, (class_1937)world, abs);
            player.method_5768();
            class_2248 block = world.method_8320(abs).method_26204();
            String errorMessage = "Expect block not to be a grave block at " + abs + " got " + block.method_9518() + " in " + worldKey.method_29177();
            context.method_46226(!(block instanceof GraveBlockBase), errorMessage);
            context.method_35970(class_1802.field_8603, pos, 3.0, 5);
            context.method_52207(class_1542.class);
        }
    }
}

