/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.gametest.tests;

import me.mgin.graves.block.utility.Experience;
import me.mgin.graves.gametest.GraveTestHelper;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_4516;

public class ExperienceTest {
    public static void storeAll(class_4516 context, class_1657 player, class_2338 pos) {
        GraveTestHelper.runCommand(context, "graves server config reset");
        System.out.println(">> Running STORE_ALL XP L0-16 <<");
        player.method_7316(14);
        player.method_7255(5);
        ExperienceTest.runExperienceTest(context, player, pos, 14, 5);
        System.out.println(">> Running STORE_ALL XP L17-31 <<");
        player.method_7316(18);
        player.method_7255(10);
        ExperienceTest.runExperienceTest(context, player, pos, 18, 10);
        System.out.println(">> Running STORE_ALL XP L32+ <<");
        player.method_7316(34);
        player.method_7255(27);
        ExperienceTest.runExperienceTest(context, player, pos, 34, 27);
        System.out.println(">> Running STORE_ALL XP (No Points) <<");
        player.method_7316(32);
        ExperienceTest.runExperienceTest(context, player, pos, 32, 0);
    }

    public static void storeVanilla(class_4516 context, class_1657 player, class_2338 pos) {
        GraveTestHelper.runCommand(context, "graves server config reset");
        GraveTestHelper.runCommand(context, "graves server config set expStorageType VANILLA");
        System.out.println(">> Running VANILLA XP <<");
        player.method_7316(45);
        player.method_7255(8);
        ExperienceTest.runExperienceTest(context, player, pos, 15, 0);
        GraveTestHelper.runCommand(context, "graves server config set cap 100");
        GraveTestHelper.runCommand(context, "graves server config set capType POINTS");
        System.out.println(">> Running VANILLA XP (Point Cap) <<");
        player.method_7316(45);
        player.method_7255(8);
        ExperienceTest.runExperienceTest(context, player, pos, 7, 9);
    }

    public static void storeNone(class_4516 context, class_1657 player, class_2338 pos) {
        GraveTestHelper.runCommand(context, "graves server config reset");
        GraveTestHelper.runCommand(context, "graves server config set expStorageType NONE");
        System.out.println(">> Running NONE XP <<");
        player.method_7316(45);
        player.method_7255(8);
        ExperienceTest.runExperienceTest(context, player, pos, 0, 0);
    }

    public static void percentage(class_4516 context, class_1657 player, class_2338 pos) {
        GraveTestHelper.runCommand(context, "graves server config reset");
        GraveTestHelper.runCommand(context, "graves server config set percentage 70");
        System.out.println(">> Running Percentage XP (Points) <<");
        player.method_7316(45);
        player.method_7255(8);
        ExperienceTest.runExperienceTest(context, player, pos, 39, 92);
        GraveTestHelper.runCommand(context, "graves server config set percentageType LEVELS");
        System.out.println(">> Running Percentage XP (Levels) <<");
        player.method_7316(45);
        player.method_7255(8);
        ExperienceTest.runExperienceTest(context, player, pos, 31, 65);
    }

    public static void cap(class_4516 context, class_1657 player, class_2338 pos) {
        GraveTestHelper.runCommand(context, "graves server config reset");
        GraveTestHelper.runCommand(context, "graves server config set cap 30");
        System.out.println(">> Running Cap XP (Levels) <<");
        player.method_7316(100);
        player.method_7255(100);
        ExperienceTest.runExperienceTest(context, player, pos, 30, 0);
    }

    private static void resetPlayerExperience(class_1657 player) {
        player.field_7495 = 0;
        player.field_7520 = 0;
        player.field_7510 = 0.0f;
    }

    private static int getPlayerExperiencePoints(class_1657 player) {
        return (int)Math.floor((float)player.method_7349() * player.field_7510);
    }

    private static void runExperienceTest(class_4516 context, class_1657 player, class_2338 pos, int expectedLevel, int expectedPoints) {
        int[] experience = Experience.calculatePlayerExperience(player);
        ExperienceTest.resetPlayerExperience(player);
        player.method_7316(experience[0]);
        player.method_7255(experience[1]);
        int playerExperiencePoints = ExperienceTest.getPlayerExperiencePoints(player);
        context.method_46226(player.field_7520 == expectedLevel && playerExperiencePoints == expectedPoints, String.format("Player wasn't %dL %dP on retrieval, got: %dL %dP.", expectedLevel, expectedPoints, player.field_7520, playerExperiencePoints));
        ExperienceTest.resetPlayerExperience(player);
    }
}

