/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.config;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Objects;
import me.mgin.graves.Graves;
import me.mgin.graves.config.ConfigOptions;
import me.mgin.graves.config.GravesConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;

public class ConfigHelpers {
    public String serialize() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public static GravesConfig deserialize(String config) {
        Gson gson = new Gson();
        return (GravesConfig)gson.fromJson(config, GravesConfig.class);
    }

    public static void setConfig(GravesConfig config) {
        AutoConfig.getConfigHolder(GravesConfig.class).setConfig((ConfigData)config);
    }

    public static GravesConfig getConfig() {
        return (GravesConfig)AutoConfig.getConfigHolder(GravesConfig.class).getConfig();
    }

    public void save() {
        AutoConfig.getConfigHolder(GravesConfig.class).save();
    }

    public void reload() {
        AutoConfig.getConfigHolder(GravesConfig.class).load();
    }

    public static <T> T resolve(String option, GameProfile profile) {
        GravesConfig clientConfig;
        GravesConfig config = GravesConfig.getConfig();
        if (config.server.clientOptions.contains(option) && Graves.clientConfigs.containsKey(profile) && (clientConfig = Graves.clientConfigs.get(profile)) != null) {
            config = clientConfig;
        }
        try {
            Field subclass = ConfigHelpers.determineSubClass(option);
            if (subclass != null) {
                Field field = subclass.getType().getDeclaredField(option);
                Object result = field.get(subclass.get(config));
                return (T)result;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NullPointerException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Something went wrong trying to access " + option);
    }

    public void setDynamicField(String option, Object value) {
        try {
            Field subclass = ConfigHelpers.determineSubClass(option);
            Field field = Objects.requireNonNull(subclass).getType().getDeclaredField(option);
            field.set(subclass.get(this), value);
        }
        catch (IllegalAccessException | NoSuchFieldException | NullPointerException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field determineSubClass(String option) throws NoSuchFieldException {
        for (String subclass : ConfigOptions.subclass) {
            if (!ConfigOptions.options.get(subclass).contains(option)) continue;
            return GravesConfig.class.getDeclaredField(subclass);
        }
        return null;
    }
}

