/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.mgin.graves.block.GraveBlockBase;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.command.ListCommand;
import me.mgin.graves.command.utility.ArgumentUtility;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.state.PlayerState;
import me.mgin.graves.state.ServerState;
import me.mgin.graves.util.NbtHelper;
import me.mgin.graves.util.Responder;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class DeleteCommand {
    public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        Responder res = new Responder((class_1657)source.method_44023(), server);
        GameProfile player = ArgumentUtility.getProfileArgument(context, "player", 3);
        int graveId = ArgumentUtility.getIntegerArgument(context, "graveid", 4);
        boolean showList = ArgumentUtility.getBooleanArgument(context, "showlist", 5);
        GameProfile recipient = ArgumentUtility.getProfileArgument(context, "recipient", 6);
        if (player == null) {
            res.sendError((class_2561)class_2561.method_43471((String)"command.generic.error.specify-player"), null);
            return 1;
        }
        String name = player.getName();
        PlayerState playerState = ServerState.getPlayerState(server, player.getId());
        if (playerState.graves.size() >= graveId) {
            class_2487 grave = playerState.graves.method_10602(graveId - 1);
            playerState.graves.method_10536(graveId - 1);
            ServerState.getServerState(server).method_80();
            res.sendInfo((class_2561)class_2561.method_43469((String)"command.delete.deleted-grave", (Object[])new Object[]{graveId, player.getName()}), null);
            if (!grave.method_10577("retrieved")) {
                GravesConfig config = GravesConfig.getConfig();
                boolean destructive = config.server.destructiveDeleteCommand;
                if (destructive) {
                    class_2338 gravePos = NbtHelper.readCoordinates(grave);
                    String storedDimension = grave.method_10558("dimension");
                    for (class_3218 world : server.method_3738()) {
                        GraveBlockEntity graveEntity;
                        class_2586 class_25862;
                        String dimension = String.valueOf(world.method_44013().method_29177());
                        if (!dimension.equals(storedDimension) || !((class_25862 = world.method_8321(gravePos)) instanceof GraveBlockEntity) || (graveEntity = (GraveBlockEntity)class_25862).getMstime() != grave.method_10537("mstime")) continue;
                        GraveBlockBase graveBlock = (GraveBlockBase)world.method_8320(gravePos).method_26204();
                        graveBlock.setBrokenByPlayer(true);
                        world.method_8650(gravePos, false);
                    }
                }
            }
        } else {
            res.sendError((class_2561)class_2561.method_43469((String)"command.generic.error.grave-doesnt-exist", (Object[])new Object[]{name}), null);
        }
        if (showList) {
            int page = graveId % 5 == 0 ? graveId / 5 : (int)(Math.floor((double)graveId / 5.0) + 1.0);
            ListCommand.executeWithoutCommand(res, player, recipient, page, server, source.method_44023());
        }
        return 1;
    }
}

