/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.utility;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Objects;
import me.mgin.graves.Graves;
import me.mgin.graves.api.InventoriesApi;
import me.mgin.graves.block.GraveBlockBase;
import me.mgin.graves.block.GraveBlocks;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.block.utility.Inventory;
import me.mgin.graves.block.utility.Permission;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.config.enums.GraveDropType;
import me.mgin.graves.config.enums.GraveMergeOrder;
import me.mgin.graves.inventory.Vanilla;
import me.mgin.graves.state.PlayerState;
import me.mgin.graves.state.ServerState;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class RetrieveGrave {
    public static boolean retrieveWithInteract(class_1657 player, class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return false;
        }
        GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
        if (world.field_9236) {
            return false;
        }
        if (graveEntity.getInventory("Items") == null) {
            return false;
        }
        if (graveEntity.getGraveOwner() == null) {
            return false;
        }
        if (!Permission.playerCanAttemptRetrieve(player, graveEntity) && !Permission.playerCanOverride(player)) {
            return false;
        }
        return RetrieveGrave.retrieve(player, graveEntity, world, pos, false, true);
    }

    public static void retrieveWithCommand(class_1657 player, class_2487 graveEntityTag) {
        class_2338 pos = new class_2338(graveEntityTag.method_10550("x"), graveEntityTag.method_10550("y"), graveEntityTag.method_10550("z"));
        for (class_3218 world : Objects.requireNonNull(player.method_5682()).method_3738()) {
            GraveBlockEntity graveBlockEntity;
            String dimensionKey = String.valueOf(world.method_44013().method_29177());
            String storedDimensionKey = graveEntityTag.method_10558("dimension");
            GraveBlockEntity graveEntity = null;
            boolean destroyGrave = true;
            if (!dimensionKey.equals(storedDimensionKey)) continue;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof GraveBlockEntity && (graveBlockEntity = (GraveBlockEntity)class_25862).getMstime() == graveEntityTag.method_10537("mstime")) {
                graveEntity = graveBlockEntity;
            }
            if (graveEntity == null) {
                graveEntity = new GraveBlockEntity(pos, GraveBlocks.GRAVE.method_9564());
                graveEntity.method_11014(graveEntityTag);
                destroyGrave = false;
            }
            RetrieveGrave.retrieve(player, graveEntity, (class_1937)world, pos, true, destroyGrave);
            return;
        }
    }

    public static boolean retrieve(class_1657 player, GraveBlockEntity graveEntity, class_1937 world, class_2338 pos, boolean dropOnPlayer, boolean destroyGrave) {
        class_2371<class_1799> overflow = class_2371.method_10211();
        GameProfile profile = player.method_7334();
        GraveDropType dropType = (GraveDropType)((Object)GravesConfig.resolve("dropType", profile));
        boolean shiftSwapsDropType = (Boolean)GravesConfig.resolve("sneakSwapsDropType", profile);
        if (shiftSwapsDropType && player.method_5715()) {
            GraveDropType graveDropType = dropType = dropType == GraveDropType.DROP ? GraveDropType.EQUIP : GraveDropType.DROP;
        }
        if (dropType == GraveDropType.EQUIP) {
            overflow = RetrieveGrave.equipInventoryItems(player, graveEntity);
        } else if (dropType == GraveDropType.DROP) {
            overflow = RetrieveGrave.getInventoryItems(graveEntity);
        }
        class_1264.method_17349((class_1937)(dropOnPlayer ? player.method_37908() : world), (class_2338)(dropOnPlayer ? player.method_24515() : pos), overflow);
        int[] experience = graveEntity.getXp();
        player.method_7316(experience[0]);
        player.method_7255(experience[1]);
        if (world.method_8321(pos) instanceof GraveBlockEntity && destroyGrave) {
            GraveBlockBase graveBlock = (GraveBlockBase)world.method_8320(pos).method_26204();
            graveBlock.setBrokenByPlayer(true);
            world.method_8650(pos, false);
        }
        GameProfile owner = graveEntity.getGraveOwner();
        PlayerState playerState = ServerState.getPlayerState(player.method_5682(), owner.getId());
        for (int i = 0; i < playerState.graves.size(); ++i) {
            class_2487 grave = (class_2487)playerState.graves.method_10534(i);
            assert (player.method_5682() != null);
            if (grave.method_10537("mstime") != graveEntity.getMstime()) continue;
            grave.method_10556("retrieved", true);
            playerState.graves.method_10606(i, (class_2520)grave);
            ServerState.getServerState(player.method_5682()).method_80();
        }
        return true;
    }

    public static class_2371<class_1799> getInventoryItems(GraveBlockEntity graveEntity) {
        class_2371<class_1799> modInventory;
        class_2371 items = class_2371.method_10211();
        for (InventoriesApi api : Graves.inventories) {
            modInventory = graveEntity.getInventory(api.getID());
            if (modInventory == null) continue;
            items.addAll(modInventory);
        }
        for (String modID : Graves.unloadedInventories) {
            modInventory = graveEntity.getInventory(modID);
            if (modInventory == null) continue;
            items.addAll(modInventory);
        }
        return items;
    }

    public static class_2371<class_1799> equipInventoryItems(class_1657 player, GraveBlockEntity graveEntity) {
        GraveMergeOrder mergeOrder = (GraveMergeOrder)((Object)GravesConfig.resolve("mergeOrder", player.method_7334()));
        class_2371 overflow = class_2371.method_10211();
        for (InventoriesApi api : Graves.inventories) {
            class_2371<class_1799> graveInventory = graveEntity.getInventory(api.getID());
            class_2371<class_1799> playerInventory = api.getInventory(player);
            if (mergeOrder == GraveMergeOrder.CURRENT) {
                if (graveInventory != null) {
                    if (api.getInventorySize(player) == graveInventory.size()) {
                        overflow.addAll(api.setInventory((List<class_1799>)graveInventory, player));
                    } else {
                        overflow.addAll(graveInventory);
                    }
                }
            } else {
                api.clearInventory(player);
                if (graveInventory != null) {
                    if (api.getInventorySize(player) == graveInventory.size()) {
                        overflow.addAll(api.setInventory((List<class_1799>)graveInventory, player));
                    } else {
                        overflow.addAll(graveInventory);
                    }
                }
                if (playerInventory != null) {
                    overflow.addAll(api.setInventory((List<class_1799>)playerInventory, player));
                }
            }
            if (!(api instanceof Vanilla)) continue;
            Vanilla vanillaApi = (Vanilla)api;
            vanillaApi.resetEquippedOffhand();
        }
        for (String unloadedModID : Graves.unloadedInventories) {
            class_2371<class_1799> inventory = graveEntity.getInventory(unloadedModID);
            if (inventory == null) continue;
            overflow.addAll(inventory);
        }
        overflow.removeIf(class_1799::method_7960);
        Inventory.mergeInventories((List<class_1799>)overflow, player.method_31548());
        return overflow;
    }
}

