/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.utility;

import com.mojang.authlib.GameProfile;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.config.enums.ExperienceType;
import me.mgin.graves.config.enums.GraveExpStoreType;
import net.minecraft.class_1657;

public class Experience {
    public static int[] calculatePlayerExperience(class_1657 player) {
        GraveExpStoreType storageType = (GraveExpStoreType)((Object)GravesConfig.resolve("expStorageType", player.method_7334()));
        int[] experience = new int[]{0, 0};
        switch (storageType) {
            case ALL: {
                experience = Experience.getCurrentExperience(player);
                break;
            }
            case VANILLA: {
                experience = Experience.getVanillaExperience(player);
                break;
            }
            case NONE: {
                return new int[]{0, 0};
            }
        }
        return Experience.applyConfigurationOptions(player, experience[0], experience[1]);
    }

    public static int[] getCurrentExperience(class_1657 player) {
        return new int[]{player.field_7520, Experience.getPlayerExperiencePoints(player)};
    }

    public static int[] getVanillaExperience(class_1657 player) {
        int vanillaExperience = 7 * player.field_7520;
        return Experience.calculateLevelAndPoints(vanillaExperience, player);
    }

    public static int[] applyConfigurationOptions(class_1657 player, int startingLevel, int startingPoints) {
        GameProfile profile = player.method_7334();
        int percentage = (Integer)GravesConfig.resolve("percentage", profile);
        ExperienceType percentageType = (ExperienceType)((Object)GravesConfig.resolve("percentageType", profile));
        float percentageModifier = (float)percentage / 100.0f;
        int cap = (Integer)GravesConfig.resolve("cap", profile);
        ExperienceType capType = (ExperienceType)((Object)GravesConfig.resolve("capType", profile));
        int[] result = new int[]{startingLevel, startingPoints};
        if (100 > percentage) {
            if (percentageType == ExperienceType.LEVELS) {
                float adjustedLevel = (float)startingLevel * percentageModifier;
                int level = (int)Math.floor(adjustedLevel);
                float progress = adjustedLevel - (float)level;
                int originalLevel = player.field_7520;
                player.field_7520 = level;
                int points = (int)Math.floor((float)player.method_7349() * progress);
                player.field_7520 = originalLevel;
                if (startingPoints > 0) {
                    float pointPercentage = (float)startingPoints / (float)Experience.getNextLevelExperience(level, player);
                    points += (int)Math.floor(pointPercentage * percentageModifier * (float)Experience.getNextLevelExperience(level, player));
                }
                result = new int[]{level, points};
            } else {
                long totalExperience = Experience.calculateTotalExperience(startingLevel, startingPoints, player);
                long adjustedExperience = (long)Math.floor((float)totalExperience * percentageModifier);
                result = Experience.calculateLevelAndPoints(adjustedExperience, player);
            }
        }
        if (cap > -1) {
            if (capType == ExperienceType.LEVELS) {
                if (result[0] > cap) {
                    return new int[]{cap, 0};
                }
            } else {
                long totalExperience = Experience.calculateTotalExperience(result[0], result[1], player);
                if (totalExperience > (long)cap) {
                    return Experience.calculateLevelAndPoints(cap, player);
                }
            }
        }
        return result;
    }

    private static int getPlayerExperiencePoints(class_1657 player) {
        return (int)Math.floor((float)player.method_7349() * player.field_7510);
    }

    private static int getNextLevelExperience(int level, class_1657 player) {
        int originalLevel = player.field_7520;
        player.field_7520 = level;
        int experienceRequired = player.method_7349();
        player.field_7520 = originalLevel;
        return experienceRequired;
    }

    private static int[] calculateLevelAndPoints(long totalExperience, class_1657 player) {
        int level = 0;
        long points = totalExperience;
        int originalLevel = player.field_7520;
        while (true) {
            player.field_7520 = level++;
            int experienceForNextLevel = player.method_7349();
            if (points < (long)experienceForNextLevel) break;
            points -= (long)experienceForNextLevel;
        }
        player.field_7520 = originalLevel;
        return new int[]{level, (int)points};
    }

    private static long calculateTotalExperience(int level, int points, class_1657 player) {
        long totalExperience = 0L;
        int originalLevel = player.field_7520;
        int i = 0;
        while (i < level) {
            player.field_7520 = i++;
            totalExperience += (long)player.method_7349();
        }
        player.field_7520 = originalLevel;
        return totalExperience += (long)points;
    }
}

