/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.render.text;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.block.render.GraveResourcePackManager;
import me.mgin.graves.block.render.packs.TextPositions;
import me.mgin.graves.block.render.text.GraveTextFormatter;
import net.minecraft.class_2350;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_7833;

public class GraveTextRenderer {
    private final class_327 textRenderer;
    private static final int MAX_CHAR_PER_LINE = 15;
    private static final int MAX_LINES = 6;
    public static final float TEXT_SCALE = 0.012f;
    public TextPositions textPositions;
    private final Map<String, List<class_2561>> cachedLinesMap = new HashMap<String, List<class_2561>>();
    private final Map<String, Float> cachedScaleMap = new HashMap<String, Float>();

    public GraveTextRenderer(class_327 textRenderer) {
        this.textRenderer = textRenderer;
    }

    public void render(GraveBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, class_2350 direction, int light) {
        List<class_2561> formattedLines;
        float scale;
        String text = this.getGraveName(entity);
        String cacheKey = this.generateCacheKey(entity, text);
        if (text.length() == 0) {
            return;
        }
        if (!this.cachedLinesMap.containsKey(cacheKey)) {
            this.textPositions = GraveResourcePackManager.getActivePack().getTextPositions();
            List<String> lines = this.wrapText(text);
            float maxLineWidth = this.getMaxLineWidth(lines);
            scale = Math.min(0.012f, (float)this.textPositions.TEXT_WIDTH / maxLineWidth * 0.012f);
            GraveTextFormatter formatter = new GraveTextFormatter();
            formattedLines = formatter.formatLines(lines);
            this.cachedLinesMap.put(cacheKey, formattedLines);
            this.cachedScaleMap.put(cacheKey, Float.valueOf(scale));
        } else {
            formattedLines = this.cachedLinesMap.get(cacheKey);
            scale = this.cachedScaleMap.get(cacheKey).floatValue();
        }
        this.renderFormattedLines(formattedLines, matrices, vertexConsumers, direction, light, scale);
    }

    private String generateCacheKey(GraveBlockEntity entity, String text) {
        return entity.method_11016().toString() + ":" + text;
    }

    private String getGraveName(GraveBlockEntity graveEntity) {
        boolean customNameNotEmpty;
        boolean hasOwner = graveEntity.getGraveOwner() != null;
        boolean hasCustomName = graveEntity.getCustomName() != null;
        boolean bl = customNameNotEmpty = !graveEntity.getCustomName().isEmpty();
        if (hasOwner) {
            return graveEntity.getGraveOwner().getName();
        }
        String customName = graveEntity.getCustomName();
        if (hasCustomName && customNameNotEmpty) {
            if (customName.contains("\"text\":")) {
                try {
                    return class_2522.method_10718((String)customName).method_10558("text");
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (customName.startsWith("\"") && customName.endsWith("\"")) {
                return customName.replace("\"", "");
            }
        }
        return customName;
    }

    private List<String> wrapText(String text) {
        String[] splitText;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        int lineLength = 0;
        for (String segment : splitText = text.split("\\\\n")) {
            String[] words;
            if (segment.isEmpty()) {
                if (lines.size() >= 6) continue;
                lines.add("");
                continue;
            }
            for (String word : words = segment.split(" ")) {
                String strippedWord = GraveTextFormatter.stripFormattingCodes(word);
                int strippedLength = strippedWord.length();
                if (lineLength + strippedLength > 15) {
                    if (lines.size() < 5) {
                        lines.add(line.toString());
                        line = new StringBuilder();
                        lineLength = 0;
                    } else {
                        line.append("...");
                        lines.add(line.toString());
                        return lines;
                    }
                }
                if (line.length() > 0) {
                    line.append(" ");
                    ++lineLength;
                }
                line.append(word);
                lineLength += strippedLength;
            }
            if (lineLength <= 0) continue;
            if (lines.size() >= 5) {
                lines.add("...");
                return lines;
            }
            lines.add(line.toString());
            line = new StringBuilder();
            lineLength = 0;
        }
        return lines;
    }

    private float getMaxLineWidth(List<String> lines) {
        float maxLineWidth = 0.0f;
        for (String line : lines) {
            String strippedLine = GraveTextFormatter.stripFormattingCodes(line);
            float lineWidth = this.textRenderer.method_1727(strippedLine);
            if (!(lineWidth > maxLineWidth)) continue;
            maxLineWidth = lineWidth;
        }
        return maxLineWidth;
    }

    private void renderFormattedLines(List<class_2561> formattedLines, class_4587 matrices, class_4597 vertexConsumers, class_2350 direction, int light, float scale) {
        matrices.method_22903();
        this.rotateText(direction, matrices, formattedLines);
        matrices.method_22905(scale, -scale, scale);
        int yOffset = 0;
        for (class_2561 line : formattedLines) {
            float xOffset = (float)(-this.textRenderer.method_27525((class_5348)line)) / 2.0f;
            this.textRenderer.method_30882(line, xOffset, (float)yOffset, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
            yOffset += 10;
        }
        matrices.method_22909();
    }

    private void rotateText(class_2350 direction, class_4587 matrices, List<class_2561> lines) {
        float textHeight = (float)this.textPositions.TEXT_HEIGHT / 100.0f + (float)lines.size() * 0.025f;
        float textDepth = (float)this.textPositions.TEXT_DEPTH * 0.0626f;
        switch (direction) {
            case field_11043: {
                matrices.method_22904(0.5, (double)textHeight, (double)textDepth);
                break;
            }
            case field_11034: {
                matrices.method_22907(class_7833.field_40716.rotation(4.71239f));
                matrices.method_46416(0.5f, textHeight, -1.0f + textDepth);
                break;
            }
            case field_11035: {
                matrices.method_22907(class_7833.field_40716.rotation((float)Math.PI));
                matrices.method_22904(-0.5, (double)textHeight, (double)(-1.0f + textDepth));
                break;
            }
            case field_11039: {
                matrices.method_22907(class_7833.field_40716.rotation(1.5707964f));
                matrices.method_46416(-0.5f, textHeight, textDepth);
                break;
            }
        }
    }
}

