/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.render.text;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class GraveTextFormatter {
    private class_124 color;
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private boolean strikethrough;
    private boolean obfuscated;

    public void GraveTextFormatter() {
        this.resetFormatting();
    }

    public void resetFormatting() {
        this.color = class_124.field_1070;
        this.bold = false;
        this.italic = false;
        this.underline = false;
        this.strikethrough = false;
        this.obfuscated = false;
    }

    public List<class_2561> formatLines(List<String> lines) {
        ArrayList<class_2561> formattedLines = new ArrayList<class_2561>();
        for (String line : lines) {
            List<String> splitText = GraveTextFormatter.splitByFormattingCode(line);
            class_5250 formattedText = class_2561.method_43470((String)"");
            for (String segment : splitText) {
                if (segment.startsWith("&")) {
                    class_124 formatting = GraveTextFormatter.getFormatting(segment.charAt(1));
                    if (formatting == null) continue;
                    this.addFormatting(formatting);
                    continue;
                }
                class_5250 textSegment = class_2561.method_43470((String)segment);
                formattedText = formattedText.method_27661().method_10852(this.setFormatting((class_2561)textSegment));
            }
            formattedLines.add((class_2561)formattedText);
        }
        return formattedLines;
    }

    public void addFormatting(class_124 formatting) {
        switch (formatting) {
            case field_1067: {
                this.bold = true;
                break;
            }
            case field_1056: {
                this.italic = true;
                break;
            }
            case field_1073: {
                this.underline = true;
                break;
            }
            case field_1055: {
                this.strikethrough = true;
                break;
            }
            case field_1051: {
                this.obfuscated = true;
                break;
            }
            case field_1070: {
                this.resetFormatting();
                break;
            }
            default: {
                this.color = formatting;
            }
        }
    }

    public class_2561 setFormatting(class_2561 text) {
        class_2561 result = text;
        if (this.color != null && this.color != class_124.field_1070) {
            result = result.method_27661().method_27692(this.color);
        }
        if (this.bold) {
            result = result.method_27661().method_27692(class_124.field_1067);
        }
        if (this.italic) {
            result = result.method_27661().method_27692(class_124.field_1056);
        }
        if (this.underline) {
            result = result.method_27661().method_27692(class_124.field_1073);
        }
        if (this.strikethrough) {
            result = result.method_27661().method_27692(class_124.field_1055);
        }
        if (this.obfuscated) {
            result = result.method_27661().method_27692(class_124.field_1051);
        }
        return result;
    }

    public static String stripFormattingCodes(String text) {
        return text.replaceAll("&[a-zA-Z0-9]", "");
    }

    public static List<String> splitByFormattingCode(String text) {
        String pattern = "(&[a-zA-Z0-9])";
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = Pattern.compile(pattern).matcher(text);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                result.add(text.substring(lastEnd, matcher.start()));
            }
            result.add(matcher.group());
            lastEnd = matcher.end();
        }
        if (lastEnd < text.length()) {
            result.add(text.substring(lastEnd));
        }
        return result;
    }

    public static class_124 getFormatting(char code) {
        return switch (code) {
            case '0' -> class_124.field_1074;
            case '1' -> class_124.field_1058;
            case '2' -> class_124.field_1077;
            case '3' -> class_124.field_1062;
            case '4' -> class_124.field_1079;
            case '5' -> class_124.field_1064;
            case '6' -> class_124.field_1065;
            case '7' -> class_124.field_1080;
            case '8' -> class_124.field_1063;
            case '9' -> class_124.field_1078;
            case 'a' -> class_124.field_1060;
            case 'b' -> class_124.field_1075;
            case 'c' -> class_124.field_1061;
            case 'd' -> class_124.field_1076;
            case 'e' -> class_124.field_1054;
            case 'f' -> class_124.field_1068;
            case 'k' -> class_124.field_1051;
            case 'l' -> class_124.field_1067;
            case 'm' -> class_124.field_1055;
            case 'n' -> class_124.field_1073;
            case 'o' -> class_124.field_1056;
            case 'r' -> class_124.field_1070;
            default -> null;
        };
    }
}

