/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.render;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import me.mgin.graves.block.GraveBlockBase;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.block.render.GraveResourcePackManager;
import me.mgin.graves.block.render.packs.GraveResourcePack;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_607;
import net.minecraft.class_7833;
import net.minecraft.class_836;

public class GraveSkullRenderer {
    private final class_5599 skullRenderer;
    public static Map<String, SkullWrapper> skulls = new HashMap<String, SkullWrapper>(){
        {
            this.put("wither_skeleton_skull", new SkullWrapper((class_2484.class_2485)class_2484.class_2486.field_11513, class_5602.field_27634));
            this.put("skeleton_skull", new SkullWrapper((class_2484.class_2485)class_2484.class_2486.field_11512, class_5602.field_27653));
            this.put("player_head", new SkullWrapper((class_2484.class_2485)class_2484.class_2486.field_11510, class_5602.field_27578));
            this.put("zombie_head", new SkullWrapper((class_2484.class_2485)class_2484.class_2486.field_11508, class_5602.field_27640));
            this.put("creeper_head", new SkullWrapper((class_2484.class_2485)class_2484.class_2486.field_11507, class_5602.field_27548));
            this.put("piglin_head", new SkullWrapper((class_2484.class_2485)class_2484.class_2486.field_41313, class_5602.field_41382));
        }
    };

    public GraveSkullRenderer(class_5599 modelLoader) {
        this.skullRenderer = modelLoader;
    }

    public void render(GraveBlockEntity graveEntity, class_4587 matrices, class_4597 vertexConsumers, class_2350 direction, class_2680 state, int light) {
        int decayStage = ((GraveBlockBase)state.method_26204()).getDecayStage().ordinal();
        matrices.method_22903();
        matrices.method_22905(0.75f, 0.75f, 0.75f);
        matrices.method_46416(0.0f, 0.08f, 0.0f);
        this.rotateSkull(direction, matrices, decayStage);
        GraveSkullRenderer.renderSkull(graveEntity, this.skullRenderer, decayStage, matrices, light, vertexConsumers);
        matrices.method_22909();
    }

    private void rotateSkull(class_2350 direction, class_4587 matrices, int decayStage) {
        GraveResourcePack pack = GraveResourcePackManager.getActivePack();
        switch (direction) {
            case field_11043: {
                matrices.method_22907(class_7833.field_40716.rotation((float)Math.PI));
                matrices.method_22904(-1.2, 0.25 - (double)decayStage * 0.03, -0.99 + (double)pack.getSkullOffset());
                break;
            }
            case field_11035: {
                matrices.method_22904(0.15, 0.25 - (double)decayStage * 0.03, 0.34 + (double)pack.getSkullOffset());
                break;
            }
            case field_11034: {
                matrices.method_22907(class_7833.field_40716.rotation(1.5707964f));
                matrices.method_22904(-1.2, 0.25 - (double)decayStage * 0.03, 0.34 + (double)pack.getSkullOffset());
                break;
            }
            case field_11039: {
                matrices.method_22907(class_7833.field_40716.rotation(4.71239f));
                matrices.method_22904(0.15, 0.25 - (double)decayStage * 0.03, -0.99 + (double)pack.getSkullOffset());
                break;
            }
        }
        matrices.method_22907(class_7833.field_40714.rotation(0.872665f));
    }

    public static void renderSkull(GraveBlockEntity graveEntity, class_5599 modelLoader, int blockAge, class_4587 matrices, int light, class_4597 vertexConsumers) {
        GameProfile profile = null;
        SkullWrapper skullData = null;
        float yaw = Float.max(10.0f, (float)blockAge * 12.0f);
        if (graveEntity.getGraveOwner() != null) {
            profile = graveEntity.getGraveOwner();
            skullData = skulls.get(blockAge >= 2 ? "skeleton_skull" : "player_head");
        } else if (graveEntity.hasGraveSkull()) {
            class_2487 graveSkull = graveEntity.getGraveSkull();
            String graveSkullValue = graveSkull.method_10558("Value");
            if (skulls.containsKey(graveSkullValue)) {
                skullData = skulls.get(graveSkullValue);
            } else {
                profile = GraveSkullRenderer.getCustomSkullProfile(graveSkull);
                skullData = skulls.get("player_head");
            }
        }
        if (skullData != null) {
            class_5598 model = GraveSkullRenderer.getSkullModel(skullData.model(), modelLoader);
            class_1921 layer = GraveSkullRenderer.getSkullLayer(skullData.type(), profile);
            class_836.method_32161(null, (float)yaw, (float)0.0f, (class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_5598)model, (class_1921)layer);
        }
    }

    public static class_5598 getSkullModel(class_5601 model, class_5599 modelLoader) {
        class_607 skull = new class_607(modelLoader.method_32072(model));
        skull.method_2821(1.0f, 2.0f, 2.0f);
        return skull;
    }

    public static class_1921 getSkullLayer(class_2484.class_2485 skullType, @Nullable GameProfile profile) {
        return class_836.method_3578((class_2484.class_2485)skullType, (GameProfile)profile);
    }

    public static GameProfile getCustomSkullProfile(class_2487 graveSkull) {
        return class_2512.method_10683((class_2487)graveSkull);
    }

    public record SkullWrapper(class_2484.class_2485 type, class_5601 model) {
    }
}

