/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.decay;

import java.util.Optional;
import me.mgin.graves.Graves;
import me.mgin.graves.api.InventoriesApi;
import me.mgin.graves.block.GraveBlocks;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.config.GravesConfig;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public interface Decayable<T extends Enum<T>> {
    public Optional<class_2680> getDecayResultState(class_2680 var1);

    default public void tickDecay(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        float decayChance;
        GravesConfig config = GravesConfig.getConfig();
        if (config.decay.decayEnabled && (decayChance = (float)Decayable.getStageDecayChance(state, config) / 100.0f) >= random.method_43057()) {
            this.tryDecay(state, world, pos, random);
        }
    }

    public T getDecayStage();

    default public void tryDecay(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.getDecayResultState(state).ifPresent(statex -> Decayable.setDecayState((class_1937)world, pos, statex, true));
    }

    public static int getStageDecayChance(class_2680 state, GravesConfig config) {
        if (state.method_26204() == GraveBlocks.GRAVE) {
            return config.decay.freshGraveDecayChance;
        }
        if (state.method_26204() == GraveBlocks.GRAVE_OLD) {
            return config.decay.oldGraveDecayChance;
        }
        if (state.method_26204() == GraveBlocks.GRAVE_WEATHERED) {
            return config.decay.weatheredGraveDecayChance;
        }
        return 5;
    }

    public static float calculateItemDecayPercent(float healthPercent, float min, float max) {
        float steepness = 8.0f;
        float midpoint = 0.5f;
        float decayPercent = (float)(1.0 / (1.0 + Math.exp(-steepness * (healthPercent - midpoint))));
        return max - (min + (max - min) * decayPercent);
    }

    public static class_2371<class_1799> decayItems(class_2371<class_1799> items) {
        GravesConfig config = GravesConfig.getConfig();
        float modifier = (float)config.decay.decayModifier / 100.0f;
        boolean decayBreaksItems = config.decay.decayBreaksItems;
        if (modifier == 0.0f) {
            return items;
        }
        for (int i = 0; i < items.size(); ++i) {
            float unbreaking;
            float unbreakingModifier;
            float decayChance;
            float randomness;
            class_1799 item = (class_1799)items.get(i);
            int maxDamage = item.method_7936();
            int damage = item.method_7919();
            class_5819 random = class_5819.method_43047();
            if (maxDamage <= 0) continue;
            float itemHealthPercent = 1.0f - (float)damage / (float)maxDamage;
            float decayPercent = Decayable.calculateItemDecayPercent(itemHealthPercent, 0.0f, modifier);
            if (decayPercent + (randomness = (random.method_43057() - 0.5f) * 0.04f) >= 0.0f) {
                decayPercent += randomness;
            }
            if (!((decayChance = 0.35f * (unbreakingModifier = 100.0f / ((unbreaking = (float)class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)item)) + 1.0f) / 100.0f)) >= random.method_43057())) continue;
            int remainingDurability = maxDamage - damage;
            float decay = (float)remainingDurability * decayPercent;
            if ((float)remainingDurability - decay >= 1.0f) {
                item.method_7974((int)Math.ceil((float)damage + decay));
                continue;
            }
            if (decayBreaksItems) {
                items.set(i, (Object)class_1799.field_8037);
                continue;
            }
            item.method_7974(maxDamage - 1);
        }
        return items;
    }

    public static void setDecayState(class_1937 world, class_2338 pos, class_2680 state, boolean itemsDecay) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GraveBlockEntity) {
            GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
            world.method_8501(pos, state);
            for (InventoriesApi api : Graves.inventories) {
                String id = api.getID();
                class_2371<class_1799> inventory = graveEntity.getInventory(id);
                if (inventory == null) continue;
                graveEntity.setInventory(id, itemsDecay ? Decayable.decayItems(inventory) : inventory);
            }
            world.method_8438((class_2586)graveEntity);
        }
    }
}

