/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.video.element;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.element.elements.video.VideoElementController;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetVideoElementVolumeAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public SetVideoElementVolumeAction() {
        super("set_video_element_volume");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        try {
            if (value != null && value.contains(":")) {
                String id = value.split(":", 2)[0];
                String volString = value.split(":", 2)[1];
                if (MathUtils.isFloat((String)volString)) {
                    float volume = Math.min(1.0f, Math.max(0.0f, Float.parseFloat(volString)));
                    VideoElementController.VideoElementMeta meta = VideoElementController.getMeta(id);
                    if (meta == null) {
                        meta = new VideoElementController.VideoElementMeta(id, 1.0f, false);
                        VideoElementController.putMeta(id, meta);
                    }
                    if (meta.volume != volume) {
                        meta.volume = volume;
                        VideoElementController.putMeta(id, meta);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to execute SetVideoElementVolumeAction!", (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.video.set_video_element_volume");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.video.set_video_element_volume.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.video.set_video_element_volume.value.desc");
    }

    @Override
    public String getValueExample() {
        return "element_identifier:1.0";
    }
}

