/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees.mushroom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.TreeConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3468;

public class RedMushroomTree
implements TreeType {
    private static final class_2338[] CAP_SCAN_OFFSET = new class_2338[]{new class_2338(-1, 0, 0), new class_2338(1, 0, 0), new class_2338(0, 0, -1), new class_2338(0, 0, 1), new class_2338(-1, -1, 0), new class_2338(1, -1, 0), new class_2338(0, -1, -1), new class_2338(0, -1, 1)};

    @Override
    public boolean isTreeStem(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10556);
    }

    @Override
    public TreeData gatherTreeData(class_2338 blockPos, class_1937 level, class_1657 player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.method_6047())) {
            return null;
        }
        blockPos = blockPos.method_10062();
        TreeData.Builder builder = TreeData.builder();
        Set<class_2338> stemBlocks = this.gatherStemBlocks(level, blockPos);
        HashSet capBlocks = new HashSet();
        stemBlocks.forEach(stemPos -> capBlocks.addAll(this.gatherCapBlocks(level, stemPos.method_10084())));
        if (capBlocks.isEmpty()) {
            return null;
        }
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        blocks.addAll(stemBlocks);
        blocks.addAll(capBlocks);
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            for (class_2338 block : blocks) {
                class_2680 blockState = level.method_8320(block);
                List items = class_2248.method_9609((class_2680)blockState, (class_3218)serverLevel, (class_2338)block, null, (class_1297)player, (class_1799)player.method_6047());
                drops.addAll(items);
            }
        }
        return builder.addBlocks(blocks).setToolDamage(blocks.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)blocks.size()).addDrops(drops).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)blocks.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).addAwardedStats(blocks.stream().map(logPos -> {
            class_2680 blockState = level.method_8320(logPos);
            return class_3468.field_15427.method_14956((Object)blockState.method_26204());
        }).toList()).build();
    }

    private Set<class_2338> gatherStemBlocks(class_1937 level, class_2338 startPos) {
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        Stack<class_2338> toVisit = new Stack<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            class_2338 current = (class_2338)toVisit.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            if (!this.isTreeStem(currentState)) continue;
            blocks.add(current);
            class_2338 neighbor = current.method_10084();
            if (visited.contains(neighbor)) continue;
            toVisit.add(neighbor);
        }
        return blocks;
    }

    private Set<class_2338> gatherCapBlocks(class_1937 level, class_2338 startPos) {
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        LinkedList<BlockSearchNode> toVisit = new LinkedList<BlockSearchNode>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        toVisit.add(new BlockSearchNode(startPos, 1));
        while (!toVisit.isEmpty()) {
            BlockSearchNode node = (BlockSearchNode)toVisit.poll();
            class_2338 current = node.position();
            if (visited.contains(current) || node.distance() > 6) continue;
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            if (!currentState.method_27852(class_2246.field_10240)) continue;
            blocks.add(current);
            for (class_2338 offset : CAP_SCAN_OFFSET) {
                class_2338 neighbor = current.method_10081((class_2382)offset);
                if (visited.contains(neighbor)) continue;
                toVisit.add(new BlockSearchNode(neighbor, node.distance() + 1));
            }
        }
        return blocks;
    }

    public TreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.mushroomTree;
    }

    private record BlockSearchNode(class_2338 position, int distance) {
    }
}

