/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.ArrayList;
import java.util.List;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.VerticalTreeConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3468;

public class VerticalTree
implements TreeType {
    @Override
    public boolean isTreeStem(class_2680 blockState) {
        return this.getConfig().filter.isValid(blockState);
    }

    @Override
    public TreeData gatherTreeData(class_2338 blockPos, class_1937 level, class_1657 player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.method_6047())) {
            return null;
        }
        blockPos = blockPos.method_10062();
        TreeData.Builder builder = TreeData.builder();
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        this.gatherBlocks(level, blockPos, blocks);
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            for (class_2338 block : blocks) {
                class_2680 blockState = level.method_8320(block);
                List items = class_2248.method_9609((class_2680)blockState, (class_3218)serverLevel, (class_2338)block, null, (class_1297)player, (class_1799)player.method_6047());
                drops.addAll(items);
            }
        }
        return builder.addBlocks(blocks).setToolDamage(blocks.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)blocks.size()).addDrops(drops).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)blocks.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).addAwardedStats(blocks.stream().map(logPos -> {
            class_2680 blockState = level.method_8320(logPos);
            return class_3468.field_15427.method_14956((Object)blockState.method_26204());
        }).toList()).build();
    }

    private void gatherBlocks(class_1937 level, class_2338 blockPos, List<class_2338> blocks) {
        class_2680 blockState = level.method_8320(blockPos);
        blocks.add(blockPos);
        class_2338 neighborPos = blockPos.method_10084();
        if (level.method_8320(neighborPos).method_27852(blockState.method_26204())) {
            this.gatherBlocks(level, neighborPos, blocks);
        }
    }

    public VerticalTreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.verticalTree;
    }
}

