/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.TreeConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3468;

public class ChorusTree
implements TreeType {
    private static final class_2350[] HORIZONTAL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    @Override
    public boolean isTreeStem(class_2680 blockState) {
        return ChorusTree.isPlant(blockState);
    }

    private static boolean isPlant(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10021);
    }

    private static boolean isFlower(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10528);
    }

    @Override
    public TreeData gatherTreeData(class_2338 blockPos, class_1937 level, class_1657 player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.method_6047())) {
            return null;
        }
        blockPos = blockPos.method_10062();
        TreeData.Builder builder = TreeData.builder();
        Set<class_2338> blockPosSet = this.gatherBlocks(level, blockPos, builder, player);
        return builder.addBlocks(blockPosSet).setToolDamage(blockPosSet.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)blockPosSet.size()).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)blockPosSet.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).build();
    }

    private Set<class_2338> gatherBlocks(class_1937 level, class_2338 startPos, TreeData.Builder builder, class_1657 player) {
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        LinkedList<class_2338> toVisit = new LinkedList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            class_2338 current = (class_2338)toVisit.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            if (ChorusTree.isFlower(currentState)) {
                blocks.add(current);
                continue;
            }
            if (!ChorusTree.isPlant(currentState)) continue;
            blocks.add(current);
            builder.addAwardedStat(class_3468.field_15427.method_14956((Object)currentState.method_26204()));
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                builder.addDrops(class_2248.method_9609((class_2680)currentState, (class_3218)serverLevel, (class_2338)current, null, (class_1297)player, (class_1799)player.method_6047()));
            }
            for (class_2338 neighbor : ChorusTree.gatherValidBlocksAround(level, current)) {
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return blocks;
    }

    private static List<class_2338> gatherValidBlocksAround(class_1937 level, class_2338 blockPos) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        for (class_2350 direction : HORIZONTAL_DIRECTIONS) {
            class_2680 blockState;
            class_2338 neighborPos = blockPos.method_10093(direction);
            if (ChorusTree.isPlant(level.method_8320(neighborPos.method_10074())) || !ChorusTree.isPlant(blockState = level.method_8320(neighborPos)) && !ChorusTree.isFlower(blockState)) continue;
            blocks.add(neighborPos);
        }
        class_2338 neighborPos = blockPos.method_10084();
        class_2680 blockState = level.method_8320(neighborPos);
        if (ChorusTree.isPlant(blockState) || ChorusTree.isFlower(blockState)) {
            blocks.add(neighborPos);
        }
        return blocks;
    }

    public TreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.chorusTree;
    }
}

