/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.registry;

import com.mojang.serialization.Lifecycle;
import me.pandamods.fallingtrees.FallingTrees;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.TreeConfigs;
import me.pandamods.fallingtrees.trees.ChorusTree;
import me.pandamods.fallingtrees.trees.GenericTree;
import me.pandamods.fallingtrees.trees.VerticalTree;
import me.pandamods.fallingtrees.trees.mushroom.MushroomTree;
import me.pandamods.pandalib.registry.DeferredObject;
import me.pandamods.pandalib.registry.DeferredRegister;
import me.pandamods.pandalib.registry.RegistryRegister;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class TreeRegistry {
    public static final class_5321<class_2378<TreeType>> TREE_REGISTRY_KEY = class_5321.method_29180((class_2960)FallingTrees.ID("tree_registry"));
    public static final class_2378<TreeType> TREE_REGISTRY = RegistryRegister.register((class_2378)new class_2370(TREE_REGISTRY_KEY, Lifecycle.stable()));
    public static final DeferredRegister<TreeType> TREES = DeferredRegister.create((String)"fallingtrees", TREE_REGISTRY_KEY);
    public static DeferredObject<GenericTree> GENERIC;
    public static DeferredObject<VerticalTree> VERTICAL;
    public static DeferredObject<ChorusTree> CHORUS;
    public static DeferredObject<MushroomTree> MUSHROOM;

    public static TreeType getTree(class_2680 blockState) {
        for (TreeType tree : TREE_REGISTRY) {
            if (!tree.isTreeStem(blockState)) continue;
            return tree;
        }
        return null;
    }

    public static TreeType getTree(class_2960 resourceLocation) {
        return (TreeType)TREE_REGISTRY.method_10223(resourceLocation);
    }

    public static class_2960 getTreeLocation(TreeType tree) {
        return TREE_REGISTRY.method_10221((Object)tree);
    }

    static {
        TreeConfigs treeConfigs = FallingTreesConfig.getCommonConfig().trees;
        if (treeConfigs.genericTree.enabled) {
            GENERIC = TREES.register("generic", GenericTree::new);
        }
        if (treeConfigs.verticalTree.enabled) {
            VERTICAL = TREES.register("vertical", VerticalTree::new);
        }
        if (treeConfigs.chorusTree.enabled) {
            CHORUS = TREES.register("chorus", ChorusTree::new);
        }
        if (treeConfigs.mushroomTree.enabled) {
            MUSHROOM = TREES.register("mushroom", MushroomTree::new);
        }
    }
}

