/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3445;

public record TreeData(List<class_2338> blocks, List<class_1799> drops, List<AwardedStat> awardedStats, int toolDamage, MiningSpeedModifier miningSpeedModifier, FoodExhaustionModifier foodExhaustionModifier) {
    public static Builder builder() {
        return new Builder();
    }

    public static interface MiningSpeedModifier {
        public float getMiningSpeed(float var1);
    }

    public static interface FoodExhaustionModifier {
        public float getExhaustion(float var1);
    }

    public static class Builder {
        private final List<class_2338> blocks = new ArrayList<class_2338>();
        private final List<class_2338> viewBlocks = Collections.unmodifiableList(this.blocks);
        private final List<class_1799> drops = new ArrayList<class_1799>();
        private final List<class_1799> viewDrops = Collections.unmodifiableList(this.drops);
        private final Map<class_3445<?>, Integer> awardedStats = new HashMap();
        private int toolDamage = 0;
        private MiningSpeedModifier miningSpeedModifier = originalMiningSpeed -> originalMiningSpeed;
        private FoodExhaustionModifier foodExhaustionModifier = originalExhaustion -> originalExhaustion;

        private Builder() {
        }

        public Builder addBlock(class_2338 blockPos) {
            this.blocks.add(blockPos);
            return this;
        }

        public Builder addBlocks(class_2338 blockPos, class_2338 ... otherBlocks) {
            this.blocks.add(blockPos);
            this.blocks.addAll(Arrays.asList(otherBlocks));
            return this;
        }

        public Builder addBlocks(Collection<class_2338> blocks) {
            this.blocks.addAll(blocks);
            return this;
        }

        public Builder addDrop(class_1799 drop) {
            this.drops.add(drop);
            return this;
        }

        public Builder addDrops(class_1799 drop, class_1799 ... otherDrops) {
            this.drops.add(drop);
            this.drops.addAll(Arrays.asList(otherDrops));
            return this;
        }

        public Builder addDrops(Collection<class_1799> drops) {
            this.drops.addAll(drops);
            return this;
        }

        public Builder addAwardedStat(class_3445<?> stat) {
            return this.addAwardedStat(stat, 1);
        }

        public Builder addAwardedStat(class_3445<?> stat, int amount) {
            this.awardedStats.compute(stat, (stat1, oldAmount) -> oldAmount == null ? amount : oldAmount + amount);
            return this;
        }

        public <T> Builder addAwardedStats(Collection<class_3445<T>> stats) {
            stats.forEach(this::addAwardedStat);
            return this;
        }

        public Builder addAwardedStatsMap(Map<class_3445<?>, Integer> stats) {
            this.awardedStats.putAll(stats);
            return this;
        }

        public Builder setToolDamage(int toolDamage) {
            this.toolDamage = toolDamage;
            return this;
        }

        public Builder setMiningSpeedModifier(MiningSpeedModifier miningSpeedModifier) {
            this.miningSpeedModifier = miningSpeedModifier;
            return this;
        }

        public Builder setFoodExhaustionModifier(FoodExhaustionModifier foodExhaustionModifier) {
            this.foodExhaustionModifier = foodExhaustionModifier;
            return this;
        }

        public TreeData build() {
            return new TreeData(this.viewBlocks, this.viewDrops, this.awardedStats.entrySet().stream().map(entry -> new AwardedStat((class_3445)entry.getKey(), (Integer)entry.getValue())).toList(), this.toolDamage, this.miningSpeedModifier, this.foodExhaustionModifier);
        }
    }

    public record AwardedStat(class_3445<?> stat, int amount) {
    }
}

