/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasonsextras.patchouli;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.resources.CropConfigs;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasonsextras.client.FabricSeasonsExtrasClient;
import io.github.lucaargolo.seasonsextras.patchouli.FabricSeasonsExtrasPatchouliCompat;
import io.github.lucaargolo.seasonsextras.patchouli.PatchouliModifications;
import io.github.lucaargolo.seasonsextras.patchouli.mixin.GuiBookEntryAccessor;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageBiomeDescription;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageBiomeSearch;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageCropSearch;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageMultipleCrafting;
import io.github.lucaargolo.seasonsextras.patchouli.page.PageSeasonalBiome;
import io.github.lucaargolo.seasonsextras.utils.ModIdentifier;
import io.github.lucaargolo.seasonsextras.utils.Tickable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.text.BookTextParser;

public class FabricSeasonsExtrasPatchouliCompatClient {
    public static HashMap<class_2960, JsonObject> multiblocks = new HashMap();
    public static class_5321<class_1959> multiblockBiomeOverride = null;
    public static Season multiblockSeasonOverride = null;
    public static final HashMap<class_5321<class_1937>, Set<class_6880<class_1959>>> worldValidBiomes = new HashMap();
    public static final HashMap<class_5321<class_1937>, HashMap<class_2960, Set<class_2960>>> worldBiomeMultiblocks = new HashMap();

    public static void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasonsExtrasPatchouliCompat.SEND_VALID_BIOMES_S2C, (client, handler, buf, responseSender) -> {
            HashSet<class_2960> validBiomes = new HashSet<class_2960>();
            class_2960 worldId = buf.method_10810();
            class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldId);
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                validBiomes.add(buf.method_10810());
            }
            client.execute(() -> {
                worldValidBiomes.computeIfPresent((class_5321<class_1937>)worldKey, (key, list) -> new LinkedHashSet());
                validBiomes.stream().sorted(Comparator.comparing(class_2960::method_12832)).forEach(biome -> handler.method_29091().method_30530(class_7924.field_41236).method_40264(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biome)).ifPresent(entry -> worldValidBiomes.computeIfAbsent((class_5321<class_1937>)worldKey, key -> new LinkedHashSet()).add(entry)));
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasonsExtrasPatchouliCompat.SEND_BIOME_MULTIBLOCKS_S2C, (client, handler, buf, responseSender) -> {
            HashMap biomeMultiblocks = new HashMap();
            class_2960 worldId = buf.method_10810();
            class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldId);
            int mapSize = buf.readInt();
            for (int m = 0; m < mapSize; ++m) {
                HashSet<class_2960> set = new HashSet<class_2960>();
                class_2960 biomeId = buf.method_10810();
                int setSize = buf.readInt();
                for (int s = 0; s < setSize; ++s) {
                    set.add(buf.method_10810());
                }
                biomeMultiblocks.put(biomeId, set);
            }
            client.execute(() -> worldBiomeMultiblocks.put((class_5321<class_1937>)worldKey, biomeMultiblocks));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricSeasonsExtrasPatchouliCompat.SEND_MULTIBLOCKS_S2C, (client, handler, buf, responseSender) -> {
            HashMap<class_2960, JsonObject> serverMultiblocks = new HashMap<class_2960, JsonObject>();
            int size = buf.readInt();
            for (int m = 0; m < size; ++m) {
                serverMultiblocks.put(buf.method_10810(), JsonParser.parseString((String)buf.method_19772()).getAsJsonObject());
            }
            client.execute(() -> {
                multiblocks = serverMultiblocks;
            });
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1755 == null) {
                multiblockBiomeOverride = null;
                multiblockSeasonOverride = null;
            } else {
                class_437 patt4871$temp = client.field_1755;
                if (patt4871$temp instanceof GuiBookEntryAccessor) {
                    BookPage patt5098$temp;
                    Tickable page;
                    GuiBookEntryAccessor bookEntry = (GuiBookEntryAccessor)patt4871$temp;
                    BookPage patt4963$temp = bookEntry.getLeftPage();
                    if (patt4963$temp instanceof Tickable) {
                        page = (Tickable)patt4963$temp;
                        page.tick();
                    }
                    if ((patt5098$temp = bookEntry.getRightPage()) instanceof Tickable) {
                        page = (Tickable)patt5098$temp;
                        page.tick();
                    }
                }
            }
        });
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("biome_search"), PageBiomeSearch.class);
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("seasonal_biome"), PageSeasonalBiome.class);
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("biome_description"), PageBiomeDescription.class);
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("crop_search"), PageCropSearch.class);
        ClientBookRegistry.INSTANCE.pageTypes.put(new ModIdentifier("multiple_crafting"), PageMultipleCrafting.class);
        BookTextParser.register((parameter, state) -> FabricSeasonsExtrasClient.prefersCelsius ? FabricSeasonsExtrasClient.minecraftToCelsius(parameter) : FabricSeasonsExtrasClient.minecraftToFahrenheit(parameter), (String[])new String[]{"seasonsextrastemperature"});
        BookTextParser.register((parameter, state) -> class_1074.method_4662((String)parameter, (Object[])new Object[0]), (String[])new String[]{"seasonsextrastranslate"});
        PatchouliModifications.registerEntry(new ModIdentifier("biomes"), new ModIdentifier("seasonal_biomes"), (pages, index) -> {
            class_310 client = class_310.method_1551();
            class_638 world = client.field_1687;
            if (world != null) {
                class_5321 worldKey = world.method_27983();
                AtomicInteger offset = new AtomicInteger(0);
                ((Set)worldValidBiomes.getOrDefault(worldKey, new HashSet())).forEach(entry -> FabricSeasonsExtrasPatchouliCompatClient.addSeasonalBiomePage(pages, index + offset.getAndAdd(2), (class_5321<class_1937>)worldKey, (class_6880<class_1959>)entry));
            }
        });
        PatchouliModifications.registerEntry(new ModIdentifier("crops"), new ModIdentifier("seasonal_crops"), (pages, index) -> {
            class_310 client = class_310.method_1551();
            class_638 world = client.field_1687;
            if (world != null) {
                AtomicInteger offset = new AtomicInteger(0);
                FabricSeasons.SEEDS_MAP.entrySet().stream().map(entry -> Map.entry(entry, class_7923.field_41175.method_10221((Object)((class_2248)entry.getValue())))).sorted(Map.Entry.comparingByValue()).forEach(entry -> {
                    class_2960 seedId = class_7923.field_41178.method_10221((Object)((class_1792)((Map.Entry)entry.getKey()).getKey()));
                    class_2960 cropId = class_7923.field_41175.method_10221((Object)((class_2248)((Map.Entry)entry.getKey()).getValue()));
                    FabricSeasonsExtrasPatchouliCompatClient.addSeasonalCropPage(pages, index + offset.getAndAdd(1), (class_1792)((Map.Entry)entry.getKey()).getKey(), seedId, (class_2248)((Map.Entry)entry.getKey()).getValue(), cropId);
                });
            }
        });
    }

    private static void addSeasonalBiomePage(JsonArray pages, int index, class_5321<class_1937> worldKey, class_6880<class_1959> entry) {
        class_1959 biome = (class_1959)entry.comp_349();
        class_2960 biomeId = entry.method_40230().orElse(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)new class_2960("plains"))).method_29177();
        String biomeName = biomeId.method_42093("biome");
        class_3545 springPair = FabricSeasons.getSeasonWeather((Season)Season.SPRING, (class_2960)biomeId, (Boolean)biome.method_48163(), (float)biome.method_8712());
        class_3545 summerPair = FabricSeasons.getSeasonWeather((Season)Season.SUMMER, (class_2960)biomeId, (Boolean)biome.method_48163(), (float)biome.method_8712());
        class_3545 fallPair = FabricSeasons.getSeasonWeather((Season)Season.FALL, (class_2960)biomeId, (Boolean)biome.method_48163(), (float)biome.method_8712());
        class_3545 winterPair = FabricSeasons.getSeasonWeather((Season)Season.WINTER, (class_2960)biomeId, (Boolean)biome.method_48163(), (float)biome.method_8712());
        ArrayList<Season> rainSeasons = new ArrayList<Season>();
        ArrayList<Season> snowSeasons = new ArrayList<Season>();
        if (((Boolean)springPair.method_15442()).booleanValue()) {
            if (((Float)springPair.method_15441()).floatValue() < 0.15f) {
                snowSeasons.add(Season.SPRING);
            } else {
                rainSeasons.add(Season.SPRING);
            }
        }
        if (((Boolean)summerPair.method_15442()).booleanValue()) {
            if (((Float)springPair.method_15441()).floatValue() < 0.15f) {
                snowSeasons.add(Season.SUMMER);
            } else {
                rainSeasons.add(Season.SUMMER);
            }
        }
        if (((Boolean)fallPair.method_15442()).booleanValue()) {
            if (((Float)springPair.method_15441()).floatValue() < 0.15f) {
                snowSeasons.add(Season.FALL);
            } else {
                rainSeasons.add(Season.FALL);
            }
        }
        if (((Boolean)winterPair.method_15442()).booleanValue()) {
            if (((Float)springPair.method_15441()).floatValue() < 0.15f) {
                snowSeasons.add(Season.WINTER);
            } else {
                rainSeasons.add(Season.WINTER);
            }
        }
        String springTemperature = "$(seasonsextrastemperature:" + springPair.method_15441() + ")";
        String summerTemperature = "$(seasonsextrastemperature:" + summerPair.method_15441() + ")";
        String fallTemperature = "$(seasonsextrastemperature:" + fallPair.method_15441() + ")";
        String winterTemperature = "$(seasonsextrastemperature:" + winterPair.method_15441() + ")";
        StringBuilder rainInfo = new StringBuilder(rainSeasons.isEmpty() ? "$(seasonsextrastranslate:patchouli.seasonsextras.doesnotrain)" : "$(seasonsextrastranslate:patchouli.seasonsextras.rainsduring) ");
        if (rainSeasons.size() == 4) {
            rainInfo.append("$(seasonsextrastranslate:patchouli.seasonsextras.all_seasons)");
        } else {
            for (int i = 0; i < rainSeasons.size(); ++i) {
                Season season = (Season)rainSeasons.get(i);
                rainInfo.append("$(").append(season.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(season.getTranslationKey()).append(")");
                if (i == rainSeasons.size() - 1) {
                    rainInfo.append("$(0).");
                    continue;
                }
                if (i == rainSeasons.size() - 2) {
                    rainInfo.append("$(0) ").append("$(seasonsextrastranslate:patchouli.seasonsextras.and)").append(" ");
                    continue;
                }
                rainInfo.append("$(0), ");
            }
        }
        StringBuilder snowInfo = new StringBuilder(snowSeasons.isEmpty() ? "$(seasonsextrastranslate:patchouli.seasonsextras.doesnotsnow)" : "$(seasonsextrastranslate:patchouli.seasonsextras.snowsduring) ");
        if (snowSeasons.size() == 4) {
            snowInfo.append("$(seasonsextrastranslate:patchouli.seasonsextras.all_seasons)");
        } else {
            for (int i = 0; i < snowSeasons.size(); ++i) {
                Season season = (Season)snowSeasons.get(i);
                snowInfo.append("$(").append(season.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(season.getTranslationKey()).append(")");
                if (i == snowSeasons.size() - 1) {
                    snowInfo.append("$(0).");
                    continue;
                }
                if (i == snowSeasons.size() - 2) {
                    snowInfo.append("$(0) ").append("$(seasonsextrastranslate:patchouli.seasonsextras.and)").append(" ");
                    continue;
                }
                snowInfo.append("$(0), ");
            }
        }
        String biomeInfo = (double)((Float)springPair.method_15441()).floatValue() <= 0.1 ? "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(3)$(seasonsextrastranslate:patchouli.seasonsextras.frozenbiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.frozendesc)" : ((double)((Float)springPair.method_15441()).floatValue() <= 0.3 ? "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(3)$(seasonsextrastranslate:patchouli.seasonsextras.coldbiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.colddesc)" : ((double)((Float)springPair.method_15441()).floatValue() <= 0.95 ? "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(2)$(seasonsextrastranslate:patchouli.seasonsextras.temperatebiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.temperatedesc)" : "$(seasonsextrastranslate:patchouli.seasonsextras.thisisabiome) $(4)$(seasonsextrastranslate:patchouli.seasonsextras.hotbiome)$(0). $(seasonsextrastranslate:patchouli.seasonsextras.hotdesc)"));
        JsonObject biomeFirstPage = new JsonObject();
        biomeFirstPage.add("type", (JsonElement)new JsonPrimitive("seasonsextras:biome_description"));
        biomeFirstPage.add("title", (JsonElement)new JsonPrimitive(biomeName));
        String biomeText = biomeInfo + "$(br2)$(2)$(seasonsextrastranslate:patchouli.seasonsextras.springtemp): $(0)" + springTemperature + "$(br)$(6)$(seasonsextrastranslate:patchouli.seasonsextras.summertemp): $(0)" + summerTemperature + "$(br)$(c)$(seasonsextrastranslate:patchouli.seasonsextras.falltemp): $(0)" + fallTemperature + "$(br)$(3)$(seasonsextrastranslate:patchouli.seasonsextras.wintertemp): $(0)" + winterTemperature + "$(br2)" + rainInfo + "$(br2)" + snowInfo;
        biomeFirstPage.add("text", (JsonElement)new JsonPrimitive(biomeText));
        biomeFirstPage.add("anchor", (JsonElement)new JsonPrimitive(biomeId.toString()));
        JsonObject biomeSecondPage = new JsonObject();
        biomeSecondPage.add("type", (JsonElement)new JsonPrimitive("seasonsextras:seasonal_biome"));
        biomeSecondPage.add("name", (JsonElement)new JsonPrimitive("Colors"));
        biomeSecondPage.add("enable_visualize", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        biomeSecondPage.add("biome_id", (JsonElement)new JsonPrimitive(biomeId.toString()));
        if (worldBiomeMultiblocks.getOrDefault(worldKey, new HashMap()).containsKey(biomeId)) {
            JsonArray mbs = new JsonArray();
            ((Set)worldBiomeMultiblocks.getOrDefault(worldKey, new HashMap()).get(biomeId)).forEach(treeId -> {
                JsonObject multiblock = multiblocks.get(treeId);
                if (multiblock != null && multiblock.size() > 0) {
                    mbs.add((JsonElement)multiblock);
                }
            });
            biomeSecondPage.add("multiblocks", (JsonElement)mbs);
        }
        JsonArray oldPages = pages.deepCopy();
        FabricSeasonsExtrasPatchouliCompatClient.setOrAdd(pages, index, (JsonElement)biomeFirstPage);
        FabricSeasonsExtrasPatchouliCompatClient.setOrAdd(pages, index + 1, (JsonElement)biomeSecondPage);
        for (int i = index; i < oldPages.size(); ++i) {
            FabricSeasonsExtrasPatchouliCompatClient.setOrAdd(pages, index + 2 + (i - index), oldPages.get(i));
        }
    }

    private static void addSeasonalCropPage(JsonArray pages, int index, class_1792 seed, class_2960 seedId, class_2248 crop, class_2960 cropId) {
        float springMultiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)Season.SPRING);
        float summerMultiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)Season.SUMMER);
        float fallMultiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)Season.FALL);
        float winterMultiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)Season.WINTER);
        float maxMultiplier = Math.max(Math.max(springMultiplier, summerMultiplier), Math.max(fallMultiplier, winterMultiplier));
        ArrayList<Season> cropSeasons = new ArrayList<Season>();
        ArrayList<Season> alternateSeasons = new ArrayList<Season>();
        if (springMultiplier == maxMultiplier) {
            cropSeasons.add(Season.SPRING);
        } else {
            alternateSeasons.add(Season.SPRING);
        }
        if (summerMultiplier == maxMultiplier) {
            cropSeasons.add(Season.SUMMER);
        } else {
            alternateSeasons.add(Season.SUMMER);
        }
        if (fallMultiplier == maxMultiplier) {
            cropSeasons.add(Season.FALL);
        } else {
            alternateSeasons.add(Season.FALL);
        }
        if (winterMultiplier == maxMultiplier) {
            cropSeasons.add(Season.WINTER);
        } else {
            alternateSeasons.add(Season.WINTER);
        }
        StringBuilder cropText = new StringBuilder("$(seasonsextrastranslate:patchouli.seasonsextras.thisisacrop) ");
        for (int i = 0; i < cropSeasons.size(); ++i) {
            Season season = (Season)cropSeasons.get(i);
            cropText.append("$(").append(season.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(season.getTranslationKey()).append(")");
            if (i == cropSeasons.size() - 1) {
                cropText.append("$(0) $(seasonsextrastranslate:patchouli.seasonsextras.crop). ");
                continue;
            }
            if (i == cropSeasons.size() - 2) {
                cropText.append("$(0) ").append("$(seasonsextrastranslate:patchouli.seasonsextras.and)").append(" ");
                continue;
            }
            cropText.append("$(0), ");
        }
        if (cropSeasons.size() == 1) {
            cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.growsfasterduringthis)$(br2)");
        } else {
            cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.growsfasterduringthese)$(br2)");
        }
        for (Season season : alternateSeasons) {
            float multiplier = CropConfigs.getSeasonCropMultiplier((class_2960)cropId, (Season)season);
            if (multiplier == 0.0f) {
                cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.notgrowduring) ");
            } else if (multiplier < 1.0f) {
                cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.slowedgrowduring) ");
            } else if (multiplier == 1.0f) {
                cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.normalgrowduring) ");
            } else {
                cropText.append("$(seasonsextrastranslate:patchouli.seasonsextras.fastergrowduring) ");
            }
            cropText.append("$(").append(season.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(season.getTranslationKey()).append(")$(0)");
            cropText.append("$(br)");
        }
        cropText.append("$(br)");
        cropText.append("$(").append(Season.SPRING.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(Season.SPRING.getTranslationKey()).append(")$(0): ").append(springMultiplier).append("x $(seasonsextrastranslate:patchouli.seasonsextras.multiplier)$(br)");
        cropText.append("$(").append(Season.SUMMER.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(Season.SUMMER.getTranslationKey()).append(")$(0): ").append(summerMultiplier).append("x $(seasonsextrastranslate:patchouli.seasonsextras.multiplier)$(br)");
        cropText.append("$(").append(Season.FALL.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(Season.FALL.getTranslationKey()).append(")$(0): ").append(fallMultiplier).append("x $(seasonsextrastranslate:patchouli.seasonsextras.multiplier)$(br)");
        cropText.append("$(").append(Season.WINTER.getDarkFormatting().method_36145()).append(")$(seasonsextrastranslate:").append(Season.WINTER.getTranslationKey()).append(")$(0): ").append(winterMultiplier).append("x $(seasonsextrastranslate:patchouli.seasonsextras.multiplier)$(br)");
        JsonObject biomeFirstPage = new JsonObject();
        biomeFirstPage.add("type", (JsonElement)new JsonPrimitive("patchouli:spotlight"));
        biomeFirstPage.add("item", (JsonElement)new JsonPrimitive(seedId.toString()));
        biomeFirstPage.add("title", (JsonElement)new JsonPrimitive(crop.method_9539()));
        biomeFirstPage.add("text", (JsonElement)new JsonPrimitive(cropText.toString()));
        biomeFirstPage.add("anchor", (JsonElement)new JsonPrimitive(cropId.toString()));
        JsonArray oldPages = pages.deepCopy();
        FabricSeasonsExtrasPatchouliCompatClient.setOrAdd(pages, index, (JsonElement)biomeFirstPage);
        for (int i = index; i < oldPages.size(); ++i) {
            FabricSeasonsExtrasPatchouliCompatClient.setOrAdd(pages, index + 1 + (i - index), oldPages.get(i));
        }
    }

    private static void setOrAdd(JsonArray array, int index, JsonElement element) {
        if (index == array.size()) {
            array.add(element);
        } else {
            array.set(index, element);
        }
    }
}

