/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.utils;

import io.github.lucaargolo.seasons.utils.Season;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ModConfig {
    private Season startingSeason = Season.SPRING;
    private SeasonLength seasonLength = new SeasonLength();
    private SeasonLock seasonLock = new SeasonLock();
    private List<String> dimensionAllowlist = List.of("minecraft:overworld");
    private boolean doTemperatureChanges = true;
    private boolean shouldSnowReplaceVegetation = true;
    private boolean shouldSnowyBiomesMeltInSummer = true;
    private boolean shouldIceNearWaterMelt = false;
    private boolean shouldIceBreakSugarCane = false;
    private List<String> biomeDenylist = List.of("terralith:glacial_chasm", "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean", "minecraft:ocean", "minecraft:deep_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:warm_ocean");
    private List<String> biomeForceSnowInWinterList = List.of("minecraft:plains", "minecraft:sunflower_plains", "minecraft:stony_peaks");
    private boolean isSeasonTiedWithSystemTime = false;
    private boolean isInNorthHemisphere = true;
    private boolean isFallAndSpringReversed = false;
    private boolean isSeasonMessingCrops = true;
    private boolean isSeasonMessingBonemeal = false;
    private boolean doCropsGrowsNormallyUnderground = false;
    private boolean doAnimalsBreedInWinter = true;
    private boolean notifyCompat = true;
    private boolean debugCommandEnabled = false;

    public boolean shouldNotifyCompat() {
        return this.notifyCompat;
    }

    public boolean doAnimalsBreedInWinter() {
        return this.doAnimalsBreedInWinter;
    }

    public boolean isSeasonMessingCrops() {
        return this.isSeasonMessingCrops;
    }

    public boolean isSeasonMessingBonemeal() {
        return this.isSeasonMessingBonemeal;
    }

    public boolean doCropsGrowsNormallyUnderground() {
        return this.doCropsGrowsNormallyUnderground;
    }

    public boolean doTemperatureChanges(class_2960 biomeId) {
        return this.doTemperatureChanges && !this.biomeDenylist.contains(biomeId.toString());
    }

    public boolean isSnowForcedInBiome(class_2960 biomeId) {
        return this.biomeForceSnowInWinterList.contains(biomeId.toString());
    }

    public boolean shouldSnowReplaceVegetation() {
        return this.shouldSnowReplaceVegetation;
    }

    public boolean shouldSnowyBiomesMeltInSummer() {
        return this.shouldSnowyBiomesMeltInSummer;
    }

    public boolean shouldIceNearWaterMelt() {
        return this.shouldIceNearWaterMelt;
    }

    public boolean shouldIceBreakSugarCane() {
        return this.shouldIceBreakSugarCane;
    }

    public int getSpringLength() {
        return this.seasonLength.springLength;
    }

    public int getSummerLength() {
        return this.seasonLength.summerLength;
    }

    public int getFallLength() {
        return this.seasonLength.fallLength;
    }

    public int getWinterLength() {
        return this.seasonLength.winterLength;
    }

    public int getYearLength() {
        return this.seasonLength.springLength + this.seasonLength.summerLength + this.seasonLength.fallLength + this.seasonLength.winterLength;
    }

    @Deprecated
    public int getSeasonLength() {
        return this.getSpringLength();
    }

    public boolean isSeasonLocked() {
        return this.seasonLock.isSeasonLocked;
    }

    public Season getLockedSeason() {
        return this.seasonLock.lockedSeason;
    }

    public Season getStartingSeason() {
        return this.startingSeason;
    }

    public boolean isValidStartingSeason() {
        return switch (this.startingSeason) {
            case Season.SPRING -> true;
            case Season.SUMMER -> true;
            case Season.FALL -> true;
            case Season.WINTER -> true;
            default -> false;
        };
    }

    public boolean isValidInDimension(class_5321<class_1937> dimension) {
        return this.dimensionAllowlist.contains(dimension.method_29177().toString());
    }

    public boolean isSeasonTiedWithSystemTime() {
        return this.isSeasonTiedWithSystemTime;
    }

    public boolean isInNorthHemisphere() {
        return this.isInNorthHemisphere;
    }

    public boolean isFallAndSpringReversed() {
        return this.isFallAndSpringReversed;
    }

    public boolean isDebugCommandEnabled() {
        return this.debugCommandEnabled;
    }

    private static class SeasonLength {
        private int springLength = 672000;
        private int summerLength = 672000;
        private int fallLength = 672000;
        private int winterLength = 672000;

        private SeasonLength() {
        }
    }

    private static class SeasonLock {
        private boolean isSeasonLocked = false;
        private Season lockedSeason = Season.SPRING;

        private SeasonLock() {
        }
    }
}

