/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import io.github.lucaargolo.seasons.commands.SeasonCommand;
import io.github.lucaargolo.seasons.mixed.BiomeMixed;
import io.github.lucaargolo.seasons.resources.CropConfigs;
import io.github.lucaargolo.seasons.utils.GreenhouseCache;
import io.github.lucaargolo.seasons.utils.ModConfig;
import io.github.lucaargolo.seasons.utils.ModIdentifier;
import io.github.lucaargolo.seasons.utils.PlacedMeltablesState;
import io.github.lucaargolo.seasons.utils.ReplacedMeltablesState;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasons.utils.SeasonalFertilizable;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricSeasons
implements ModInitializer {
    private static final LongArraySet temporaryMeltableCache = new LongArraySet();
    public static final String MOD_ID = "seasons";
    public static final String MOD_NAME = "Fabric Seasons";
    public static final Logger LOGGER = LogManager.getLogger((String)"Fabric Seasons");
    public static ModConfig CONFIG;
    public static final Gson GSON;
    public static HashMap<class_1792, class_2248> SEEDS_MAP;
    public static class_2960 ASK_FOR_CONFIG;
    public static class_2960 ANSWER_CONFIG;
    public static class_2960 UPDATE_CROPS;
    private static final class_6862<class_1959> IGNORED_CATEGORIES_TAG;

    public void onInitialize() {
        block10: {
            Path configPath = FabricLoader.getInstance().getConfigDir();
            File configFile = new File(configPath + File.separator + "seasons.json");
            LOGGER.info("[Fabric Seasons] Trying to read config file...");
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("[Fabric Seasons] No config file found, creating a new one...");
                    String json = GSON.toJson(JsonParser.parseString((String)GSON.toJson((Object)new ModConfig())));
                    try (PrintWriter out = new PrintWriter(configFile);){
                        out.println(json);
                    }
                    CONFIG = new ModConfig();
                    LOGGER.info("[Fabric Seasons] Successfully created default config file.");
                    break block10;
                }
                LOGGER.info("[Fabric Seasons] A config file was found, loading it..");
                CONFIG = (ModConfig)GSON.fromJson(new String(Files.readAllBytes(configFile.toPath())), ModConfig.class);
                if (CONFIG == null) {
                    throw new NullPointerException("[Fabric Seasons] The config file was empty.");
                }
                LOGGER.info("[Fabric Seasons] Successfully loaded config file.");
            }
            catch (Exception exception) {
                LOGGER.error("[Fabric Seasons] There was an error creating/loading the config file!", (Throwable)exception);
                CONFIG = new ModConfig();
                LOGGER.warn("[Fabric Seasons] Defaulting to original config.");
            }
        }
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, ignored) -> SeasonCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SEEDS_MAP.clear();
            class_7923.field_41178.forEach(item -> {
                class_2248 block;
                if (item instanceof class_1747 && (block = ((class_1747)item).method_7711()) instanceof SeasonalFertilizable) {
                    SEEDS_MAP.put((class_1792)item, ((class_1747)item).method_7711());
                }
            });
        });
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> {
            class_2540 buf = PacketByteBufs.create();
            CropConfigs.getDefaultCropConfig().toBuf(buf);
            CropConfigs.toBuf(buf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)UPDATE_CROPS, (class_2540)buf);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            GreenhouseCache.tick(server);
            temporaryMeltableCache.clear();
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ASK_FOR_CONFIG, (server, player, handler, buf, responseSender) -> {
            String configJson = GSON.toJson(JsonParser.parseString((String)GSON.toJson((Object)CONFIG)));
            class_2540 configBuf = PacketByteBufs.create();
            configBuf.method_10814(configJson);
            ServerPlayNetworking.send((class_3222)player, (class_2960)ANSWER_CONFIG, (class_2540)configBuf);
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new CropConfigs());
    }

    public static void setMeltable(class_2338 blockPos) {
        temporaryMeltableCache.add(blockPos.method_10063());
    }

    public static boolean isMeltable(class_2338 blockPos) {
        return temporaryMeltableCache.contains(blockPos.method_10063());
    }

    public static PlacedMeltablesState getPlacedMeltablesState(class_3218 world) {
        return (PlacedMeltablesState)world.method_17983().method_17924(PlacedMeltablesState::createFromNbt, PlacedMeltablesState::new, "seasons_placed_meltables");
    }

    public static ReplacedMeltablesState getReplacedMeltablesState(class_3218 world) {
        return (ReplacedMeltablesState)world.method_17983().method_17924(ReplacedMeltablesState::createFromNbt, ReplacedMeltablesState::new, "seasons_replaced_meltables");
    }

    public static long getTimeToNextSeason(class_1937 world) {
        long springLength = CONFIG.getSpringLength();
        long summerLength = CONFIG.getSummerLength();
        long fallLength = CONFIG.getFallLength();
        long winterLength = CONFIG.getWinterLength();
        class_5321 dimension = world.method_27983();
        if (CONFIG.isValidInDimension((class_5321<class_1937>)dimension) && !CONFIG.isSeasonLocked()) {
            if (CONFIG.isSeasonTiedWithSystemTime()) {
                return FabricSeasons.getTimeToNextSystemSeason() * 24000L;
            }
            Season currentSeason = FabricSeasons.getCurrentSeason(world);
            long[] seasonLengthArray = new long[]{springLength, summerLength, fallLength, winterLength};
            Season[] seasonArray = new Season[]{Season.SPRING, Season.SUMMER, Season.FALL, Season.WINTER};
            int startSeasonIndex = switch (CONFIG.getStartingSeason()) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> 0;
                case Season.SUMMER -> 1;
                case Season.FALL -> 2;
                case Season.WINTER -> 3;
            };
            long season1LimitYTD = seasonLengthArray[startSeasonIndex];
            long season2LimitYTD = season1LimitYTD + seasonLengthArray[(startSeasonIndex + 1) % 4];
            long season3LimitYTD = season2LimitYTD + seasonLengthArray[(startSeasonIndex + 2) % 4];
            long yearLength = season3LimitYTD + seasonLengthArray[(startSeasonIndex + 3) % 4];
            long timeOfYear = world.method_8532() % yearLength;
            if (currentSeason == seasonArray[startSeasonIndex]) {
                return season1LimitYTD - timeOfYear;
            }
            if (currentSeason == seasonArray[(startSeasonIndex + 1) % 4]) {
                return season2LimitYTD - timeOfYear;
            }
            if (currentSeason == seasonArray[(startSeasonIndex + 2) % 4]) {
                return season3LimitYTD - timeOfYear;
            }
            if (currentSeason == seasonArray[(startSeasonIndex + 3) % 4]) {
                return yearLength - timeOfYear;
            }
        }
        return Long.MAX_VALUE;
    }

    public static Season getNextSeason(class_1937 world, Season currentSeason) {
        class_5321 dimension = world.method_27983();
        if (CONFIG.isValidInDimension((class_5321<class_1937>)dimension)) {
            if (CONFIG.isSeasonLocked()) {
                return CONFIG.getLockedSeason();
            }
            if (CONFIG.isSeasonTiedWithSystemTime()) {
                return FabricSeasons.getCurrentSystemSeason().getNext();
            }
            return switch (FabricSeasons.getCurrentSeason(world)) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> Season.SUMMER;
                case Season.SUMMER -> Season.FALL;
                case Season.FALL -> Season.WINTER;
                case Season.WINTER -> Season.SPRING;
            };
        }
        return Season.SPRING;
    }

    public static Season getCurrentSeason(class_1937 world) {
        long springLength = CONFIG.getSpringLength();
        long summerLength = CONFIG.getSummerLength();
        long fallLength = CONFIG.getFallLength();
        long winterLength = CONFIG.getWinterLength();
        class_5321 dimension = world.method_27983();
        if (CONFIG.isValidInDimension((class_5321<class_1937>)dimension)) {
            if (CONFIG.isSeasonLocked()) {
                return CONFIG.getLockedSeason();
            }
            if (CONFIG.isSeasonTiedWithSystemTime()) {
                return FabricSeasons.getCurrentSystemSeason();
            }
            if (CONFIG.isValidStartingSeason() && springLength >= 0L && summerLength >= 0L && fallLength >= 0L && winterLength >= 0L) {
                long[] seasonLengthArray = new long[]{springLength, summerLength, fallLength, winterLength};
                Season[] seasonArray = new Season[]{Season.SPRING, Season.SUMMER, Season.FALL, Season.WINTER};
                int startSeasonIndex = switch (CONFIG.getStartingSeason()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Season.SPRING -> 0;
                    case Season.SUMMER -> 1;
                    case Season.FALL -> 2;
                    case Season.WINTER -> 3;
                };
                long season1LimitYTD = seasonLengthArray[startSeasonIndex];
                long season2LimitYTD = season1LimitYTD + seasonLengthArray[(startSeasonIndex + 1) % 4];
                long season3LimitYTD = season2LimitYTD + seasonLengthArray[(startSeasonIndex + 2) % 4];
                long yearLength = season3LimitYTD + seasonLengthArray[(startSeasonIndex + 3) % 4];
                long timeOfYear = world.method_8532() % yearLength;
                if (timeOfYear < season1LimitYTD) {
                    return seasonArray[startSeasonIndex];
                }
                if (timeOfYear < season2LimitYTD) {
                    return seasonArray[(startSeasonIndex + 1) % 4];
                }
                if (timeOfYear < season3LimitYTD) {
                    return seasonArray[(startSeasonIndex + 2) % 4];
                }
                if (timeOfYear < yearLength) {
                    return seasonArray[(startSeasonIndex + 3) % 4];
                }
            }
        }
        return Season.SPRING;
    }

    @Environment(value=EnvType.CLIENT)
    public static Season getCurrentSeason() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player != null && player.method_37908() != null) {
            return FabricSeasons.getCurrentSeason(player.method_37908());
        }
        return Season.SPRING;
    }

    private static long getTimeToNextSystemSeason() {
        LocalDateTime nextSeasonStart;
        LocalDateTime now = LocalDateTime.now();
        Season currentSeason = FabricSeasons.getCurrentSystemSeason();
        if (CONFIG.isInNorthHemisphere()) {
            nextSeasonStart = switch (currentSeason) {
                default -> throw new IncompatibleClassChangeError();
                case Season.WINTER -> LocalDateTime.of(now.getYear(), 3, 20, 0, 0);
                case Season.SPRING -> LocalDateTime.of(now.getYear(), 6, 21, 0, 0);
                case Season.SUMMER -> LocalDateTime.of(now.getYear(), 9, 22, 0, 0);
                case Season.FALL -> LocalDateTime.of(now.getYear(), 12, 21, 0, 0);
            };
        } else {
            nextSeasonStart = switch (currentSeason) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SUMMER -> LocalDateTime.of(now.getYear(), 3, 20, 0, 0);
                case Season.FALL -> LocalDateTime.of(now.getYear(), 6, 21, 0, 0);
                case Season.WINTER -> LocalDateTime.of(now.getYear(), 9, 22, 0, 0);
                case Season.SPRING -> LocalDateTime.of(now.getYear(), 12, 21, 0, 0);
            };
        }
        Duration timeToNextSeason = Duration.between(now, nextSeasonStart);
        return timeToNextSeason.toDays();
    }

    private static Season getCurrentSystemSeason() {
        Season season;
        LocalDateTime date = LocalDateTime.now();
        int m = date.getMonthValue();
        int d = date.getDayOfMonth();
        if (CONFIG.isInNorthHemisphere()) {
            season = m == 1 || m == 2 || m == 3 ? Season.WINTER : (m == 4 || m == 5 || m == 6 ? Season.SPRING : (m == 7 || m == 8 || m == 9 ? Season.SUMMER : Season.FALL));
            if (m == 3 && d > 19) {
                season = Season.SPRING;
            } else if (m == 6 && d > 20) {
                season = Season.SUMMER;
            } else if (m == 9 && d > 21) {
                season = Season.FALL;
            } else if (m == 12 && d > 20) {
                season = Season.WINTER;
            }
        } else {
            season = m == 1 || m == 2 || m == 3 ? Season.SUMMER : (m == 4 || m == 5 || m == 6 ? Season.FALL : (m == 7 || m == 8 || m == 9 ? Season.WINTER : Season.SPRING));
            if (m == 3 && d > 19) {
                season = Season.FALL;
            } else if (m == 6 && d > 20) {
                season = Season.WINTER;
            } else if (m == 9 && d > 21) {
                season = Season.SPRING;
            } else if (m == 12 && d > 20) {
                season = Season.SUMMER;
            }
        }
        return season;
    }

    public static void injectBiomeTemperature(class_6880<class_1959> entry, class_1937 world) {
        if (entry.method_40220(IGNORED_CATEGORIES_TAG)) {
            return;
        }
        class_1959 biome = (class_1959)entry.comp_349();
        class_2960 biomeId = entry.method_40230().orElse(class_1972.field_9451).method_29177();
        if (!CONFIG.doTemperatureChanges(biomeId)) {
            return;
        }
        class_1959.class_5482 currentWeather = biome.field_26393;
        class_1959.class_5482 originalWeather = ((BiomeMixed)biome).getOriginalWeather();
        if (originalWeather == null) {
            originalWeather = new class_1959.class_5482(currentWeather.comp_1187(), currentWeather.comp_844(), currentWeather.comp_845(), currentWeather.comp_846());
            ((BiomeMixed)biome).setOriginalWeather(originalWeather);
        }
        Season season = FabricSeasons.getCurrentSeason(world);
        class_3545<Boolean, Float> modifiedWeather = FabricSeasons.getSeasonWeather(season, biomeId, originalWeather.comp_1187, originalWeather.comp_844);
        currentWeather.comp_1187 = (Boolean)modifiedWeather.method_15442();
        currentWeather.comp_844 = ((Float)modifiedWeather.method_15441()).floatValue();
    }

    public static class_3545<Boolean, Float> getSeasonWeather(Season season, class_2960 biomeId, Boolean hasPrecipitation, float temp) {
        if (!CONFIG.doTemperatureChanges(biomeId)) {
            return new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp));
        }
        if (CONFIG.isSnowForcedInBiome(biomeId) && season == Season.WINTER) {
            return new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(0.14f));
        }
        if ((double)temp <= -0.51) {
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> {
                    if (CONFIG.isFallAndSpringReversed()) {
                        yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.3f));
                    }
                    yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp));
                }
                case Season.SUMMER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp + 0.84f));
                case Season.WINTER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.7f));
                case Season.FALL -> CONFIG.isFallAndSpringReversed() ? new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp)) : new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.3f));
            };
        }
        if ((double)temp <= 0.15) {
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> {
                    if (CONFIG.isFallAndSpringReversed()) {
                        yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.25f));
                    }
                    yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp));
                }
                case Season.SUMMER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp + (CONFIG.shouldSnowyBiomesMeltInSummer() ? 0.66f : 0.0f)));
                case Season.WINTER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.75f));
                case Season.FALL -> CONFIG.isFallAndSpringReversed() ? new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp)) : new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.25f));
            };
        }
        if ((double)temp <= 0.49) {
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> {
                    if (CONFIG.isFallAndSpringReversed()) {
                        yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.16f));
                    }
                    yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp));
                }
                case Season.SUMMER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp + 0.66f));
                case Season.WINTER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.8f));
                case Season.FALL -> CONFIG.isFallAndSpringReversed() ? new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp)) : new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.16f));
            };
        }
        if ((double)temp <= 0.79) {
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> {
                    if (CONFIG.isFallAndSpringReversed()) {
                        yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.34f));
                    }
                    yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp));
                }
                case Season.SUMMER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp + 0.46f));
                case Season.WINTER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.56f));
                case Season.FALL -> CONFIG.isFallAndSpringReversed() ? new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp)) : new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.34f));
            };
        }
        return switch (season) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING -> {
                if (CONFIG.isFallAndSpringReversed()) {
                    yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.34f));
                }
                yield new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp));
            }
            case Season.SUMMER -> new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp + 0.4f));
            case Season.WINTER -> new class_3545((Object)true, (Object)Float.valueOf(temp - 0.64f));
            case Season.FALL -> CONFIG.isFallAndSpringReversed() ? new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp)) : new class_3545((Object)hasPrecipitation, (Object)Float.valueOf(temp - 0.34f));
        };
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        SEEDS_MAP = new HashMap();
        ASK_FOR_CONFIG = new ModIdentifier("ask_for_config");
        ANSWER_CONFIG = new ModIdentifier("anwer_config");
        UPDATE_CROPS = new ModIdentifier("update_crops");
        IGNORED_CATEGORIES_TAG = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(MOD_ID, "ignored"));
    }
}

