/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.data.materialoverrides;

import aiefu.eso.ESOCommon;
import aiefu.eso.data.materialoverrides.MaterialData;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MaterialOverrides {
    public static final MaterialData defaultMatData = new MaterialData(ESOCommon.config.maxEnchantments, ESOCommon.config.maxCurses, ESOCommon.config.enchantmentLimitIncreasePerCurse);
    public HashMap<class_1792, MaterialData> toolsMatOverridesCompiled = new HashMap();
    public HashMap<class_1792, MaterialData> armorMatOverridesCompiled = new HashMap();
    public HashMap<class_1792, MaterialData> hardOverridesCompiled = new HashMap();

    public MaterialOverrides(HashMap<String, MaterialData> toolsMatOverrides, HashMap<String, MaterialData> armorMatOverrides, HashMap<String, MaterialData> hardOverrides) {
        hardOverrides.forEach((k, v) -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(k));
            if (item != class_1802.field_8162) {
                this.hardOverridesCompiled.put(item, (MaterialData)v);
            }
        });
        for (class_1792 item : class_7923.field_41178) {
            class_1738 am;
            MaterialData data;
            if (item instanceof class_1831) {
                String name;
                MaterialData data2;
                String string;
                class_1831 ti = (class_1831)item;
                class_1832 mat = ti.method_8022();
                if (mat instanceof Enum) {
                    Enum e = (Enum)mat;
                    string = e.name();
                } else {
                    string = mat.getClass().getSimpleName();
                }
                if ((data2 = toolsMatOverrides.get(name = string)) == null) continue;
                this.toolsMatOverridesCompiled.put(item, data2);
                continue;
            }
            if (!(item instanceof class_1738) || (data = armorMatOverrides.get((am = (class_1738)item).method_7686().method_7694())) == null) continue;
            this.armorMatOverridesCompiled.put(item, data);
        }
    }

    public MaterialOverrides() {
    }

    public MaterialData getMaterialData(class_1792 item) {
        MaterialData data = this.hardOverridesCompiled.get(item);
        if (data != null) {
            return data;
        }
        if (item instanceof class_1831) {
            data = this.toolsMatOverridesCompiled.get(item);
        } else if (item instanceof class_1738) {
            data = this.armorMatOverridesCompiled.get(item);
        }
        if (data != null) {
            return data;
        }
        return defaultMatData;
    }

    public static void generateDefault() throws IOException {
        String items;
        String armor;
        Path folder = Paths.get("./config/eso/material-overrides", new String[0]);
        if (!Files.exists(folder, new LinkOption[0])) {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        Gson gson = ESOCommon.getGson();
        String tools = "./config/eso/material-overrides/tools.json";
        if (!Files.exists(Paths.get(tools, new String[0]), new LinkOption[0])) {
            HashMap<String, MaterialData> toolsMatOverrides = new HashMap<String, MaterialData>();
            toolsMatOverrides.put("WOOD", new MaterialData(4, 1, 1));
            toolsMatOverrides.put("STONE", new MaterialData(2, 1, 1));
            toolsMatOverrides.put("IRON", new MaterialData(3, 1, 1));
            toolsMatOverrides.put("DIAMOND", new MaterialData(4, 1, 1));
            toolsMatOverrides.put("GOLD", new MaterialData(6, 1, 1));
            toolsMatOverrides.put("NETHERITE", new MaterialData(5, 1, 1));
            try (FileWriter writer = new FileWriter(tools);){
                gson.toJson(toolsMatOverrides, (Appendable)writer);
            }
        }
        if (!Files.exists(Paths.get(armor = "./config/eso/material-overrides/armor.json", new String[0]), new LinkOption[0])) {
            HashMap<String, MaterialData> armorMatOverrides = new HashMap<String, MaterialData>();
            armorMatOverrides.put("leather", new MaterialData(5, 1, 1));
            armorMatOverrides.put("chainmail", new MaterialData(4, 1, 1));
            armorMatOverrides.put("iron", new MaterialData(3, 1, 1));
            armorMatOverrides.put("gold", new MaterialData(6, 1, 1));
            armorMatOverrides.put("diamond", new MaterialData(4, 1, 1));
            armorMatOverrides.put("turtle", new MaterialData(5, 1, 1));
            armorMatOverrides.put("netherite", new MaterialData(5, 1, 1));
            try (FileWriter writer = new FileWriter(armor);){
                gson.toJson(armorMatOverrides, (Appendable)writer);
            }
        }
        if (!Files.exists(Paths.get(items = "./config/eso/material-overrides/items.json", new String[0]), new LinkOption[0])) {
            HashMap<String, MaterialData> hardOverrides = new HashMap<String, MaterialData>();
            hardOverrides.put("minecraft:fishing_rod", new MaterialData(5, 1, 1));
            hardOverrides.put("minecraft:bow", new MaterialData(4, 1, 1));
            hardOverrides.put("minecraft:crossbow", new MaterialData(4, 1, 1));
            hardOverrides.put("minecraft:trident", new MaterialData(4, 1, 1));
            try (FileWriter writer = new FileWriter(items);){
                gson.toJson(hardOverrides, (Appendable)writer);
            }
        }
    }

    public static MaterialOverrides read() throws FileNotFoundException {
        Gson gson = ESOCommon.getGson();
        Type type = new TypeToken<HashMap<String, MaterialData>>(){}.getType();
        HashMap toolsMat = (HashMap)gson.fromJson((Reader)new FileReader("./config/eso/material-overrides/tools.json"), type);
        HashMap armorMat = (HashMap)gson.fromJson((Reader)new FileReader("./config/eso/material-overrides/armor.json"), type);
        HashMap hardOverrides = (HashMap)gson.fromJson((Reader)new FileReader("./config/eso/material-overrides/items.json"), type);
        return new MaterialOverrides(toolsMat, armorMat, hardOverrides);
    }

    public static MaterialOverrides readWithAttachments(HashMap<String, MaterialData> tools, HashMap<String, MaterialData> armor, HashMap<String, MaterialData> items) throws FileNotFoundException {
        Gson gson = ESOCommon.getGson();
        Type type = new TypeToken<HashMap<String, MaterialData>>(){}.getType();
        HashMap toolsMat = (HashMap)gson.fromJson((Reader)new FileReader("./config/eso/material-overrides/tools.json"), type);
        HashMap armorMat = (HashMap)gson.fromJson((Reader)new FileReader("./config/eso/material-overrides/armor.json"), type);
        HashMap hardOverrides = (HashMap)gson.fromJson((Reader)new FileReader("./config/eso/material-overrides/items.json"), type);
        tools.putAll(toolsMat);
        armor.putAll(armorMat);
        items.putAll(hardOverrides);
        return new MaterialOverrides(tools, armor, items);
    }

    public static MaterialOverrides reconstructFromPacket(HashMap<String, MaterialData> tools, HashMap<String, MaterialData> armor, HashMap<String, MaterialData> items) {
        HashMap toolsOverrides = new HashMap();
        tools.forEach((k, v) -> {
            class_1792 i = (class_1792)class_7923.field_41178.method_10223(new class_2960(k));
            toolsOverrides.put(i, v);
        });
        HashMap armorOverrides = new HashMap();
        armor.forEach((k, v) -> {
            class_1792 i = (class_1792)class_7923.field_41178.method_10223(new class_2960(k));
            armorOverrides.put(i, v);
        });
        HashMap hardOverrides = new HashMap();
        items.forEach((k, v) -> {
            class_1792 i = (class_1792)class_7923.field_41178.method_10223(new class_2960(k));
            hardOverrides.put(i, v);
        });
        MaterialOverrides m = new MaterialOverrides();
        m.hardOverridesCompiled = hardOverrides;
        m.toolsMatOverridesCompiled = toolsOverrides;
        m.armorMatOverridesCompiled = armorOverrides;
        return m;
    }
}

