/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.data.itemdata;

import aiefu.eso.Utils;
import aiefu.eso.client.gui.EnchantingTableScreen;
import aiefu.eso.data.itemdata.ItemDataPrepared;
import aiefu.eso.data.itemdata.RecipeViewerItemData;
import net.minecraft.class_1657;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class RecipeViewerData {
    protected ItemDataPrepared[] itemData = new ItemDataPrepared[0];
    protected RecipeViewerItemData[] cachedStacks;
    protected final class_1887 enchantment;
    protected class_1799 resultStack;
    protected int xp = 0;
    protected int lvl;
    protected boolean mode;
    protected class_2561 desc;

    public RecipeViewerData(ItemDataPrepared[] itemData, int lvl, class_1887 enchantment, boolean mode) {
        this.itemData = itemData;
        this.lvl = lvl;
        this.enchantment = enchantment;
        this.mode = mode;
        this.cacheItemStacks(itemData);
        this.composeDescription();
    }

    public RecipeViewerData(int xp, int lvl, class_1887 enchantment, boolean mode) {
        this.xp = xp;
        this.lvl = lvl;
        this.enchantment = enchantment;
        this.mode = mode;
        this.cacheItemStacks(null);
        this.composeDescription();
    }

    public RecipeViewerData(ItemDataPrepared[] itemData, int xp, int lvl, class_1887 enchantment, boolean mode) {
        this.itemData = itemData;
        this.xp = xp;
        this.lvl = lvl;
        this.enchantment = enchantment;
        this.mode = mode;
        this.cacheItemStacks(itemData);
        this.composeDescription();
    }

    public ItemDataPrepared[] getItemData() {
        return this.itemData;
    }

    public int getXp() {
        return this.xp;
    }

    public void setItemData(ItemDataPrepared[] itemData) {
        this.itemData = itemData;
        this.cacheItemStacks(itemData);
    }

    public void setXp(int xp) {
        this.xp = xp;
        this.composeDescription();
    }

    public void cacheItemStacks(ItemDataPrepared[] prepared) {
        RecipeViewerItemData[] data;
        if (prepared != null) {
            data = new RecipeViewerItemData[prepared.length];
            for (int i = 0; i < prepared.length; ++i) {
                data[i] = new RecipeViewerItemData(prepared[i]);
            }
        } else {
            data = new RecipeViewerItemData[]{};
        }
        this.cachedStacks = data;
        this.resultStack = new class_1799((class_1935)class_1802.field_8598, 1);
        class_1772.method_7807((class_1799)this.resultStack, (class_1889)new class_1889(this.enchantment, this.lvl));
    }

    public void composeDescription() {
        class_746 player = class_310.method_1551().field_1724;
        class_5250 c = class_2561.method_43469((String)"eso.rv.level", (Object[])new Object[]{this.lvl});
        if (this.xp > 0) {
            if (this.mode) {
                int totalXP = Utils.getTotalAvailableXPPoints((class_1657)player);
                c.method_10852(class_5244.field_41874);
                c.method_10852((class_2561)class_2561.method_43469((String)"eso.rv.xpreql", (Object[])new Object[]{this.xp, EnchantingTableScreen.getFormatter().format(Utils.getXPCostInLevels((class_1657)player, this.xp, totalXP))}));
            } else {
                c.method_10852(class_5244.field_41874);
                c.method_10852((class_2561)class_2561.method_43469((String)"eso.rv.xpreqp", (Object[])new Object[]{this.xp}));
            }
        }
        this.desc = c;
    }

    public class_1799 getResultStack() {
        return this.resultStack;
    }

    public RecipeViewerItemData[] getCachedStacks() {
        return this.cachedStacks;
    }

    public int getLvl() {
        return this.lvl;
    }

    public boolean isMode() {
        return this.mode;
    }

    public class_2561 getDesc() {
        return this.desc;
    }
}

